/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.BasePlugin;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.sdk.DefaultSdkLoader;
import com.android.builder.sdk.PlatformLoader;
import com.android.builder.sdk.SdkInfo;
import com.android.builder.sdk.SdkLoader;
import com.android.builder.sdk.TargetInfo;
import com.android.sdklib.repository.FullRevision;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.gradle.api.Project;

public class SdkHandler {
    @NonNull
    private final ILogger logger;
    private SdkLoader sdkLoader;
    private File sdkFolder;
    private File ndkFolder;
    private boolean isRegularSdk = true;

    public SdkHandler(@NonNull Project project, @NonNull ILogger logger) {
        this.logger = logger;
        this.findLocation(project);
    }

    public SdkInfo getSdkInfo() {
        SdkLoader sdkLoader = this.getSdkLoader();
        return sdkLoader.getSdkInfo(this.logger);
    }

    public void initTarget(String targetHash, FullRevision buildToolRevision, @NonNull AndroidBuilder androidBuilder) {
        if (targetHash == null) {
            throw new IllegalArgumentException("android.compileSdkVersion is missing!");
        }
        if (buildToolRevision == null) {
            throw new IllegalArgumentException("android.buildToolsVersion is missing!");
        }
        SdkLoader sdkLoader = this.getSdkLoader();
        SdkInfo sdkInfo = sdkLoader.getSdkInfo(this.logger);
        TargetInfo targetInfo = sdkLoader.getTargetInfo(targetHash, buildToolRevision, this.logger);
        androidBuilder.setTargetInfo(sdkInfo, targetInfo);
    }

    @Nullable
    public File getSdkFolder() {
        return this.sdkFolder;
    }

    @Nullable
    public File getAndCheckSdkFolder() {
        if (this.sdkFolder == null) {
            throw new RuntimeException("SDK location not found. Define location with sdk.dir in the local.properties file or with an ANDROID_HOME environment variable.");
        }
        return this.sdkFolder;
    }

    public synchronized SdkLoader getSdkLoader() {
        if (this.sdkLoader == null) {
            if (this.isRegularSdk) {
                this.getAndCheckSdkFolder();
                if (BasePlugin.TEST_SDK_DIR == null && !this.sdkFolder.isDirectory()) {
                    throw new RuntimeException(String.format("The SDK directory '%s' does not exist.", this.sdkFolder));
                }
                this.sdkLoader = DefaultSdkLoader.getLoader((File)this.sdkFolder);
            } else {
                this.sdkLoader = PlatformLoader.getLoader((File)this.sdkFolder);
            }
        }
        return this.sdkLoader;
    }

    public synchronized void unload() {
        if (this.sdkLoader != null) {
            if (this.isRegularSdk) {
                DefaultSdkLoader.unload();
            } else {
                PlatformLoader.unload();
            }
            this.sdkLoader = null;
        }
    }

    @Nullable
    public File getNdkFolder() {
        return this.ndkFolder;
    }

    private void findSdkLocation(@NonNull Properties properties, @NonNull File rootDir) {
        String sdkDirProp = properties.getProperty("sdk.dir");
        if (sdkDirProp != null) {
            this.sdkFolder = new File(sdkDirProp);
            return;
        }
        sdkDirProp = properties.getProperty("android.dir");
        if (sdkDirProp != null) {
            this.sdkFolder = new File(rootDir, sdkDirProp);
            this.isRegularSdk = false;
            return;
        }
        String envVar = System.getenv("ANDROID_HOME");
        if (envVar != null) {
            this.sdkFolder = new File(envVar);
            return;
        }
        String property = System.getProperty("android.home");
        if (property != null) {
            this.sdkFolder = new File(property);
        }
    }

    private void findNdkLocation(@NonNull Properties properties) {
        String ndkDirProp = properties.getProperty("ndk.dir");
        if (ndkDirProp != null) {
            this.ndkFolder = new File(ndkDirProp);
            return;
        }
        String envVar = System.getenv("ANDROID_NDK_HOME");
        if (envVar != null) {
            this.ndkFolder = new File(envVar);
        }
    }

    /*
     * Loose catch block
     */
    private void findLocation(@NonNull Project project) {
        Properties properties;
        File rootDir;
        block14: {
            if (BasePlugin.TEST_SDK_DIR != null) {
                this.sdkFolder = BasePlugin.TEST_SDK_DIR;
                return;
            }
            rootDir = project.getRootDir();
            File localProperties = new File(rootDir, "local.properties");
            properties = new Properties();
            if (localProperties.isFile()) {
                InputStreamReader reader = null;
                FileInputStream fis = new FileInputStream(localProperties);
                reader = new InputStreamReader((InputStream)fis, Charsets.UTF_8);
                properties.load(reader);
                try {
                    Closeables.close((Closeable)reader, (boolean)true);
                }
                catch (IOException e) {}
                break block14;
                catch (FileNotFoundException ignored) {
                    try {
                        Closeables.close(reader, (boolean)true);
                    }
                    catch (IOException e) {}
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to read ${localProperties}", e);
                    {
                        catch (Throwable throwable) {
                            try {
                                Closeables.close(reader, (boolean)true);
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                }
            }
        }
        this.findSdkLocation(properties, rootDir);
        this.findNdkLocation(properties);
    }
}

