/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.annotations.NonNull;
import com.android.build.gradle.api.AndroidSourceDirectorySet;
import com.android.build.gradle.api.AndroidSourceFile;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.api.DefaultAndroidSourceDirectorySet;
import com.android.build.gradle.internal.api.DefaultAndroidSourceFile;
import com.android.builder.model.SourceProvider;
import groovy.lang.Closure;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.GUtil;

public class DefaultAndroidSourceSet
implements AndroidSourceSet,
SourceProvider {
    @NonNull
    private final String name;
    private final boolean isLibrary;
    private final AndroidSourceDirectorySet javaSource;
    private final AndroidSourceDirectorySet javaResources;
    private final AndroidSourceFile manifest;
    private final AndroidSourceDirectorySet assets;
    private final AndroidSourceDirectorySet res;
    private final AndroidSourceDirectorySet aidl;
    private final AndroidSourceDirectorySet renderscript;
    private final AndroidSourceDirectorySet jni;
    private final AndroidSourceDirectorySet jniLibs;
    private final String displayName;

    public DefaultAndroidSourceSet(@NonNull String name, Project project, boolean isLibrary) {
        this.name = name;
        this.isLibrary = isLibrary;
        this.displayName = GUtil.toWords((CharSequence)this.name);
        String javaSrcDisplayName = String.format("%s Java source", this.displayName);
        this.javaSource = new DefaultAndroidSourceDirectorySet(javaSrcDisplayName, project);
        this.javaSource.getFilter().include(new String[]{"**/*.java"});
        String javaResourcesDisplayName = String.format("%s Java resources", this.displayName);
        this.javaResources = new DefaultAndroidSourceDirectorySet(javaResourcesDisplayName, project);
        this.javaResources.getFilter().exclude(new String[]{"**/*.java"});
        String manifestDisplayName = String.format("%s manifest", this.displayName);
        this.manifest = new DefaultAndroidSourceFile(manifestDisplayName, project);
        String assetsDisplayName = String.format("%s assets", this.displayName);
        this.assets = new DefaultAndroidSourceDirectorySet(assetsDisplayName, project);
        String resourcesDisplayName = String.format("%s resources", this.displayName);
        this.res = new DefaultAndroidSourceDirectorySet(resourcesDisplayName, project);
        String aidlDisplayName = String.format("%s aidl", this.displayName);
        this.aidl = new DefaultAndroidSourceDirectorySet(aidlDisplayName, project);
        String renderscriptDisplayName = String.format("%s renderscript", this.displayName);
        this.renderscript = new DefaultAndroidSourceDirectorySet(renderscriptDisplayName, project);
        String jniDisplayName = String.format("%s jni", this.displayName);
        this.jni = new DefaultAndroidSourceDirectorySet(jniDisplayName, project);
        String libsDisplayName = String.format("%s jniLibs", this.displayName);
        this.jniLibs = new DefaultAndroidSourceDirectorySet(libsDisplayName, project);
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String toString() {
        return String.format("source set %s", this.getDisplayName());
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @NonNull
    public String getCompileConfigurationName() {
        if (this.name.equals("main")) {
            return "compile";
        }
        return String.format("%sCompile", this.name);
    }

    @Override
    @NonNull
    public String getPackageConfigurationName() {
        if (this.isLibrary) {
            if (this.name.equals("main")) {
                return "publish";
            }
            return String.format("%sPublish", this.name);
        }
        if (this.name.equals("main")) {
            return "apk";
        }
        return String.format("%sApk", this.name);
    }

    @Override
    @NonNull
    public String getProvidedConfigurationName() {
        if (this.name.equals("main")) {
            return "provided";
        }
        return String.format("%sProvided", this.name);
    }

    @Override
    @NonNull
    public AndroidSourceFile getManifest() {
        return this.manifest;
    }

    @Override
    @NonNull
    public AndroidSourceSet manifest(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getManifest());
        return this;
    }

    @Override
    @NonNull
    public AndroidSourceDirectorySet getRes() {
        return this.res;
    }

    @Override
    @NonNull
    public AndroidSourceSet res(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getRes());
        return this;
    }

    @Override
    @NonNull
    public AndroidSourceDirectorySet getAssets() {
        return this.assets;
    }

    @Override
    @NonNull
    public AndroidSourceSet assets(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getAssets());
        return this;
    }

    @Override
    @NonNull
    public AndroidSourceDirectorySet getAidl() {
        return this.aidl;
    }

    @Override
    @NonNull
    public AndroidSourceSet aidl(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getAidl());
        return this;
    }

    @Override
    @NonNull
    public AndroidSourceDirectorySet getRenderscript() {
        return this.renderscript;
    }

    @Override
    @NonNull
    public AndroidSourceSet renderscript(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getRenderscript());
        return this;
    }

    @Override
    @NonNull
    public AndroidSourceDirectorySet getJni() {
        return this.jni;
    }

    @Override
    @NonNull
    public AndroidSourceSet jni(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getJni());
        return this;
    }

    @Override
    @NonNull
    public AndroidSourceDirectorySet getJniLibs() {
        return this.jniLibs;
    }

    @Override
    @NonNull
    public AndroidSourceSet jniLibs(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getJniLibs());
        return this;
    }

    @Override
    @NonNull
    public AndroidSourceDirectorySet getJava() {
        return this.javaSource;
    }

    @Override
    @NonNull
    public AndroidSourceSet java(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getJava());
        return this;
    }

    @Override
    @NonNull
    public AndroidSourceDirectorySet getResources() {
        return this.javaResources;
    }

    @Override
    @NonNull
    public AndroidSourceSet resources(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getResources());
        return this;
    }

    @Override
    @NonNull
    public AndroidSourceSet setRoot(String path) {
        this.javaSource.setSrcDirs(Collections.singletonList(path + "/java"));
        this.javaResources.setSrcDirs(Collections.singletonList(path + "/resources"));
        this.res.setSrcDirs(Collections.singletonList(path + "/" + "res"));
        this.assets.setSrcDirs(Collections.singletonList(path + "/" + "assets"));
        this.manifest.srcFile(path + "/" + "AndroidManifest.xml");
        this.aidl.setSrcDirs(Collections.singletonList(path + "/aidl"));
        this.renderscript.setSrcDirs(Collections.singletonList(path + "/rs"));
        this.jni.setSrcDirs(Collections.singletonList(path + "/jni"));
        this.jniLibs.setSrcDirs(Collections.singletonList(path + "/jniLibs"));
        return this;
    }

    @NonNull
    public Set<File> getJavaDirectories() {
        return this.getJava().getSrcDirs();
    }

    @NonNull
    public Set<File> getResourcesDirectories() {
        return this.getResources().getSrcDirs();
    }

    @NonNull
    public File getManifestFile() {
        return this.getManifest().getSrcFile();
    }

    @NonNull
    public Set<File> getAidlDirectories() {
        return this.getAidl().getSrcDirs();
    }

    @NonNull
    public Set<File> getRenderscriptDirectories() {
        return this.getRenderscript().getSrcDirs();
    }

    @NonNull
    public Set<File> getJniDirectories() {
        return this.getJni().getSrcDirs();
    }

    @NonNull
    public Set<File> getResDirectories() {
        return this.getRes().getSrcDirs();
    }

    @NonNull
    public Set<File> getAssetsDirectories() {
        return this.getAssets().getSrcDirs();
    }

    @NonNull
    public Collection<File> getJniLibsDirectories() {
        return this.getJniLibs().getSrcDirs();
    }
}

