/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.ndk.internal;

import com.android.annotations.Nullable;
import com.android.build.gradle.ndk.NdkExtension;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.nativebinaries.BuildType;
import org.gradle.nativebinaries.platform.Platform;

public class NdkHandler {
    private static final Map<String, String> PLATFORM_STRING;
    private static final Map<String, String> ARCHITECTURE_STRING;
    private static final Map<String, String> TOOLCHAIN_STRING;
    private static final List<String> ABI32;
    private static final List<String> ALL_ABI;
    private NdkExtension ndkExtension;
    private Project project;
    private File ndkDirectory;

    public NdkHandler(Project project, NdkExtension ndkExtension) {
        this.project = project;
        this.ndkExtension = ndkExtension;
        this.ndkDirectory = NdkHandler.findNdkDirectory(project);
    }

    private static String getToolchainName(String toolchain, String toolchainVersion, String platform) {
        return PLATFORM_STRING.get(platform) + "-" + TOOLCHAIN_STRING.get(toolchain) + toolchainVersion;
    }

    /*
     * Loose catch block
     */
    private static File findNdkDirectory(Project project) {
        block16: {
            block14: {
                Properties properties;
                block15: {
                    File rootDir = project.getRootDir();
                    File localProperties = new File(rootDir, "local.properties");
                    if (!localProperties.isFile()) break block14;
                    properties = new Properties();
                    InputStreamReader reader = null;
                    FileInputStream fis = new FileInputStream(localProperties);
                    reader = new InputStreamReader((InputStream)fis, Charsets.UTF_8);
                    properties.load(reader);
                    try {
                        Closeables.close((Closeable)reader, (boolean)true);
                    }
                    catch (IOException e) {}
                    break block15;
                    catch (FileNotFoundException ignored) {
                        try {
                            Closeables.close(reader, (boolean)true);
                        }
                        catch (IOException e) {}
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unable to read ${localProperties}", e);
                        {
                            catch (Throwable throwable) {
                                try {
                                    Closeables.close(reader, (boolean)true);
                                }
                                catch (IOException e2) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                String ndkDirProp = properties.getProperty("ndk.dir");
                if (ndkDirProp != null) {
                    return new File(ndkDirProp);
                }
                break block16;
            }
            String envVar = System.getenv("ANDROID_NDK_HOME");
            if (envVar != null) {
                return new File(envVar);
            }
        }
        return null;
    }

    @Nullable
    public File getNdkDirectory() {
        return this.ndkDirectory;
    }

    NdkExtension getNdkExtension() {
        return this.ndkExtension;
    }

    public File getToolchainPath(String toolchain, String toolchainVersion, String platform) {
        File prebuiltFolder;
        if (toolchain.equals("gcc")) {
            prebuiltFolder = new File(this.getNdkDirectory(), "toolchains/" + NdkHandler.getToolchainName(toolchain, toolchainVersion, platform) + "/prebuilt");
        } else if (toolchain.equals("clang")) {
            prebuiltFolder = new File(this.getNdkDirectory(), "toolchains/llvm-" + toolchainVersion + "/prebuilt");
        } else {
            throw new InvalidUserDataException("Unrecognized toolchain: " + toolchain);
        }
        String osName = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        String hostOs = osName.contains("windows") ? "windows" : (osName.contains("mac") ? "darwin" : "linux");
        File toolchainPath = new File(prebuiltFolder, hostOs + "-x86_64");
        if (toolchainPath.isDirectory()) {
            return toolchainPath;
        }
        toolchainPath = new File(prebuiltFolder, hostOs);
        if (toolchainPath.isDirectory()) {
            return toolchainPath;
        }
        throw new InvalidUserDataException("Unable to find toolchain prebuilt folder in: " + prebuiltFolder);
    }

    public String getSysroot(Platform platform) {
        return this.ndkDirectory + "/platforms/" + this.ndkExtension.getCompileSdkVersion() + "/arch-" + ARCHITECTURE_STRING.get(platform.getName());
    }

    public File getOutputDirectory(BuildType buildType, Platform platform) {
        return new File(this.project.getBuildDir() + "/" + "intermediates" + "/binaries/", this.ndkExtension.getModuleName() + "SharedLibrary/" + buildType.getName() + "/lib/" + platform.getName());
    }

    public File getPrebuiltDirectory(Platform platform) {
        return new File(this.ndkDirectory, "prebuilt/android-" + ARCHITECTURE_STRING.get(platform.getName()));
    }

    public boolean supports64Bits() {
        String targetString = this.getNdkExtension().getCompileSdkVersion().replace("android-", "");
        try {
            return Integer.parseInt(targetString) >= 20;
        }
        catch (NumberFormatException ignored) {
            return true;
        }
    }

    public String getGccToolchainVersion() {
        if (this.ndkExtension.getToolchain().equals("gcc")) {
            return this.ndkExtension.getToolchainVersion();
        }
        return this.supports64Bits() ? "4.9" : "4.8";
    }

    public Collection<String> getSupportedAbis() {
        return this.supports64Bits() ? ALL_ABI : ABI32;
    }

    static {
        ABI32 = ImmutableList.of((Object)"x86", (Object)"armeabi-v7a", (Object)"armeabi", (Object)"mips");
        ALL_ABI = ImmutableList.of((Object)"x86", (Object)"x86_64", (Object)"armeabi-v7a", (Object)"armeabi", (Object)"arm64-v8a", (Object)"mips", (Object)"mips64");
        PLATFORM_STRING = ImmutableMap.builder().put((Object)"x86", (Object)"x86").put((Object)"x86_64", (Object)"x86_64").put((Object)"armeabi-v7a", (Object)"arm-linux-androideabi").put((Object)"armeabi", (Object)"arm-linux-androideabi").put((Object)"arm64-v8a", (Object)"aarch64-linux-android").put((Object)"mips", (Object)"mipsel-linux-android").put((Object)"mips64", (Object)"mips64el-linux-android").build();
        ARCHITECTURE_STRING = ImmutableMap.builder().put((Object)"x86", (Object)"x86").put((Object)"x86_64", (Object)"x86_64").put((Object)"armeabi-v7a", (Object)"arm").put((Object)"armeabi", (Object)"arm").put((Object)"arm64-v8a", (Object)"arm64").put((Object)"mips", (Object)"mips").put((Object)"mips64", (Object)"mips64").build();
        TOOLCHAIN_STRING = ImmutableMap.builder().put((Object)"gcc", (Object)"").put((Object)"clang", (Object)"clang").build();
    }
}

