/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.ndk.internal;

import com.android.build.gradle.ndk.internal.AbstractNativeToolSpecification;
import com.android.build.gradle.ndk.internal.NdkHandler;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.gradle.nativebinaries.platform.Platform;

public class StlNativeToolSpecification
extends AbstractNativeToolSpecification {
    private NdkHandler ndkHandler;
    private String stl;
    private String stlName;
    private Boolean isStatic;
    private Platform platform;

    StlNativeToolSpecification(NdkHandler ndkHandler, String stl, Platform platform) {
        this.ndkHandler = ndkHandler;
        this.stl = stl;
        this.stlName = stl.equals("system") ? stl : stl.substring(0, stl.indexOf(95));
        this.isStatic = stl.endsWith("_static");
        this.platform = platform;
    }

    @Override
    public Iterable<String> getCFlags() {
        return Collections.emptyList();
    }

    @Override
    public Iterable<String> getCppFlags() {
        ArrayList cppFlags = Lists.newArrayList();
        ArrayList includeDirs = Lists.newArrayList();
        if (this.stlName.equals("system")) {
            includeDirs.add("system/include");
        } else if (this.stlName.equals("stlport")) {
            includeDirs.add("stlport/stlport");
            includeDirs.add("gabi++/include");
        } else if (this.stlName.equals("gnustl")) {
            includeDirs.add("gnu-libstdc++/" + this.ndkHandler.getGccToolchainVersion() + "/include");
            includeDirs.add("gnu-libstdc++/" + this.ndkHandler.getGccToolchainVersion() + "/libs/" + this.platform.getName() + "/include");
            includeDirs.add("gnu-libstdc++/" + this.ndkHandler.getGccToolchainVersion() + "/include/backward");
        } else if (this.stlName.equals("gabi++")) {
            includeDirs.add("gabi++/include");
        } else if (this.stlName.equals("c++")) {
            includeDirs.add("llvm-libc++/libcxx/include");
            includeDirs.add("gabi++/include");
            includeDirs.add("../android/support/include");
            cppFlags.add("-std=c++11");
        }
        for (String dir : includeDirs) {
            cppFlags.add("-I" + new File(this.getStlBaseDirectory(), dir).toString());
        }
        return cppFlags;
    }

    @Override
    public Iterable<String> getLdFlags() {
        if (this.stl.equals("system")) {
            return Collections.emptyList();
        }
        ArrayList flags = Lists.newArrayList();
        flags.add(this.getStlLib().toString());
        return flags;
    }

    public File getStlBaseDirectory() {
        return new File(this.ndkHandler.getNdkDirectory(), "sources/cxx-stl/");
    }

    public File getStlLib() {
        String stlLib;
        if (this.stlName.equals("stlport")) {
            stlLib = "stlport";
        } else if (this.stlName.equals("gnustl")) {
            stlLib = "gnu-libstdc++/" + this.ndkHandler.getGccToolchainVersion();
        } else if (this.stlName.equals("gabi++")) {
            stlLib = "gabi++";
        } else if (this.stlName.equals("c++")) {
            stlLib = "llvm-libc++";
        } else {
            throw new AssertionError((Object)"Unreachable.  Either stl is invalid or stl is \"system\", in which case there is no library file and getStlLib should not be called.");
        }
        return new File(this.getStlBaseDirectory(), stlLib + "/libs/" + this.platform.getName() + "/lib" + this.stl + (this.isStatic != false ? ".a" : ".so"));
    }
}

