/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.resources.ResourceUrl;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ResourceUsageAnalyzer {
    public static final boolean TWO_PASS_AAPT = false;
    public static final int TYPICAL_RESOURCE_COUNT = 200;
    private final File mResourceClassDir;
    private final File mProguardMapping;
    private final File mClassesJar;
    private final File mMergedManifest;
    private final File mMergedResourceDir;
    private boolean mVerbose;
    private boolean mDebug;
    private boolean mDryRun;
    private List<Resource> mUnused;
    private List<Resource> mResources = Lists.newArrayListWithExpectedSize((int)200);
    private Map<Integer, Resource> mValueToResource = Maps.newHashMapWithExpectedSize((int)200);
    private Map<ResourceType, Map<String, Resource>> mTypeToName = Maps.newEnumMap(ResourceType.class);
    private Map<String, ResourceType> mResourceClassOwners = Maps.newHashMapWithExpectedSize((int)20);
    private Set<String> mStrings;
    private boolean mFoundGetIdentifier;

    public ResourceUsageAnalyzer(@NonNull File rDir, @NonNull File classesJar, @NonNull File manifest, @Nullable File mapping, @NonNull File resources) {
        this.mResourceClassDir = rDir;
        this.mProguardMapping = mapping;
        this.mClassesJar = classesJar;
        this.mMergedManifest = manifest;
        this.mMergedResourceDir = resources;
    }

    public void analyze() throws IOException, ParserConfigurationException, SAXException {
        this.gatherResourceValues(this.mResourceClassDir);
        this.recordMapping(this.mProguardMapping);
        this.recordUsages(this.mClassesJar);
        this.recordManifestUsages(this.mMergedManifest);
        this.recordResources(this.mMergedResourceDir);
        this.keepPossiblyReferencedResources();
        this.dumpReferences();
        this.findUnused();
    }

    public boolean isDryRun() {
        return this.mDryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.mDryRun = dryRun;
    }

    public boolean isVerbose() {
        return this.mVerbose;
    }

    public void setVerbose(boolean verbose) {
        this.mVerbose = verbose;
    }

    public boolean isDebug() {
        return this.mDebug;
    }

    public void setDebug(boolean verbose) {
        this.mDebug = verbose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewriteResourceZip(@NonNull File source, @NonNull File dest) throws IOException {
        boolean deleted;
        if (dest.exists() && !(deleted = dest.delete())) {
            throw new IOException("Could not delete " + dest);
        }
        JarInputStream zis = null;
        try {
            FileInputStream fis = new FileInputStream(source);
            try {
                FileOutputStream fos = new FileOutputStream(dest);
                zis = new JarInputStream(fis);
                JarOutputStream zos = new JarOutputStream(fos);
                try {
                    zos.setLevel(9);
                    ZipEntry entry = zis.getNextEntry();
                    while (entry != null) {
                        String name = entry.getName();
                        boolean directory = entry.isDirectory();
                        Resource resource = this.getResourceByJarPath(name);
                        if (resource == null || resource.reachable) {
                            byte[] bytes;
                            JarEntry outEntry = new JarEntry(entry.getName());
                            if (entry.getTime() != -1L) {
                                outEntry.setTime(entry.getTime());
                            }
                            zos.putNextEntry(outEntry);
                            if (!directory && (bytes = ByteStreams.toByteArray((InputStream)zis)) != null) {
                                zos.write(bytes);
                            }
                            zos.closeEntry();
                        } else if (this.isVerbose()) {
                            System.out.println("Skipped unused resource " + name + ": " + entry.getSize() + " bytes");
                        }
                        entry = zis.getNextEntry();
                    }
                    zos.flush();
                }
                finally {
                    Closeables.close((Closeable)zos, (boolean)false);
                }
            }
            finally {
                Closeables.close((Closeable)fis, (boolean)true);
            }
        }
        catch (Throwable throwable) {
            Closeables.close(zis, (boolean)false);
            throw throwable;
        }
        Closeables.close((Closeable)zis, (boolean)false);
    }

    public void removeUnused(@Nullable File destination) throws IOException, ParserConfigurationException, SAXException {
        assert (false);
    }

    private static void filteredCopy(File source, File destination, Set<File> skip, Map<File, String> replace) throws IOException {
        assert (false);
    }

    private void stripUnused(Element element, List<String> removed) {
        assert (false);
    }

    private static String getFieldName(Element element) {
        return ResourceUsageAnalyzer.getFieldName(element.getAttribute("name"));
    }

    @Nullable
    private Resource getResource(Element element) {
        ResourceType type = ResourceUsageAnalyzer.getResourceType(element);
        if (type != null) {
            String name = ResourceUsageAnalyzer.getFieldName(element);
            return this.getResource(type, name);
        }
        return null;
    }

    @Nullable
    private Resource getResourceByJarPath(String path) {
        int nameStart;
        int nameEnd;
        String folderName;
        ResourceFolderType folderType;
        int folderStart;
        int folderEnd;
        if (path.startsWith("res/") && (folderEnd = path.indexOf(47, folderStart = 4)) != -1 && (folderType = ResourceFolderType.getFolderType((String)(folderName = path.substring(folderStart, folderEnd)))) != null && (nameEnd = path.indexOf(46, nameStart = folderEnd + 1)) != -1) {
            String name = path.substring(nameStart, nameEnd);
            List types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
            for (ResourceType type : types) {
                Resource resource;
                if (type == ResourceType.ID || (resource = this.getResource(type, name)) == null) continue;
                return resource;
            }
        }
        return null;
    }

    private static ResourceType getResourceType(Element element) {
        String tagName = element.getTagName();
        if (tagName.equals("item")) {
            String typeName = element.getAttribute("type");
            if (!typeName.isEmpty()) {
                return ResourceType.getEnum((String)typeName);
            }
        } else {
            if ("string-array".equals(tagName) || "integer-array".equals(tagName)) {
                return ResourceType.ARRAY;
            }
            return ResourceType.getEnum((String)tagName);
        }
        return null;
    }

    private void findUnused() {
        ArrayList roots = Lists.newArrayList();
        for (Resource resource : this.mResources) {
            if (!resource.reachable || resource.type == ResourceType.ID || resource.type == ResourceType.ATTR) continue;
            roots.add(resource);
        }
        if (this.mDebug) {
            System.out.println("The root reachable resources are: " + Joiner.on((String)",\n   ").join((Iterable)roots));
        }
        IdentityHashMap<Resource, Boolean> seen = new IdentityHashMap<Resource, Boolean>(this.mResources.size());
        for (Resource root : roots) {
            ResourceUsageAnalyzer.visit(root, seen);
        }
        ArrayList unused = Lists.newArrayListWithExpectedSize((int)this.mResources.size());
        for (Resource resource : this.mResources) {
            if (resource.reachable || !resource.isRelevantType()) continue;
            unused.add(resource);
        }
        this.mUnused = unused;
    }

    private static void visit(Resource root, Map<Resource, Boolean> seen) {
        if (seen.containsKey(root)) {
            return;
        }
        seen.put(root, Boolean.TRUE);
        root.reachable = true;
        if (root.references != null) {
            for (Resource referenced : root.references) {
                ResourceUsageAnalyzer.visit(referenced, seen);
            }
        }
    }

    private void dumpReferences() {
        if (this.mDebug) {
            for (Resource resource : this.mResources) {
                if (resource.references == null) continue;
                System.out.println(resource + " => " + resource.references);
            }
        }
    }

    private void keepPossiblyReferencedResources() {
        if (!this.mFoundGetIdentifier || this.mStrings == null) {
            return;
        }
        if (this.mDebug) {
            ArrayList<String> strings = new ArrayList<String>(this.mStrings);
            Collections.sort(strings);
            System.out.println("android.content.res.Resources#getIdentifier present: " + this.mFoundGetIdentifier);
            System.out.println("Referenced Strings:");
            for (String s : strings) {
                if ((s = s.trim().replace("\n", "\\n")).length() > 40) {
                    s = s.substring(0, 37) + "...";
                } else if (s.isEmpty()) continue;
                System.out.println("  " + s);
            }
        }
        HashSet names = Sets.newHashSetWithExpectedSize((int)50);
        for (Map<String, Resource> map : this.mTypeToName.values()) {
            names.addAll(map.keySet());
        }
        for (String string : this.mStrings) {
            String name;
            int n = string.length();
            boolean justName = true;
            boolean haveSlash = false;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '/') {
                    haveSlash = true;
                    justName = false;
                    continue;
                }
                if (c == '.' || c == ':') {
                    justName = false;
                    continue;
                }
                if (Character.isJavaIdentifierPart(c)) continue;
                assert (false) : string;
                break;
            }
            if (justName) {
                name = string;
            } else {
                if (!haveSlash) continue;
                int slash = string.indexOf(47);
                assert (slash != -1);
                name = string.substring(slash + 1);
                if (name.isEmpty() || !names.contains(name)) continue;
                if (slash > 0) {
                    int colon = string.indexOf(58);
                    String typeName = string.substring(colon != -1 ? colon + 1 : 0, slash);
                    ResourceType type = ResourceType.getEnum((String)typeName);
                    if (type == null) continue;
                    Resource resource = this.getResource(type, name);
                    if (this.mDebug && resource != null) {
                        System.out.println("Marking " + resource + " used because it " + "matches string pool constant " + string);
                    }
                    ResourceUsageAnalyzer.markReachable(resource);
                    continue;
                }
            }
            if (names.contains(name)) {
                for (Map<String, Resource> map : this.mTypeToName.values()) {
                    Resource resource = map.get(string);
                    if (this.mDebug && resource != null) {
                        System.out.println("Marking " + resource + " used because it " + "matches string pool constant " + string);
                    }
                    ResourceUsageAnalyzer.markReachable(resource);
                }
                continue;
            }
            if (!Character.isDigit(name.charAt(0))) continue;
            try {
                int id = Integer.parseInt(name);
                if (id == 0) continue;
                ResourceUsageAnalyzer.markReachable(this.mValueToResource.get(id));
            }
            catch (NumberFormatException e) {
            }
        }
    }

    private void recordResources(File resDir) throws IOException, SAXException, ParserConfigurationException {
        File[] resourceFolders = resDir.listFiles();
        if (resourceFolders != null) {
            for (File folder : resourceFolders) {
                ResourceFolderType folderType = ResourceFolderType.getFolderType((String)folder.getName());
                if (folderType == null) continue;
                this.recordResources(folderType, folder);
            }
        }
    }

    private void recordResources(@NonNull ResourceFolderType folderType, File folder) throws ParserConfigurationException, SAXException, IOException {
        File[] files = folder.listFiles();
        FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)folder.getName());
        boolean isDefaultFolder = false;
        if (config != null) {
            isDefaultFolder = true;
            int n = FolderConfiguration.getQualifierCount();
            for (int i = 0; i < n; ++i) {
                ResourceQualifier qualifier = config.getQualifier(i);
                if (qualifier == null || qualifier instanceof DensityQualifier) continue;
                isDefaultFolder = false;
                break;
            }
        }
        if (files != null) {
            for (File file : files) {
                String path = file.getPath();
                boolean isXml = SdkUtils.endsWithIgnoreCase((String)path, (String)".xml");
                Resource from = null;
                if (folderType != ResourceFolderType.VALUES && (isXml || SdkUtils.endsWith((CharSequence)path, (CharSequence)".png") || SdkUtils.endsWith((CharSequence)path, (CharSequence)".jpg") || SdkUtils.endsWith((CharSequence)path, (CharSequence)".gif") || SdkUtils.endsWith((CharSequence)path, (CharSequence)".jpeg"))) {
                    List types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
                    ResourceType type = (ResourceType)types.get(0);
                    assert (type != ResourceType.ID) : folderType;
                    String name = file.getName();
                    Resource resource = this.getResource(type, name = name.substring(0, name.indexOf(46)));
                    if (resource != null) {
                        resource.addLocation(file);
                        if (isDefaultFolder) {
                            resource.hasDefault = true;
                        }
                        from = resource;
                    }
                }
                if (!isXml) continue;
                this.recordResourcesUsages(file, isDefaultFolder, from);
            }
        }
    }

    private void recordMapping(@Nullable File mapping) throws IOException {
        if (mapping == null || !mapping.exists()) {
            return;
        }
        String ARROW = " -> ";
        String RESOURCE = ".R$";
        for (String line : Files.readLines((File)mapping, (Charset)Charsets.UTF_8)) {
            String typeName;
            ResourceType type;
            int arrow;
            int index;
            if (line.startsWith(" ") || line.startsWith("\t") || (index = line.indexOf(".R$")) == -1 || (arrow = line.indexOf(" -> ", index + 3)) == -1 || (type = ResourceType.getEnum((String)(typeName = line.substring(index + ".R$".length(), arrow)))) == null) continue;
            int end = line.indexOf(58, arrow + " -> ".length());
            if (end == -1) {
                end = line.length();
            }
            String target = line.substring(arrow + " -> ".length(), end).trim();
            String ownerName = target.replace('.', '/');
            this.mResourceClassOwners.put(ownerName, type);
        }
    }

    private void recordManifestUsages(File manifest) throws IOException, ParserConfigurationException, SAXException {
        String xml = Files.toString((File)manifest, (Charset)Charsets.UTF_8);
        Document document = XmlUtils.parseDocument((String)xml, (boolean)true);
        this.recordManifestUsages(document.getDocumentElement());
    }

    private void recordResourcesUsages(@NonNull File file, boolean isDefaultFolder, @Nullable Resource from) throws IOException, ParserConfigurationException, SAXException {
        String xml = Files.toString((File)file, (Charset)Charsets.UTF_8);
        Document document = XmlUtils.parseDocument((String)xml, (boolean)true);
        this.recordResourceReferences(file, isDefaultFolder, document.getDocumentElement(), from);
    }

    @Nullable
    private Resource getResource(@NonNull ResourceType type, @NonNull String name) {
        Map<String, Resource> nameMap = this.mTypeToName.get(type);
        if (nameMap != null) {
            return nameMap.get(name);
        }
        return null;
    }

    @Nullable
    private Resource getResource(@NonNull String possibleUrlReference) {
        ResourceUrl url = ResourceUrl.parse((String)possibleUrlReference);
        if (url != null && !url.framework) {
            return this.getResource(url.type, url.name);
        }
        return null;
    }

    private void recordManifestUsages(Node node) {
        short nodeType = node.getNodeType();
        if (nodeType == 1) {
            Element element = (Element)node;
            NamedNodeMap attributes = element.getAttributes();
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)attributes.item(i);
                ResourceUsageAnalyzer.markReachable(this.getResource(attr.getValue()));
            }
        } else if (nodeType == 3) {
            String text = node.getNodeValue().trim();
            ResourceUsageAnalyzer.markReachable(this.getResource(text));
        }
        NodeList children = node.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = children.item(i);
            this.recordManifestUsages(child);
        }
    }

    private void recordResourceReferences(@NonNull File file, boolean isDefaultFolder, @NonNull Node node, @Nullable Resource from) {
        block13: {
            String text;
            Resource textResource;
            short nodeType;
            block10: {
                String name;
                String tagName;
                Resource definition;
                Element element;
                block11: {
                    int index;
                    Resource ps;
                    block12: {
                        nodeType = node.getNodeType();
                        if (nodeType != 1) break block10;
                        element = (Element)node;
                        if (from != null) {
                            NamedNodeMap attributes = element.getAttributes();
                            int n = attributes.getLength();
                            for (int i = 0; i < n; ++i) {
                                Attr attr = (Attr)attributes.item(i);
                                Resource resource = this.getResource(attr.getValue());
                                if (resource == null) continue;
                                from.addReference(resource);
                            }
                        }
                        if ((definition = this.getResource(element)) != null) {
                            from = definition;
                            definition.addLocation(file);
                            if (isDefaultFolder) {
                                definition.hasDefault = true;
                            }
                        }
                        if (!"style".equals(tagName = element.getTagName())) break block11;
                        if (!element.hasAttribute("parent")) break block12;
                        String parent = element.getAttribute("parent");
                        if (parent.isEmpty() || parent.startsWith("@android:style/") || parent.startsWith("android:")) break block11;
                        String parentStyle = parent;
                        if (!parentStyle.startsWith("@style/")) {
                            parentStyle = "@style/" + parentStyle;
                        }
                        if ((ps = this.getResource(ResourceUsageAnalyzer.getFieldName(parentStyle))) == null || definition == null) break block11;
                        definition.addReference(ps);
                        break block11;
                    }
                    String name2 = ResourceUsageAnalyzer.getFieldName(element);
                    while ((index = name2.lastIndexOf(95)) != -1) {
                        name2 = name2.substring(0, index);
                        ps = this.getResource("@style/" + ResourceUsageAnalyzer.getFieldName(name2));
                        if (ps == null || definition == null) continue;
                        definition.addReference(ps);
                    }
                }
                if ("item".equals(tagName) && element.getParentNode() != null && element.getParentNode().getNodeName().equals("style") && !(name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name")).isEmpty() && !name.startsWith("android:")) {
                    Element style;
                    Resource resource = this.getResource(ResourceType.ATTR, name);
                    if (definition == null && (definition = this.getResource(style = (Element)element.getParentNode())) != null) {
                        from = definition;
                        definition.addReference(resource);
                    }
                }
                break block13;
            }
            if ((nodeType == 3 || nodeType == 4) && (textResource = this.getResource(ResourceUsageAnalyzer.getFieldName(text = node.getNodeValue().trim()))) != null && from != null) {
                from.addReference(textResource);
            }
        }
        NodeList children = node.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = children.item(i);
            this.recordResourceReferences(file, isDefaultFolder, child, from);
        }
    }

    public static String getFieldName(@NonNull String styleName) {
        return styleName.replace('.', '_').replace('-', '_').replace(':', '_');
    }

    private static void markReachable(@Nullable Resource resource) {
        if (resource != null) {
            resource.reachable = true;
        }
    }

    private void referencedString(@NonNull String string) {
        if (string.isEmpty() || string.length() > 80) {
            return;
        }
        boolean haveIdentifierChar = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            boolean identifierChar = Character.isJavaIdentifierPart(c);
            if (!identifierChar && c != '.' && c != ':' && c != '/') {
                return;
            }
            if (!identifierChar) continue;
            haveIdentifierChar = true;
        }
        if (!haveIdentifierChar) {
            return;
        }
        if (this.mStrings == null) {
            this.mStrings = Sets.newHashSetWithExpectedSize((int)300);
        }
        this.mStrings.add(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordUsages(File jarFile) throws IOException {
        if (!jarFile.exists()) {
            return;
        }
        ZipInputStream zis = null;
        try {
            FileInputStream fis = new FileInputStream(jarFile);
            try {
                zis = new ZipInputStream(fis);
                ZipEntry entry = zis.getNextEntry();
                while (entry != null) {
                    byte[] bytes;
                    String name = entry.getName();
                    if (name.endsWith(".class") && (bytes = ByteStreams.toByteArray((InputStream)zis)) != null) {
                        ClassReader classReader = new ClassReader(bytes);
                        classReader.accept((ClassVisitor)new UsageVisitor(), 0);
                    }
                    entry = zis.getNextEntry();
                }
            }
            finally {
                Closeables.close((Closeable)fis, (boolean)true);
            }
        }
        catch (Throwable throwable) {
            Closeables.close(zis, (boolean)true);
            throw throwable;
        }
        Closeables.close((Closeable)zis, (boolean)true);
    }

    private void gatherResourceValues(File file) throws IOException {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    this.gatherResourceValues(child);
                }
            }
        } else if (file.isFile() && file.getName().equals("R.java")) {
            this.parseResourceClass(file);
        }
    }

    private void parseResourceClass(File file) throws IOException {
        String typeName;
        ResourceType type;
        int start;
        int end;
        String s = Files.toString((File)file, (Charset)Charsets.UTF_8);
        String pkg = null;
        int index = s.indexOf("package ");
        if (index != -1) {
            int end2 = s.indexOf(59, index);
            pkg = s.substring(index + "package ".length(), end2).trim().replace('.', '/');
        }
        index = 0;
        int length = s.length();
        String classDeclaration = "public static final class ";
        block0: while ((index = s.indexOf(classDeclaration, index)) != -1 && (end = s.indexOf(32, start = index + classDeclaration.length())) != -1 && (type = ResourceType.getEnum((String)(typeName = s.substring(start, end)))) != null) {
            if (pkg != null) {
                this.mResourceClassOwners.put(pkg + "/R$" + type.getName(), type);
            }
            for (index = end; index < length - 1; ++index) {
                char c = s.charAt(index);
                if (Character.isWhitespace(c)) continue;
                if (c == '/') {
                    char next = s.charAt(index + 1);
                    if (next == '*') {
                        for (end = index + 2; end < length - 2; ++end) {
                            c = s.charAt(end);
                            if (c != '*' || s.charAt(end + 1) != '/') continue;
                            ++end;
                            break;
                        }
                        index = end;
                        continue;
                    }
                    if (next == '/' ? !$assertionsDisabled : !$assertionsDisabled) {
                        throw new AssertionError((Object)s.substring(index - 1, index + 50));
                    }
                    continue;
                }
                if (c == 'p' && s.startsWith("public ", index)) {
                    if (type == ResourceType.STYLEABLE) {
                        start = s.indexOf(" int", index);
                        if (s.startsWith(" int[] ", start)) {
                            end = s.indexOf(61, start);
                            assert (end != -1);
                            String styleable = s.substring(start, end).trim();
                            this.addResource(ResourceType.DECLARE_STYLEABLE, styleable, null);
                            continue;
                        }
                        if (!s.startsWith(" int ") || (index = s.indexOf(59, index)) != -1) continue;
                        continue block0;
                    }
                    start = s.indexOf(" int ", index);
                    if (start == -1) continue;
                    end = s.indexOf(61, start += " int ".length());
                    assert (end != -1);
                    String name = s.substring(start, end).trim();
                    start = end + 1;
                    end = s.indexOf(59, start);
                    assert (end != -1);
                    String value = s.substring(start, end).trim();
                    this.addResource(type, name, value);
                    continue;
                }
                if (c == '}') continue block0;
            }
        }
    }

    private void addResource(@NonNull ResourceType type, @NonNull String name, @Nullable String value) {
        HashMap nameMap;
        int realValue = value != null ? Integer.decode(value) : -1;
        Resource resource = this.getResource(type, name);
        if (resource != null) {
            if (value != null) {
                if (resource.value == -1) {
                    resource.value = realValue;
                } else assert (realValue == resource.value);
            }
            return;
        }
        resource = new Resource(type, name, realValue);
        this.mResources.add(resource);
        if (realValue != -1) {
            this.mValueToResource.put(realValue, resource);
        }
        if ((nameMap = this.mTypeToName.get(type)) == null) {
            nameMap = Maps.newHashMapWithExpectedSize((int)30);
            this.mTypeToName.put(type, nameMap);
        }
        nameMap.put(name, resource);
    }

    public int getUnusedResourceCount() {
        return this.mUnused.size();
    }

    List<Resource> getAllResources() {
        return this.mResources;
    }

    String dumpResourceModel() {
        StringBuilder sb = new StringBuilder(1000);
        Collections.sort(this.mResources, new Comparator<Resource>(){

            @Override
            public int compare(Resource resource1, Resource resource2) {
                int delta = resource1.type.compareTo((Enum)resource2.type);
                if (delta != 0) {
                    return delta;
                }
                return resource1.name.compareTo(resource2.name);
            }
        });
        for (Resource resource : this.mResources) {
            sb.append(resource.getUrl()).append(" : reachable=").append(resource.reachable);
            sb.append("\n");
            if (resource.references == null) continue;
            for (Resource referenced : resource.references) {
                sb.append("    ");
                sb.append(referenced.getUrl());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private class UsageVisitor
    extends ClassVisitor {
        public UsageVisitor() {
            super(262144);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new MethodVisitor(262144){

                public void visitLdcInsn(Object cst) {
                    if (cst instanceof Integer) {
                        Integer value = (Integer)cst;
                        ResourceUsageAnalyzer.markReachable((Resource)ResourceUsageAnalyzer.this.mValueToResource.get(value));
                    } else if (cst instanceof String) {
                        String string = (String)cst;
                        ResourceUsageAnalyzer.this.referencedString(string);
                    }
                }

                public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                    Resource resource;
                    ResourceType type;
                    if (opcode == 178 && (type = (ResourceType)ResourceUsageAnalyzer.this.mResourceClassOwners.get(owner)) != null && (resource = ResourceUsageAnalyzer.this.getResource(type, name)) != null) {
                        ResourceUsageAnalyzer.markReachable(resource);
                    }
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                    super.visitMethodInsn(opcode, owner, name, desc);
                    if (owner.equals("android/content/res/Resources") && name.equals("getIdentifier") && desc.equals("(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I")) {
                        ResourceUsageAnalyzer.this.mFoundGetIdentifier = true;
                    }
                }
            };
        }
    }

    public static class Resource {
        public ResourceType type;
        public String name;
        public int value;
        public boolean reachable;
        public boolean hasDefault;
        public List<Resource> references;
        public final List<File> declarations = Lists.newArrayList();

        private Resource(ResourceType type, String name, int value) {
            this.type = type;
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return this.type + ":" + this.name + ":" + this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Resource resource = (Resource)o;
            if (this.name != null ? !this.name.equals(resource.name) : resource.name != null) {
                return false;
            }
            return this.type == resource.type;
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }

        public void addLocation(@NonNull File file) {
            this.declarations.add(file);
        }

        public void addReference(@Nullable Resource resource) {
            if (resource != null) {
                if (this.references == null) {
                    this.references = Lists.newArrayList();
                } else if (this.references.contains(resource)) {
                    return;
                }
                this.references.add(resource);
            }
        }

        public String getUrl() {
            return '@' + this.type.getName() + '/' + this.name;
        }

        public boolean isRelevantType() {
            return this.type != ResourceType.ID;
        }
    }
}

