/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.annotations.NonNull;
import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.VariantOutput;
import com.android.build.gradle.api.ApkOutputFile;
import com.android.build.gradle.internal.StringHelper;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.PackageSplitAbi;
import com.android.build.gradle.tasks.PackageSplitRes;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.Task;

public abstract class BaseVariantOutputData
implements VariantOutput {
    private static final String UNIVERSAL = "universal";
    @NonNull
    public final BaseVariantData<?> variantData;
    @NonNull
    private final ApkOutputFile mainApkOutputFile;
    private boolean multiOutput = false;
    public ManifestProcessorTask manifestProcessorTask;
    public ProcessAndroidResources processResourcesTask;
    public PackageSplitRes packageSplitResourcesTask;
    public PackageSplitAbi packageSplitAbiTask;
    public Task assembleTask;

    public BaseVariantOutputData(@NonNull OutputFile.OutputType outputType, @NonNull Collection<FilterData> filters, @NonNull BaseVariantData<?> variantData) {
        this.variantData = variantData;
        this.mainApkOutputFile = new ApkOutputFile(outputType, filters, this.getOutputFilePromise());
    }

    @NonNull
    public ApkOutputFile getMainOutputFile() {
        return this.mainApkOutputFile;
    }

    private Callable<File> getOutputFilePromise() {
        return new Callable<File>(){

            @Override
            public File call() throws Exception {
                return BaseVariantOutputData.this.getOutputFile();
            }
        };
    }

    public abstract void setOutputFile(@NonNull File var1);

    @NonNull
    public abstract File getOutputFile();

    @NonNull
    public abstract ImmutableList<ApkOutputFile> getOutputs();

    @NonNull
    public String getFullName() {
        if (!this.multiOutput) {
            return this.variantData.getVariantConfiguration().getFullName();
        }
        return this.variantData.getVariantConfiguration().computeFullNameWithSplits(this.getFilterName());
    }

    @NonNull
    public String getBaseName() {
        if (!this.multiOutput) {
            return this.variantData.getVariantConfiguration().getBaseName();
        }
        return this.variantData.getVariantConfiguration().computeBaseNameWithSplits(this.getFilterName());
    }

    @NonNull
    public String getDirName() {
        if (!this.multiOutput) {
            return this.variantData.getVariantConfiguration().getDirName();
        }
        return this.variantData.getVariantConfiguration().computeDirNameWithSplits(new String[]{this.mainApkOutputFile.getFilter(OutputFile.DENSITY), this.mainApkOutputFile.getFilter(OutputFile.ABI)});
    }

    @NonNull
    private String getFilterName() {
        String abiFilter;
        if (this.mainApkOutputFile.getFilters().isEmpty()) {
            return UNIVERSAL;
        }
        StringBuilder sb = new StringBuilder();
        String densityFilter = this.mainApkOutputFile.getFilter(OutputFile.DENSITY);
        if (densityFilter != null) {
            sb.append(densityFilter);
        }
        if ((abiFilter = this.mainApkOutputFile.getFilter(OutputFile.ABI)) != null) {
            if (sb.length() > 0) {
                sb.append(StringHelper.capitalize(abiFilter));
            } else {
                sb.append(abiFilter);
            }
        }
        return sb.toString();
    }

    @NonNull
    public File getSplitFolder() {
        return this.getOutputFile().getParentFile();
    }

    void setMultiOutput(boolean multiOutput) {
        this.multiOutput = multiOutput;
    }
}

