/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.annotations.NonNull;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Scope;
import com.android.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.builder.AstBuilder;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;

public class GroovyGradleDetector
extends GradleDetector {
    static final Implementation IMPLEMENTATION = new Implementation(GroovyGradleDetector.class, Scope.GRADLE_SCOPE);

    public void visitBuildScript(@NonNull Context context, Map<String, Object> sharedData) {
        try {
            this.visitQuietly(context, sharedData);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void visitQuietly(final @NonNull Context context, Map<String, Object> sharedData) {
        String source = context.getContents();
        if (source == null) {
            return;
        }
        List astNodes = new AstBuilder().buildFromString(source);
        CodeVisitorSupport visitor = new CodeVisitorSupport(){
            private List<MethodCallExpression> mMethodCallStack = Lists.newArrayList();

            public void visitMethodCallExpression(MethodCallExpression expression) {
                this.mMethodCallStack.add(expression);
                super.visitMethodCallExpression(expression);
                Expression arguments = expression.getArguments();
                String parent = expression.getMethodAsString();
                String parentParent = this.getParentParent();
                if (arguments instanceof ArgumentListExpression) {
                    ClosureExpression closureExpression;
                    Statement block;
                    ArgumentListExpression ale = (ArgumentListExpression)arguments;
                    List expressions = ale.getExpressions();
                    if (expressions.size() == 1 && expressions.get(0) instanceof ClosureExpression && GroovyGradleDetector.isInterestingBlock((String)parent, (String)parentParent) && (block = (closureExpression = (ClosureExpression)expressions.get(0)).getCode()) instanceof BlockStatement) {
                        BlockStatement bs = (BlockStatement)block;
                        for (Statement statement : bs.getStatements()) {
                            ExpressionStatement e;
                            if (statement instanceof ExpressionStatement) {
                                e = (ExpressionStatement)statement;
                                if (!(e.getExpression() instanceof MethodCallExpression)) continue;
                                this.checkDslProperty(parent, (MethodCallExpression)e.getExpression(), parentParent);
                                continue;
                            }
                            if (!(statement instanceof ReturnStatement) || !((e = (ReturnStatement)statement).getExpression() instanceof MethodCallExpression)) continue;
                            this.checkDslProperty(parent, (MethodCallExpression)e.getExpression(), parentParent);
                        }
                    }
                } else if (arguments instanceof TupleExpression && GroovyGradleDetector.isInterestingStatement((String)parent, (String)parentParent)) {
                    TupleExpression te = (TupleExpression)arguments;
                    HashMap namedArguments = Maps.newHashMap();
                    ArrayList unnamedArguments = Lists.newArrayList();
                    for (Expression subExpr : te.getExpressions()) {
                        if (!(subExpr instanceof NamedArgumentListExpression)) continue;
                        NamedArgumentListExpression nale = (NamedArgumentListExpression)subExpr;
                        for (MapEntryExpression mae : nale.getMapEntryExpressions()) {
                            namedArguments.put(mae.getKeyExpression().getText(), mae.getValueExpression().getText());
                        }
                    }
                    GroovyGradleDetector.this.checkMethodCall(context, parent, parentParent, namedArguments, unnamedArguments, expression);
                }
                assert (!this.mMethodCallStack.isEmpty());
                assert (this.mMethodCallStack.get(this.mMethodCallStack.size() - 1) == expression);
                this.mMethodCallStack.remove(this.mMethodCallStack.size() - 1);
            }

            private String getParentParent() {
                for (int i = this.mMethodCallStack.size() - 2; i >= 0; --i) {
                    ArgumentListExpression ale;
                    List expressions;
                    MethodCallExpression expression = this.mMethodCallStack.get(i);
                    Expression arguments = expression.getArguments();
                    if (!(arguments instanceof ArgumentListExpression) || (expressions = (ale = (ArgumentListExpression)arguments).getExpressions()).size() != 1 || !(expressions.get(0) instanceof ClosureExpression)) continue;
                    return expression.getMethodAsString();
                }
                return null;
            }

            private void checkDslProperty(String parent, MethodCallExpression c, String parentParent) {
                String property = c.getMethodAsString();
                if (GroovyGradleDetector.isInterestingProperty((String)property, (String)parent, (String)this.getParentParent())) {
                    String value = this.getText((ASTNode)c.getArguments());
                    GroovyGradleDetector.this.checkDslPropertyAssignment(context, property, value, parent, parentParent, c, c);
                }
            }

            private String getText(ASTNode node) {
                String source = context.getContents();
                Pair offsets = GroovyGradleDetector.getOffsets(node, context);
                return source.substring((Integer)offsets.getFirst(), (Integer)offsets.getSecond());
            }
        };
        for (ASTNode node : astNodes) {
            node.visit((GroovyCodeVisitor)visitor);
        }
    }

    @NonNull
    private static Pair<Integer, Integer> getOffsets(ASTNode node, Context context) {
        TupleExpression exp;
        List expressions;
        if (node.getLastLineNumber() == -1 && node instanceof TupleExpression && !(expressions = (exp = (TupleExpression)node).getExpressions()).isEmpty()) {
            return Pair.of((Object)GroovyGradleDetector.getOffsets((ASTNode)expressions.get(0), context).getFirst(), (Object)GroovyGradleDetector.getOffsets((ASTNode)expressions.get(expressions.size() - 1), context).getSecond());
        }
        String source = context.getContents();
        assert (source != null);
        int start = 0;
        int end = source.length();
        int line = 1;
        int startLine = node.getLineNumber();
        int startColumn = node.getColumnNumber();
        int endLine = node.getLastLineNumber();
        int endColumn = node.getLastColumnNumber();
        int column = 1;
        int len = end;
        for (int index = 0; index < len; ++index) {
            if (line == startLine && column == startColumn) {
                start = index;
            }
            if (line == endLine && column == endColumn) {
                end = index;
                break;
            }
            char c = source.charAt(index);
            if (c == '\n') {
                ++line;
                column = 1;
                continue;
            }
            ++column;
        }
        return Pair.of((Object)start, (Object)end);
    }

    protected int getStartOffset(@NonNull Context context, @NonNull Object cookie) {
        ASTNode node = (ASTNode)cookie;
        Pair<Integer, Integer> offsets = GroovyGradleDetector.getOffsets(node, context);
        return (Integer)offsets.getFirst();
    }

    protected Location createLocation(@NonNull Context context, @NonNull Object cookie) {
        ASTNode node = (ASTNode)cookie;
        Pair<Integer, Integer> offsets = GroovyGradleDetector.getOffsets(node, context);
        int fromLine = node.getLineNumber() - 1;
        int fromColumn = node.getColumnNumber() - 1;
        int toLine = node.getLastLineNumber() - 1;
        int toColumn = node.getLastColumnNumber() - 1;
        return Location.create((File)context.file, (Position)new DefaultPosition(fromLine, fromColumn, ((Integer)offsets.getFirst()).intValue()), (Position)new DefaultPosition(toLine, toColumn, ((Integer)offsets.getSecond()).intValue()));
    }
}

