/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.api.TestVariant;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.tasks.Dex;
import com.android.build.gradle.tasks.PackageApplication;
import com.android.build.gradle.tasks.ZipAlign;
import com.android.builder.DefaultProductFlavor;
import com.android.builder.model.SigningConfig;
import java.io.File;
import java.util.List;
import org.gradle.api.DefaultTask;

public class ApplicationVariantImpl
extends BaseVariantImpl
implements ApplicationVariant {
    @NonNull
    private final ApplicationVariantData variantData;
    @Nullable
    private TestVariant testVariant = null;

    public ApplicationVariantImpl(@NonNull ApplicationVariantData variantData) {
        this.variantData = variantData;
    }

    @Override
    protected BaseVariantData getVariantData() {
        return this.variantData;
    }

    public void setTestVariant(@Nullable TestVariant testVariant) {
        this.testVariant = testVariant;
    }

    @Override
    @NonNull
    public List<DefaultProductFlavor> getProductFlavors() {
        return this.variantData.getVariantConfiguration().getFlavorConfigs();
    }

    @Override
    @NonNull
    public DefaultProductFlavor getMergedFlavor() {
        return this.variantData.getVariantConfiguration().getMergedFlavor();
    }

    @Override
    public void setOutputFile(@NonNull File outputFile) {
        if (this.variantData.zipAlignTask != null) {
            this.variantData.zipAlignTask.setOutputFile(outputFile);
        } else {
            this.variantData.packageApplicationTask.setOutputFile(outputFile);
        }
    }

    @Override
    @Nullable
    public TestVariant getTestVariant() {
        return this.testVariant;
    }

    @Override
    public Dex getDex() {
        return this.variantData.dexTask;
    }

    @Override
    public PackageApplication getPackageApplication() {
        return this.variantData.packageApplicationTask;
    }

    @Override
    public ZipAlign getZipAlign() {
        return this.variantData.zipAlignTask;
    }

    @Override
    public DefaultTask getInstall() {
        return this.variantData.installTask;
    }

    @Override
    public DefaultTask getUninstall() {
        return this.variantData.uninstallTask;
    }

    @Override
    public SigningConfig getSigningConfig() {
        return this.variantData.getVariantConfiguration().getSigningConfig();
    }

    @Override
    public boolean isSigningReady() {
        return this.variantData.isSigned();
    }
}

