/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.annotations.NonNull;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.TestVariant;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.tasks.Dex;
import com.android.build.gradle.tasks.PackageApplication;
import com.android.build.gradle.tasks.ZipAlign;
import com.android.builder.DefaultProductFlavor;
import com.android.builder.model.SigningConfig;
import java.io.File;
import java.util.List;
import org.gradle.api.DefaultTask;

public class TestVariantImpl
extends BaseVariantImpl
implements TestVariant {
    @NonNull
    private final TestVariantData variantData;
    @NonNull
    private BaseVariant testedVariant;

    public TestVariantImpl(@NonNull TestVariantData variantData) {
        this.variantData = variantData;
    }

    @Override
    protected BaseVariantData getVariantData() {
        return this.variantData;
    }

    @Override
    @NonNull
    public List<DefaultProductFlavor> getProductFlavors() {
        return this.variantData.getVariantConfiguration().getFlavorConfigs();
    }

    @Override
    @NonNull
    public DefaultProductFlavor getMergedFlavor() {
        return this.variantData.getVariantConfiguration().getMergedFlavor();
    }

    @Override
    public void setOutputFile(@NonNull File outputFile) {
        if (this.variantData.zipAlignTask != null) {
            this.variantData.zipAlignTask.setOutputFile(outputFile);
        } else {
            this.variantData.packageApplicationTask.setOutputFile(outputFile);
        }
    }

    @Override
    @NonNull
    public BaseVariant getTestedVariant() {
        return this.testedVariant;
    }

    public void setTestedVariant(@NonNull BaseVariant testedVariant) {
        this.testedVariant = testedVariant;
    }

    @Override
    public Dex getDex() {
        return this.variantData.dexTask;
    }

    @Override
    public PackageApplication getPackageApplication() {
        return this.variantData.packageApplicationTask;
    }

    @Override
    public ZipAlign getZipAlign() {
        return this.variantData.zipAlignTask;
    }

    @Override
    public DefaultTask getInstall() {
        return this.variantData.installTask;
    }

    @Override
    public DefaultTask getUninstall() {
        return this.variantData.uninstallTask;
    }

    @Override
    public DefaultTask getConnectedInstrumentTest() {
        return this.variantData.connectedTestTask;
    }

    @Override
    @NonNull
    public List<? extends DefaultTask> getProviderInstrumentTests() {
        return this.variantData.providerTestTaskList;
    }

    @Override
    public SigningConfig getSigningConfig() {
        return this.variantData.getVariantConfiguration().getSigningConfig();
    }

    @Override
    public boolean isSigningReady() {
        return this.variantData.isSigned();
    }
}

