/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.annotations.NonNull;
import com.android.build.gradle.BasePlugin;
import com.android.build.gradle.api.ApkVariant;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.build.gradle.tasks.Dex;
import com.android.build.gradle.tasks.PackageApplication;
import com.android.build.gradle.tasks.ZipAlign;
import com.android.builder.DefaultProductFlavor;
import com.android.builder.model.SigningConfig;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.gradle.api.DefaultTask;

public abstract class ApkVariantImpl
extends BaseVariantImpl
implements ApkVariant {
    @NonNull
    private BasePlugin plugin;

    protected ApkVariantImpl(@NonNull BasePlugin plugin) {
        this.plugin = plugin;
    }

    @NonNull
    protected abstract ApkVariantData getApkVariantData();

    @Override
    @NonNull
    public List<DefaultProductFlavor> getProductFlavors() {
        return this.getVariantData().getVariantConfiguration().getFlavorConfigs();
    }

    @Override
    public void setOutputFile(@NonNull File outputFile) {
        ApkVariantData variantData = this.getApkVariantData();
        if (variantData.zipAlignTask != null) {
            variantData.zipAlignTask.setOutputFile(outputFile);
        } else {
            variantData.packageApplicationTask.setOutputFile(outputFile);
        }
        variantData.setOutputFile(outputFile);
    }

    @Override
    public Dex getDex() {
        return this.getApkVariantData().dexTask;
    }

    @Override
    public PackageApplication getPackageApplication() {
        return this.getApkVariantData().packageApplicationTask;
    }

    @Override
    public ZipAlign getZipAlign() {
        return this.getApkVariantData().zipAlignTask;
    }

    @Override
    public DefaultTask getInstall() {
        return this.getApkVariantData().installTask;
    }

    @Override
    public DefaultTask getUninstall() {
        return this.getApkVariantData().uninstallTask;
    }

    @Override
    public SigningConfig getSigningConfig() {
        return this.getApkVariantData().getVariantConfiguration().getSigningConfig();
    }

    @Override
    public boolean isSigningReady() {
        return this.getApkVariantData().isSigned();
    }

    @Override
    @NonNull
    public ZipAlign createZipAlignTask(@NonNull String taskName, @NonNull File inputFile, @NonNull File outputFile) {
        ApkVariantData variantData = this.getApkVariantData();
        if (variantData.zipAlignTask != null) {
            throw new RuntimeException(String.format("ZipAlign task for variant '%s' already exists.", this.getName()));
        }
        ZipAlign task = this.plugin.createZipAlignTask(taskName, inputFile, outputFile);
        variantData.setOutputFile(outputFile);
        variantData.zipAlignTask = task;
        variantData.assembleTask.dependsOn(new Object[]{task});
        return task;
    }

    @Override
    @NonNull
    public Collection<File> getCompileLibraries() {
        return this.plugin.getAndroidBuilder(this.getVariantData()).getCompileClasspath(this.getVariantData().getVariantConfiguration());
    }

    @Override
    @NonNull
    public Collection<File> getApkLibraries() {
        return this.plugin.getAndroidBuilder(this.getVariantData()).getPackagedJars(this.getVariantData().getVariantConfiguration());
    }
}

