/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.model.BuildType;
import com.android.builder.model.ClassField;
import com.android.builder.model.NdkConfig;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class BuildTypeImpl
implements BuildType,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private boolean debuggable;
    private boolean jniDebugBuild;
    private boolean renderscriptDebugBuild;
    private int renderscriptOptimLevel;
    private String packageNameSuffix;
    private String versionNameSuffix;
    private boolean runProguard;
    private boolean zipAlign;

    @NonNull
    static BuildTypeImpl cloneBuildType(BuildType buildType) {
        BuildTypeImpl clonedBuildType = new BuildTypeImpl();
        clonedBuildType.name = buildType.getName();
        clonedBuildType.debuggable = buildType.isDebuggable();
        clonedBuildType.jniDebugBuild = buildType.isJniDebugBuild();
        clonedBuildType.renderscriptDebugBuild = buildType.isRenderscriptDebugBuild();
        clonedBuildType.renderscriptOptimLevel = buildType.getRenderscriptOptimLevel();
        clonedBuildType.packageNameSuffix = buildType.getPackageNameSuffix();
        clonedBuildType.versionNameSuffix = buildType.getVersionNameSuffix();
        clonedBuildType.runProguard = buildType.isRunProguard();
        clonedBuildType.zipAlign = buildType.isZipAlign();
        return clonedBuildType;
    }

    private BuildTypeImpl() {
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public boolean isDebuggable() {
        return this.debuggable;
    }

    public boolean isJniDebugBuild() {
        return this.jniDebugBuild;
    }

    public boolean isRenderscriptDebugBuild() {
        return this.renderscriptDebugBuild;
    }

    public int getRenderscriptOptimLevel() {
        return this.renderscriptOptimLevel;
    }

    @Nullable
    public String getPackageNameSuffix() {
        return this.packageNameSuffix;
    }

    @Nullable
    public String getVersionNameSuffix() {
        return this.versionNameSuffix;
    }

    public boolean isRunProguard() {
        return this.runProguard;
    }

    public boolean isZipAlign() {
        return this.zipAlign;
    }

    @NonNull
    public Map<String, ClassField> getBuildConfigFields() {
        return Collections.emptyMap();
    }

    @NonNull
    public List<File> getProguardFiles() {
        return Collections.emptyList();
    }

    @NonNull
    public List<File> getConsumerProguardFiles() {
        return Collections.emptyList();
    }

    @Nullable
    public NdkConfig getNdkConfig() {
        return null;
    }
}

