/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.annotations.NonNull;
import com.android.builder.model.SourceProvider;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

class SourceProviderImpl
implements SourceProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    private File manifestFile;
    private Collection<File> javaDirs;
    private Collection<File> resourcesDirs;
    private Collection<File> aidlDirs;
    private Collection<File> rsDirs;
    private Collection<File> jniDirs;
    private Collection<File> resDirs;
    private Collection<File> assetsDirs;
    private Collection<File> libsDirs;

    @NonNull
    static SourceProviderImpl cloneProvider(@NonNull SourceProvider sourceProvider) {
        SourceProviderImpl sourceProviderClone = new SourceProviderImpl();
        sourceProviderClone.manifestFile = sourceProvider.getManifestFile();
        sourceProviderClone.javaDirs = sourceProvider.getJavaDirectories();
        sourceProviderClone.resourcesDirs = sourceProvider.getResourcesDirectories();
        sourceProviderClone.aidlDirs = sourceProvider.getAidlDirectories();
        sourceProviderClone.rsDirs = sourceProvider.getRenderscriptDirectories();
        sourceProviderClone.jniDirs = sourceProvider.getJniDirectories();
        sourceProviderClone.resDirs = sourceProvider.getResDirectories();
        sourceProviderClone.assetsDirs = sourceProvider.getAssetsDirectories();
        sourceProviderClone.libsDirs = sourceProvider.getJniLibsDirectories();
        return sourceProviderClone;
    }

    @NonNull
    static Collection<SourceProvider> cloneCollection(@NonNull Collection<SourceProvider> sourceProviders) {
        ArrayList results = Lists.newArrayListWithCapacity((int)sourceProviders.size());
        for (SourceProvider sourceProvider : sourceProviders) {
            results.add(SourceProviderImpl.cloneProvider(sourceProvider));
        }
        return results;
    }

    private SourceProviderImpl() {
    }

    @NonNull
    public File getManifestFile() {
        return this.manifestFile;
    }

    @NonNull
    public Collection<File> getJavaDirectories() {
        return this.javaDirs;
    }

    @NonNull
    public Collection<File> getResourcesDirectories() {
        return this.resourcesDirs;
    }

    @NonNull
    public Collection<File> getAidlDirectories() {
        return this.aidlDirs;
    }

    @NonNull
    public Collection<File> getRenderscriptDirectories() {
        return this.rsDirs;
    }

    @NonNull
    public Collection<File> getJniDirectories() {
        return this.jniDirs;
    }

    @NonNull
    public Collection<File> getResDirectories() {
        return this.resDirs;
    }

    @NonNull
    public Collection<File> getAssetsDirectories() {
        return this.assetsDirs;
    }

    @NonNull
    public Collection<File> getJniLibsDirectories() {
        return this.libsDirs;
    }

    public String toString() {
        return "SourceProviderImpl{manifestFile=" + this.manifestFile + ", javaDirs=" + this.javaDirs + ", resourcesDirs=" + this.resourcesDirs + ", aidlDirs=" + this.aidlDirs + ", rsDirs=" + this.rsDirs + ", jniDirs=" + this.jniDirs + ", resDirs=" + this.resDirs + ", assetsDirs=" + this.assetsDirs + ", libsDirs=" + this.libsDirs + '}';
    }
}

