/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test.report;

import com.android.build.gradle.internal.test.report.ClassTestResults;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.tasks.testing.junit.report.TestResultModel;
import org.gradle.api.internal.tasks.testing.junit.result.TestFailure;
import org.gradle.api.tasks.testing.TestResult;

class TestResult
extends TestResultModel
implements Comparable<TestResult> {
    private final long duration;
    private final String device;
    private final String project;
    private final String flavor;
    final ClassTestResults classResults;
    final List<TestFailure> failures = new ArrayList<TestFailure>();
    final String name;
    private boolean ignored;

    public TestResult(String name, long duration, String device, String project, String flavor, ClassTestResults classResults) {
        this.name = name;
        this.duration = duration;
        this.device = device;
        this.project = project;
        this.flavor = flavor;
        this.classResults = classResults;
    }

    public Object getId() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getDevice() {
        return this.device;
    }

    public String getProject() {
        return this.project;
    }

    public String getFlavor() {
        return this.flavor;
    }

    public String getTitle() {
        return String.format("Test %s", this.name);
    }

    public TestResult.ResultType getResultType() {
        if (this.ignored) {
            return TestResult.ResultType.SKIPPED;
        }
        return this.failures.isEmpty() ? TestResult.ResultType.SUCCESS : TestResult.ResultType.FAILURE;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getFormattedDuration() {
        return this.ignored ? "-" : super.getFormattedDuration();
    }

    public ClassTestResults getClassResults() {
        return this.classResults;
    }

    public List<TestFailure> getFailures() {
        return this.failures;
    }

    public void addFailure(String message, String stackTrace, String deviceName, String projectName, String flavorName) {
        this.classResults.failed(this, deviceName, projectName, flavorName);
        this.failures.add(new TestFailure(message, stackTrace, null));
    }

    public void ignored() {
        this.ignored = true;
    }

    @Override
    public int compareTo(TestResult testResult) {
        int diff = this.classResults.getName().compareTo(testResult.classResults.getName());
        if (diff != 0) {
            return diff;
        }
        diff = this.name.compareTo(testResult.name);
        if (diff != 0) {
            return diff;
        }
        diff = this.device.compareTo(testResult.device);
        if (diff != 0) {
            return diff;
        }
        diff = this.flavor.compareTo(testResult.flavor);
        if (diff != 0) {
            return diff;
        }
        Integer thisIdentity = System.identityHashCode(this);
        int otherIdentity = System.identityHashCode(testResult);
        return thisIdentity.compareTo(otherIdentity);
    }
}

