/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.BasePlugin;
import com.android.build.gradle.internal.dependency.ClassifiedJarDependency;
import com.android.build.gradle.internal.dependency.LibraryDependencyImpl;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.model.AndroidLibraryImpl;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.builder.dependency.JarDependency;
import com.android.builder.dependency.LibraryDependency;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;

public class DependenciesImpl
implements Dependencies,
Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final List<AndroidLibrary> libraries;
    @NonNull
    private final List<File> jars;
    @NonNull
    private final List<String> projects;

    @NonNull
    static DependenciesImpl cloneDependenciesForJavaArtifacts(@NonNull Dependencies dependencies) {
        List<AndroidLibrary> libraries = Collections.emptyList();
        ArrayList jars = Lists.newArrayList((Iterable)dependencies.getJars());
        List<String> projects = Collections.emptyList();
        return new DependenciesImpl(libraries, jars, projects);
    }

    @NonNull
    static DependenciesImpl cloneDependencies(@NonNull BaseVariantData variantData, @NonNull BasePlugin basePlugin, @NonNull Set<Project> gradleProjects) {
        VariantDependencies variantDependencies = variantData.getVariantDependency();
        List<LibraryDependencyImpl> libs = variantDependencies.getLibraries();
        ArrayList libraries = Lists.newArrayListWithCapacity((int)libs.size());
        for (LibraryDependencyImpl libImpl : libs) {
            AndroidLibrary clonedLib = DependenciesImpl.getAndroidLibrary((LibraryDependency)libImpl, gradleProjects);
            libraries.add(clonedLib);
        }
        List<JarDependency> jarDeps = variantDependencies.getJarDependencies();
        List<JarDependency> localDeps = variantDependencies.getLocalDependencies();
        ArrayList jars = Lists.newArrayListWithExpectedSize((int)(jarDeps.size() + localDeps.size()));
        ArrayList projects = Lists.newArrayList();
        for (JarDependency jarDep : jarDeps) {
            Project projectMatch;
            boolean customArtifact = jarDep instanceof ClassifiedJarDependency && ((ClassifiedJarDependency)jarDep).getClassifier() != null;
            File jarFile = jarDep.getJarFile();
            if (!customArtifact && (projectMatch = DependenciesImpl.getProject(jarFile, gradleProjects)) != null) {
                projects.add(projectMatch.getPath());
                continue;
            }
            jars.add(jarFile);
        }
        for (JarDependency jarDep : localDeps) {
            jars.add(jarDep.getJarFile());
        }
        if (variantData.getVariantConfiguration().getMergedFlavor().getRenderscriptSupportMode()) {
            jars.add(basePlugin.getAndroidBuilder(variantData).getRenderScriptSupportJar());
        }
        return new DependenciesImpl(libraries, jars, projects);
    }

    public DependenciesImpl(@NonNull Set<File> jars) {
        this.jars = Lists.newArrayList(jars);
        this.libraries = Collections.emptyList();
        this.projects = Collections.emptyList();
    }

    private DependenciesImpl(@NonNull List<AndroidLibrary> libraries, @NonNull List<File> jars, @NonNull List<String> projects) {
        this.libraries = libraries;
        this.jars = jars;
        this.projects = projects;
    }

    @NonNull
    public List<AndroidLibrary> getLibraries() {
        return this.libraries;
    }

    @NonNull
    public List<File> getJars() {
        return this.jars;
    }

    @NonNull
    public List<String> getProjects() {
        return this.projects;
    }

    @NonNull
    private static AndroidLibrary getAndroidLibrary(@NonNull LibraryDependency libImpl, @NonNull Set<Project> gradleProjects) {
        File bundle = libImpl.getBundle();
        Project projectMatch = DependenciesImpl.getProject(bundle, gradleProjects);
        List deps = libImpl.getDependencies();
        ArrayList clonedDeps = Lists.newArrayListWithCapacity((int)deps.size());
        for (LibraryDependency child : deps) {
            AndroidLibrary clonedLib = DependenciesImpl.getAndroidLibrary(child, gradleProjects);
            clonedDeps.add(clonedLib);
        }
        return new AndroidLibraryImpl(libImpl, clonedDeps, projectMatch != null ? projectMatch.getPath() : null, libImpl.getProjectVariant());
    }

    @Nullable
    private static Project getProject(File outputFile, Set<Project> gradleProjects) {
        Project projectMatch = null;
        for (Project project : gradleProjects) {
            File buildDir = project.getBuildDir();
            if (!DependenciesImpl.contains(buildDir, outputFile)) continue;
            projectMatch = project;
            break;
        }
        return projectMatch;
    }

    private static boolean contains(@NonNull File dir, @NonNull File file) {
        try {
            dir = dir.getCanonicalFile();
            file = file.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        return file.getAbsolutePath().startsWith(dir.getAbsolutePath()) && DependenciesImpl.doContains(dir, file);
    }

    private static boolean doContains(@NonNull File dir, @NonNull File file) {
        File parent = file.getParentFile();
        return parent != null && (parent.equals(dir) || DependenciesImpl.doContains(dir, parent));
    }
}

