/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.OutputFile;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.BasePlugin;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ConfigurationProvider;
import com.android.build.gradle.internal.ProductFlavorCombo;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.StringHelper;
import com.android.build.gradle.internal.VariantModel;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.api.TestVariantImpl;
import com.android.build.gradle.internal.api.TestedVariant;
import com.android.build.gradle.internal.api.VariantFilterImpl;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.GroupableProductFlavor;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.dsl.Splits;
import com.android.build.gradle.internal.variant.ApplicationVariantFactory;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.model.SourceProvider;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskContainer;

public class VariantManager
implements VariantModel {
    protected static final String COM_ANDROID_SUPPORT_MULTIDEX = "com.android.support:multidex:1.0.0";
    @NonNull
    private final Project project;
    @NonNull
    private final BasePlugin basePlugin;
    @NonNull
    private final BaseExtension extension;
    @NonNull
    private final VariantFactory variantFactory;
    @NonNull
    private final Map<String, BuildTypeData> buildTypes = Maps.newHashMap();
    @NonNull
    private final Map<String, ProductFlavorData<GroupableProductFlavor>> productFlavors = Maps.newHashMap();
    @NonNull
    private final Map<String, SigningConfig> signingConfigs = Maps.newHashMap();
    @NonNull
    private final ReadOnlyObjectProvider readOnlyObjectProvider = new ReadOnlyObjectProvider();
    @NonNull
    private final VariantFilterImpl variantFilter = new VariantFilterImpl(this.readOnlyObjectProvider);
    @NonNull
    private final List<BaseVariantData<? extends BaseVariantOutputData>> variantDataList = Lists.newArrayList();

    public VariantManager(@NonNull Project project, @NonNull BasePlugin basePlugin, @NonNull BaseExtension extension, @NonNull VariantFactory variantFactory) {
        this.extension = extension;
        this.basePlugin = basePlugin;
        this.project = project;
        this.variantFactory = variantFactory;
    }

    @Override
    @NonNull
    public ProductFlavorData<ProductFlavor> getDefaultConfig() {
        return this.basePlugin.getDefaultConfigData();
    }

    @Override
    @NonNull
    public Map<String, BuildTypeData> getBuildTypes() {
        return this.buildTypes;
    }

    @Override
    @NonNull
    public Map<String, ProductFlavorData<GroupableProductFlavor>> getProductFlavors() {
        return this.productFlavors;
    }

    @NonNull
    public Map<String, SigningConfig> getSigningConfigs() {
        return this.signingConfigs;
    }

    public void addSigningConfig(@NonNull SigningConfig signingConfig) {
        this.signingConfigs.put(signingConfig.getName(), signingConfig);
    }

    public void addBuildType(@NonNull BuildType buildType) {
        buildType.init(this.signingConfigs.get("debug"));
        String name = buildType.getName();
        VariantManager.checkName(name, "BuildType");
        if (this.productFlavors.containsKey(name)) {
            throw new RuntimeException("BuildType names cannot collide with ProductFlavor names");
        }
        DefaultAndroidSourceSet sourceSet = (DefaultAndroidSourceSet)this.extension.getSourceSetsContainer().maybeCreate(name);
        BuildTypeData buildTypeData = new BuildTypeData(buildType, sourceSet, this.project);
        this.project.getTasks().getByName("assemble").dependsOn(new Object[]{buildTypeData.getAssembleTask()});
        this.buildTypes.put(name, buildTypeData);
    }

    public void addProductFlavor(@NonNull GroupableProductFlavor productFlavor) {
        String name = productFlavor.getName();
        VariantManager.checkName(name, "ProductFlavor");
        if (this.buildTypes.containsKey(name)) {
            throw new RuntimeException("ProductFlavor names cannot collide with BuildType names");
        }
        DefaultAndroidSourceSet mainSourceSet = (DefaultAndroidSourceSet)this.extension.getSourceSetsContainer().maybeCreate(productFlavor.getName());
        String testName = "androidTest" + StringHelper.capitalize(productFlavor.getName());
        DefaultAndroidSourceSet testSourceSet = (DefaultAndroidSourceSet)this.extension.getSourceSetsContainer().maybeCreate(testName);
        ProductFlavorData<GroupableProductFlavor> productFlavorData = new ProductFlavorData<GroupableProductFlavor>(productFlavor, mainSourceSet, testSourceSet, this.project);
        this.productFlavors.put(productFlavor.getName(), productFlavorData);
    }

    @NonNull
    public List<BaseVariantData<? extends BaseVariantOutputData>> getVariantDataList() {
        return this.variantDataList;
    }

    public void createAndroidTasks(@Nullable com.android.builder.model.SigningConfig signingOverride) {
        this.variantFactory.validateModel(this);
        if (!this.productFlavors.isEmpty()) {
            Task assembleTest = this.project.getTasks().create("assembleTest");
            assembleTest.setGroup("build");
            assembleTest.setDescription("Assembles all the Test applications");
            this.basePlugin.setAssembleTest(assembleTest);
        }
        if (this.variantDataList.isEmpty()) {
            this.populateVariantDataList(signingOverride);
        }
        for (BaseVariantData<? extends BaseVariantOutputData> variantData : this.variantDataList) {
            this.createTasksForVariantData(this.project.getTasks(), variantData);
        }
        this.basePlugin.createLintTasks();
        this.basePlugin.createCheckTasks(!this.productFlavors.isEmpty(), false);
        this.createApiObjects();
    }

    public void createTasksForVariantData(TaskContainer tasks, BaseVariantData variantData) {
        if (variantData.getVariantConfiguration().getType() == VariantConfiguration.Type.TEST) {
            GradleVariantConfiguration testVariantConfig = variantData.getVariantConfiguration();
            BaseVariantData testedVariantData = (BaseVariantData)((Object)((TestVariantData)variantData).getTestedVariantData());
            ArrayList testVariantProviders = Lists.newArrayListWithExpectedSize((int)(2 + testVariantConfig.getProductFlavors().size()));
            for (GroupableProductFlavor productFlavor : testVariantConfig.getProductFlavors()) {
                ProductFlavorData<GroupableProductFlavor> data = this.productFlavors.get(productFlavor.getName());
                testVariantProviders.add(data.getTestProvider());
            }
            testVariantProviders.add(this.basePlugin.getDefaultConfigData().getTestProvider());
            assert (testVariantConfig.getTestedConfig() != null);
            if (testVariantConfig.getTestedConfig().getType() == VariantConfiguration.Type.LIBRARY) {
                testVariantProviders.add(testedVariantData.getVariantDependency());
            }
            VariantDependencies variantDep = VariantDependencies.compute(this.project, testVariantConfig.getFullName(), false, this.variantFactory.isLibrary(), testVariantProviders.toArray(new ConfigurationProvider[testVariantProviders.size()]));
            variantData.setVariantDependency(variantDep);
            this.basePlugin.resolveDependencies(variantDep);
            testVariantConfig.setDependencies(variantDep);
            this.basePlugin.createTestApkTasks((TestVariantData)variantData);
        } else if (this.productFlavors.isEmpty()) {
            this.variantFactory.createTasks(variantData, this.buildTypes.get(((BuildType)variantData.getVariantConfiguration().getBuildType()).getName()).getAssembleTask());
        } else {
            this.variantFactory.createTasks(variantData, null);
            this.buildTypes.get(((BuildType)variantData.getVariantConfiguration().getBuildType()).getName()).getAssembleTask().dependsOn(new Object[]{variantData.assembleVariantTask});
            GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
            for (GroupableProductFlavor flavor : variantConfig.getProductFlavors()) {
                this.productFlavors.get(flavor.getName()).getAssembleTask().dependsOn(new Object[]{variantData.assembleVariantTask});
            }
            Task assembleTask = null;
            if (variantConfig.getProductFlavors().size() > 1) {
                String name = StringHelper.capitalize(variantConfig.getFlavorName());
                assembleTask = (Task)tasks.findByName("assemble" + name);
                if (assembleTask == null) {
                    assembleTask = tasks.create("assemble" + name);
                    assembleTask.setDescription("Assembles all builds for flavor combination: " + name);
                    assembleTask.setGroup("Build");
                    tasks.getByName("assemble").dependsOn(new Object[]{assembleTask});
                }
            }
            if (assembleTask != null) {
                assembleTask.dependsOn(new Object[]{variantData.assembleVariantTask});
            }
        }
    }

    public void populateVariantDataList(@Nullable com.android.builder.model.SigningConfig signingOverride) {
        this.basePlugin.createLintCompileTask();
        if (this.productFlavors.isEmpty()) {
            this.createVariantDataForProductFlavors(signingOverride, Collections.<com.android.build.gradle.api.GroupableProductFlavor>emptyList());
        } else {
            List<String> flavorDimensionList = this.extension.getFlavorDimensionList();
            Iterable flavorDsl = Iterables.transform(this.productFlavors.values(), (Function)new Function<ProductFlavorData<GroupableProductFlavor>, GroupableProductFlavor>(){

                public GroupableProductFlavor apply(ProductFlavorData<GroupableProductFlavor> data) {
                    return data.getProductFlavor();
                }
            });
            List<ProductFlavorCombo> flavorComboList = ProductFlavorCombo.createCombinations(flavorDimensionList, flavorDsl);
            for (ProductFlavorCombo flavorCombo : flavorComboList) {
                this.createVariantDataForProductFlavors(signingOverride, flavorCombo.getFlavorList());
            }
        }
    }

    public BaseVariantData<? extends BaseVariantOutputData> createVariantData(@NonNull com.android.builder.model.BuildType buildType, @NonNull List<com.android.build.gradle.api.GroupableProductFlavor> productFlavorList, @Nullable com.android.builder.model.SigningConfig signingOverride) {
        Splits splits = this.basePlugin.getExtension().getSplits();
        Set<String> densities = splits.getDensityFilters();
        Set<String> abis = splits.getAbiFilters();
        densities = densities.isEmpty() ? Collections.singleton(OutputFile.NO_FILTER) : densities;
        abis = abis.isEmpty() ? Collections.singleton(OutputFile.NO_FILTER) : abis;
        ProductFlavorData<ProductFlavor> defaultConfigData = this.basePlugin.getDefaultConfigData();
        ProductFlavor defaultConfig = defaultConfigData.getProductFlavor();
        DefaultAndroidSourceSet defaultConfigSourceSet = defaultConfigData.getSourceSet();
        BuildTypeData buildTypeData = this.buildTypes.get(buildType.getName());
        Set<String> compatibleScreens = this.basePlugin.getExtension().getSplits().getDensity().getCompatibleScreens();
        GradleVariantConfiguration variantConfig = new GradleVariantConfiguration(defaultConfig, defaultConfigSourceSet, buildTypeData.getBuildType(), buildTypeData.getSourceSet(), this.variantFactory.getVariantConfigurationType(), signingOverride);
        NamedDomainObjectContainer<AndroidSourceSet> sourceSetsContainer = this.extension.getSourceSetsContainer();
        for (com.android.build.gradle.api.GroupableProductFlavor productFlavor : productFlavorList) {
            ProductFlavorData<GroupableProductFlavor> data = this.productFlavors.get(productFlavor.getName());
            String dimensionName = productFlavor.getFlavorDimension();
            if (dimensionName == null) {
                dimensionName = "";
            }
            variantConfig.addProductFlavor(data.getProductFlavor(), (SourceProvider)data.getSourceSet(), dimensionName);
        }
        ArrayList variantProviders = Lists.newArrayListWithExpectedSize((int)(productFlavorList.size() + 4));
        if (!productFlavorList.isEmpty()) {
            DefaultAndroidSourceSet variantSourceSet = (DefaultAndroidSourceSet)sourceSetsContainer.maybeCreate(variantConfig.getFullName());
            variantConfig.setVariantSourceProvider(variantSourceSet);
            variantProviders.add(new ProductFlavorData.ConfigurationProviderImpl(this.project, variantSourceSet));
        }
        variantProviders.add(buildTypeData);
        if (productFlavorList.size() > 1) {
            DefaultAndroidSourceSet multiFlavorSourceSet = (DefaultAndroidSourceSet)sourceSetsContainer.maybeCreate(variantConfig.getFlavorName());
            variantConfig.setMultiFlavorSourceProvider(multiFlavorSourceSet);
            variantProviders.add(new ProductFlavorData.ConfigurationProviderImpl(this.project, multiFlavorSourceSet));
        }
        for (com.android.build.gradle.api.GroupableProductFlavor productFlavor : productFlavorList) {
            variantProviders.add(this.productFlavors.get(productFlavor.getName()).getMainProvider());
        }
        variantProviders.add(defaultConfigData.getMainProvider());
        Object variantData = this.variantFactory.createVariantData(variantConfig, densities, abis, compatibleScreens);
        VariantDependencies variantDep = VariantDependencies.compute(this.project, variantConfig.getFullName(), this.isVariantPublished(), this.variantFactory.isLibrary(), variantProviders.toArray(new ConfigurationProvider[variantProviders.size()]));
        ((BaseVariantData)variantData).setVariantDependency(variantDep);
        if (variantConfig.isMultiDexEnabled() && variantConfig.isLegacyMultiDexMode()) {
            this.project.getDependencies().add(variantDep.getCompileConfiguration().getName(), (Object)COM_ANDROID_SUPPORT_MULTIDEX);
            this.project.getDependencies().add(variantDep.getPackageConfiguration().getName(), (Object)COM_ANDROID_SUPPORT_MULTIDEX);
        }
        this.basePlugin.resolveDependencies(variantDep);
        variantConfig.setDependencies(variantDep);
        return variantData;
    }

    public TestVariantData createTestVariantData(BaseVariantData testedVariantData, com.android.builder.model.SigningConfig signingOverride) {
        BuildTypeData testData = this.buildTypes.get(this.extension.getTestBuildType());
        ProductFlavorData<ProductFlavor> defaultConfigData = this.basePlugin.getDefaultConfigData();
        ProductFlavor defaultConfig = defaultConfigData.getProductFlavor();
        GradleVariantConfiguration testedConfig = testedVariantData.getVariantConfiguration();
        List productFlavorList = testedConfig.getProductFlavors();
        GradleVariantConfiguration testVariantConfig = new GradleVariantConfiguration(defaultConfig, defaultConfigData.getTestSourceSet(), testData.getBuildType(), null, VariantConfiguration.Type.TEST, testedVariantData.getVariantConfiguration(), signingOverride);
        for (com.android.build.gradle.api.GroupableProductFlavor productFlavor : productFlavorList) {
            ProductFlavorData<GroupableProductFlavor> data = this.productFlavors.get(productFlavor.getName());
            String dimensionName = productFlavor.getFlavorDimension();
            if (dimensionName == null) {
                dimensionName = "";
            }
            testVariantConfig.addProductFlavor(data.getProductFlavor(), (SourceProvider)data.getTestSourceSet(), dimensionName);
        }
        TestVariantData testVariantData = new TestVariantData(this.basePlugin, testVariantConfig, (TestedVariantData)((Object)testedVariantData));
        ((TestedVariantData)((Object)testedVariantData)).setTestVariantData(testVariantData);
        return testVariantData;
    }

    private void createVariantDataForProductFlavors(@Nullable com.android.builder.model.SigningConfig signingOverride, @NonNull List<com.android.build.gradle.api.GroupableProductFlavor> productFlavorList) {
        BuildTypeData testData = this.buildTypes.get(this.extension.getTestBuildType());
        if (testData == null) {
            throw new RuntimeException(String.format("Test Build Type '%1$s' does not exist.", this.extension.getTestBuildType()));
        }
        BaseVariantData<? extends BaseVariantOutputData> testedVariantData = null;
        ProductFlavorData<ProductFlavor> defaultConfigData = this.basePlugin.getDefaultConfigData();
        ProductFlavor defaultConfig = defaultConfigData.getProductFlavor();
        Closure<Void> variantFilterClosure = this.basePlugin.getExtension().getVariantFilter();
        for (BuildTypeData buildTypeData : this.buildTypes.values()) {
            boolean ignore = false;
            if (variantFilterClosure != null) {
                this.variantFilter.reset((com.android.builder.model.ProductFlavor)defaultConfig, (com.android.builder.model.BuildType)buildTypeData.getBuildType(), productFlavorList);
                variantFilterClosure.call((Object)this.variantFilter);
                ignore = this.variantFilter.isIgnore();
            }
            if (ignore) continue;
            BaseVariantData<? extends BaseVariantOutputData> variantData = this.createVariantData((com.android.builder.model.BuildType)buildTypeData.getBuildType(), productFlavorList, signingOverride);
            this.variantDataList.add(variantData);
            if (buildTypeData != testData) continue;
            GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
            if (variantConfig.isMinifyEnabled() && variantConfig.getUseJack()) {
                throw new RuntimeException("Cannot test obfuscated variants when compiling with jack.");
            }
            testedVariantData = variantData;
        }
        if (testedVariantData != null) {
            TestVariantData testVariantData = this.createTestVariantData(testedVariantData, signingOverride);
            this.variantDataList.add(testVariantData);
        }
    }

    private void createApiObjects() {
        HashMap map = Maps.newHashMap();
        for (BaseVariantData<? extends BaseVariantOutputData> variantData : this.variantDataList) {
            if (map.get(variantData) != null) continue;
            if (variantData instanceof TestVariantData) {
                TestVariantData testVariantData = (TestVariantData)variantData;
                this.createVariantApiObjects(map, (BaseVariantData)((Object)testVariantData.getTestedVariantData()), testVariantData);
                continue;
            }
            this.createVariantApiObjects(map, variantData, ((TestedVariantData)((Object)variantData)).getTestVariantData());
        }
    }

    private boolean isVariantPublished() {
        return this.extension.getPublishNonDefault();
    }

    private void createVariantApiObjects(@NonNull Map<BaseVariantData, BaseVariant> map, @NonNull BaseVariantData<?> variantData, @Nullable TestVariantData testVariantData) {
        BaseVariant variantApi = this.variantFactory.createVariantApi(variantData, this.readOnlyObjectProvider);
        TestVariantImpl testVariant = null;
        if (testVariantData != null) {
            testVariant = (TestVariantImpl)this.basePlugin.getInstantiator().newInstance(TestVariantImpl.class, new Object[]{testVariantData, this.basePlugin, this.readOnlyObjectProvider});
            ApplicationVariantFactory.createApkOutputApiObjects(this.basePlugin, testVariantData, testVariant);
        }
        if (testVariant != null) {
            ((TestedVariant)((Object)variantApi)).setTestVariant(testVariant);
            testVariant.setTestedVariant(variantApi);
        }
        this.extension.addVariant(variantApi);
        map.put(variantData, variantApi);
        if (testVariant != null) {
            this.extension.addTestVariant(testVariant);
            map.put(testVariantData, testVariant);
        }
    }

    private static void checkName(@NonNull String name, @NonNull String displayName) {
        if (name.startsWith("androidTest")) {
            throw new RuntimeException(String.format("%1$s names cannot start with '%2$s'", displayName, "androidTest"));
        }
        if (name.startsWith("uiTest")) {
            throw new RuntimeException(String.format("%1$s names cannot start with %2$s", displayName, "uiTest"));
        }
        if ("lint".equals(name)) {
            throw new RuntimeException(String.format("%1$s names cannot be %2$s", displayName, "lint"));
        }
    }
}

