/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.api.GroupableProductFlavor;
import com.android.build.gradle.internal.api.ImmutableFlavorList;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import java.util.Collections;
import java.util.List;

public class VariantFilter
implements com.android.build.gradle.api.VariantFilter {
    @NonNull
    private final ReadOnlyObjectProvider readOnlyObjectProvider;
    private boolean ignore;
    private ProductFlavor defaultConfig;
    private BuildType buildType;
    private List<GroupableProductFlavor> flavors;

    public VariantFilter(@NonNull ReadOnlyObjectProvider readOnlyObjectProvider) {
        this.readOnlyObjectProvider = readOnlyObjectProvider;
    }

    public void reset(@NonNull ProductFlavor defaultConfig, @NonNull BuildType buildType, @Nullable List<GroupableProductFlavor> flavors) {
        this.ignore = false;
        this.defaultConfig = defaultConfig;
        this.buildType = buildType;
        this.flavors = flavors;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    @Override
    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    @Override
    @NonNull
    public ProductFlavor getDefaultConfig() {
        return this.readOnlyObjectProvider.getDefaultConfig(this.defaultConfig);
    }

    @Override
    @NonNull
    public BuildType getBuildType() {
        return this.readOnlyObjectProvider.getBuildType(this.buildType);
    }

    @Override
    @NonNull
    public List<GroupableProductFlavor> getFlavors() {
        return this.flavors != null ? new ImmutableFlavorList(this.flavors, this.readOnlyObjectProvider) : Collections.emptyList();
    }
}

