/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.annotations.NonNull;
import com.android.build.OutputFile;
import com.android.build.gradle.internal.dsl.SplitOptions;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class DensitySplitOptions
extends SplitOptions {
    private boolean strict = true;
    private Set<String> compatibleScreens;

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setCompatibleScreens(@NonNull List<String> sizes) {
        this.compatibleScreens = Sets.newHashSet(sizes);
    }

    public void compatibleScreens(String ... sizes) {
        if (this.compatibleScreens == null) {
            this.compatibleScreens = Sets.newHashSet((Object[])sizes);
            return;
        }
        this.compatibleScreens.addAll(Arrays.asList(sizes));
    }

    @NonNull
    public Set<String> getCompatibleScreens() {
        if (this.compatibleScreens == null) {
            return Collections.emptySet();
        }
        return this.compatibleScreens;
    }

    @Override
    @NonNull
    public Set<String> getApplicableFilters(@NonNull Set<String> allFilters) {
        Set<String> list = super.getApplicableFilters(allFilters);
        if (this.isEnable()) {
            list.add(OutputFile.NO_FILTER);
        }
        return list;
    }
}

