/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.internal.model.ApiVersionImpl;
import com.android.build.gradle.internal.model.BaseConfigImpl;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SigningConfig;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;

class ProductFlavorImpl
extends BaseConfigImpl
implements ProductFlavor,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name = null;
    private ApiVersion mMinSdkVersion = null;
    private ApiVersion mTargetSdkVersion = null;
    private Integer mMaxSdkVersion = null;
    private Integer mRenderscriptTargetApi = null;
    private Boolean mRenderscriptSupportMode = null;
    private Boolean mRenderscriptNdkMode = null;
    private Integer mVersionCode = null;
    private String mVersionName = null;
    private String mApplicationId = null;
    private String mTestApplicationId = null;
    private String mTestInstrumentationRunner = null;
    private Boolean mTestHandleProfiling = null;
    private Boolean mTestFunctionalTest = null;
    private Set<String> mResourceConfigurations = null;

    @NonNull
    static ProductFlavorImpl cloneFlavor(@NonNull ProductFlavor productFlavor, @Nullable ApiVersion minSdkVersionOverride, @Nullable ApiVersion targetSdkVersionOverride) {
        ProductFlavorImpl clonedFlavor = new ProductFlavorImpl(productFlavor);
        clonedFlavor.name = productFlavor.getName();
        clonedFlavor.mMinSdkVersion = minSdkVersionOverride != null ? minSdkVersionOverride : ApiVersionImpl.clone(productFlavor.getMinSdkVersion());
        clonedFlavor.mTargetSdkVersion = targetSdkVersionOverride != null ? targetSdkVersionOverride : ApiVersionImpl.clone(productFlavor.getTargetSdkVersion());
        clonedFlavor.mMaxSdkVersion = targetSdkVersionOverride != null ? null : productFlavor.getMaxSdkVersion();
        clonedFlavor.mRenderscriptTargetApi = productFlavor.getRenderscriptTargetApi();
        clonedFlavor.mRenderscriptSupportMode = productFlavor.getRenderscriptSupportModeEnabled();
        clonedFlavor.mRenderscriptNdkMode = productFlavor.getRenderscriptNdkModeEnabled();
        clonedFlavor.mVersionCode = productFlavor.getVersionCode();
        clonedFlavor.mVersionName = productFlavor.getVersionName();
        clonedFlavor.mApplicationId = productFlavor.getApplicationId();
        clonedFlavor.mTestApplicationId = productFlavor.getTestApplicationId();
        clonedFlavor.mTestInstrumentationRunner = productFlavor.getTestInstrumentationRunner();
        clonedFlavor.mTestHandleProfiling = productFlavor.getTestHandleProfiling();
        clonedFlavor.mTestFunctionalTest = productFlavor.getTestFunctionalTest();
        clonedFlavor.mResourceConfigurations = ImmutableSet.copyOf((Collection)productFlavor.getResourceConfigurations());
        return clonedFlavor;
    }

    private ProductFlavorImpl(@NonNull ProductFlavor productFlavor) {
        super((BaseConfig)productFlavor);
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getApplicationId() {
        return this.mApplicationId;
    }

    @Nullable
    public Integer getVersionCode() {
        return this.mVersionCode;
    }

    @Nullable
    public String getVersionName() {
        return this.mVersionName;
    }

    @Nullable
    public ApiVersion getMinSdkVersion() {
        return this.mMinSdkVersion;
    }

    @Nullable
    public ApiVersion getTargetSdkVersion() {
        return this.mTargetSdkVersion;
    }

    @Nullable
    public Integer getMaxSdkVersion() {
        return this.mMaxSdkVersion;
    }

    @Nullable
    public Integer getRenderscriptTargetApi() {
        return this.mRenderscriptTargetApi;
    }

    @Nullable
    public Boolean getRenderscriptSupportModeEnabled() {
        return this.mRenderscriptSupportMode;
    }

    @Nullable
    public Boolean getRenderscriptNdkModeEnabled() {
        return this.mRenderscriptNdkMode;
    }

    @Nullable
    public String getTestApplicationId() {
        return this.mTestApplicationId;
    }

    @Nullable
    public String getTestInstrumentationRunner() {
        return this.mTestInstrumentationRunner;
    }

    @Nullable
    public Boolean getTestHandleProfiling() {
        return this.mTestHandleProfiling;
    }

    @Nullable
    public Boolean getTestFunctionalTest() {
        return this.mTestFunctionalTest;
    }

    @NonNull
    public Collection<String> getResourceConfigurations() {
        return this.mResourceConfigurations;
    }

    @Nullable
    public SigningConfig getSigningConfig() {
        return null;
    }

    @Override
    public String toString() {
        return "ProductFlavorImpl{name='" + this.name + '\'' + ", mMinSdkVersion=" + this.mMinSdkVersion + ", mTargetSdkVersion=" + this.mTargetSdkVersion + ", mMaxSdkVersion=" + this.mMaxSdkVersion + ", mRenderscriptTargetApi=" + this.mRenderscriptTargetApi + ", mRenderscriptSupportMode=" + this.mRenderscriptSupportMode + ", mRenderscriptNdkMode=" + this.mRenderscriptNdkMode + ", mVersionCode=" + this.mVersionCode + ", mVersionName='" + this.mVersionName + '\'' + ", mApplicationId='" + this.mApplicationId + '\'' + ", mTestApplicationId='" + this.mTestApplicationId + '\'' + ", mTestInstrumentationRunner='" + this.mTestInstrumentationRunner + '\'' + ", mTestHandleProfiling=" + this.mTestHandleProfiling + ", mTestFunctionalTest=" + this.mTestFunctionalTest + ", mResourceConfigurations=" + this.mResourceConfigurations + "} " + super.toString();
    }
}

