/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle;

import com.android.annotations.Nullable;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.BadPluginException;
import com.android.build.gradle.internal.DependencyManager;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.LibraryCache;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantManager;
import com.android.build.gradle.internal.coverage.JacocoPlugin;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.BuildTypeFactory;
import com.android.build.gradle.internal.dsl.GroupableProductFlavor;
import com.android.build.gradle.internal.dsl.GroupableProductFlavorFactory;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.dsl.SigningConfigFactory;
import com.android.build.gradle.internal.model.ModelBuilder;
import com.android.build.gradle.internal.process.GradleJavaProcessExecutor;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.tasks.JillTask;
import com.android.build.gradle.tasks.PreDex;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.BuilderConstants;
import com.android.builder.core.DefaultBuildType;
import com.android.builder.internal.compiler.JackConversionCache;
import com.android.builder.internal.compiler.PreDexCache;
import com.android.builder.model.AndroidProject;
import com.android.builder.sdk.TargetInfo;
import com.android.ide.common.blame.output.BlameAwareLoggedProcessOutputHandler;
import com.android.ide.common.internal.ExecutorSingleton;
import com.android.ide.common.process.JavaProcessExecutor;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.utils.ILogger;
import com.google.common.collect.UnmodifiableIterator;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DateGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public abstract class BasePlugin
implements GroovyObject {
    private static final String GRADLE_MIN_VERSION = "2.2";
    public static final String GRADLE_TEST_VERSION = "2.2";
    public static final Pattern GRADLE_ACCEPTABLE_VERSIONS;
    private static final String GRADLE_VERSION_CHECK_OVERRIDE_PROPERTY = "com.android.build.gradle.overrideVersionCheck";
    private static final int DEFAULT_RETIREMENT_AGE_FOR_NON_RELEASE = 40;
    protected BaseExtension extension;
    protected VariantManager variantManager;
    protected TaskManager taskManager;
    protected Project project;
    protected SdkHandler sdkHandler;
    protected AndroidBuilder androidBuilder;
    protected Instantiator instantiator;
    private ToolingModelBuilderRegistry registry;
    private JacocoPlugin jacocoPlugin;
    private LoggerWrapper loggerWrapper;
    private ExtraModelInfo extraModelInfo;
    private String creator;
    private boolean hasCreatedTasks;
    private static final GregorianCalendar inceptionDate;
    private static final int retirementAge = 40;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    public static /* synthetic */ long __timeStamp;
    public static /* synthetic */ long __timeStamp__239_neverHappen1422908040946;
    private static /* synthetic */ SoftReference $callSiteArray;

    /*
     * WARNING - void declaration
     */
    protected BasePlugin(Instantiator instantiator, ToolingModelBuilderRegistry toolingModelBuilderRegistry) {
        String string;
        String string2;
        void registry;
        void instantiator2;
        MetaClass metaClass;
        boolean bl;
        this.hasCreatedTasks = bl = false;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var5_5 = instantiator2;
        this.instantiator = var5_5;
        void var6_6 = registry;
        this.registry = var6_6;
        String pluginVersion = BasePlugin.getLocalVersion();
        this.creator = pluginVersion != null ? (string2 = StringGroovyMethods.plus((String)"Android Gradle ", (CharSequence)pluginVersion)) : (string = "Android Gradle");
        this.verifyRetirementAge();
    }

    private void verifyRetirementAge() {
        Manifest manifest = null;
        URLClassLoader cl = (URLClassLoader)ScriptBytecodeAdapter.castToType((Object)this.getClass().getClassLoader(), URLClassLoader.class);
        try {
            Manifest manifest2;
            URL url = cl.findResource("META-INF/MANIFEST.MF");
            manifest = manifest2 = new Manifest(url.openStream());
        }
        catch (IOException ignore) {
            this.getLogger().info(ignore.toString(), new Object[0]);
            return;
        }
        String inceptionDateAttr = manifest.getMainAttributes().getValue("Inception-Date");
        if (inceptionDateAttr == null) {
            return;
        }
        Object[] items = inceptionDateAttr.split(":");
        GregorianCalendar inceptionDate = new GregorianCalendar(Integer.parseInt(ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])items, (int)0))), Integer.parseInt(ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])items, (int)1))), Integer.parseInt(ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])items, (int)2))));
        int retirementAge = BasePlugin.getRetirementAge(manifest.getMainAttributes().getValue("Plugin-Version"));
        if (ScriptBytecodeAdapter.compareEqual((Object)retirementAge, (Object)-1)) {
            return;
        }
        Calendar now = Calendar.getInstance();
        int days = DateGroovyMethods.minus((Calendar)now, (Calendar)inceptionDate);
        if (days > retirementAge) {
            String dailyOverride = System.getenv("ANDROID_DAILY_OVERRIDE");
            MessageDigest cript = MessageDigest.getInstance("SHA-1");
            cript.reset();
            cript.update(new GStringImpl(new Object[]{now.get(Calendar.YEAR), now.get(Calendar.MONTH), now.get(Calendar.DATE)}, new String[]{"", ":", ":", ""}).getBytes("utf8"));
            String overrideValue = new BigInteger(1, cript.digest()).toString(16);
            if (dailyOverride == null) {
                String message = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{overrideValue}, new String[]{"\n                    Plugin is too old, please update to a more recent version,\n                    or set ANDROID_DAILY_OVERRIDE environment variable to\n                    \"", "\""}));
                System.err.println(message);
                throw (Throwable)new RuntimeException(message);
            }
            if (!dailyOverride.equals(overrideValue)) {
                String message = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{overrideValue}, new String[]{"\n                    Plugin is too old and ANDROID_DAILY_OVERRIDE value is\n                    also outdated, please use new value :\n                    \"", "\""}));
                System.err.println(message);
                throw (Throwable)new RuntimeException(message);
            }
        }
    }

    private static int getRetirementAge(@Nullable String version) {
        if (version == null || StringGroovyMethods.contains((String)version, (String)"rc") || StringGroovyMethods.contains((String)version, (String)"beta")) {
            return DEFAULT_RETIREMENT_AGE_FOR_NON_RELEASE;
        }
        return -1;
    }

    protected abstract Class<? extends BaseExtension> getExtensionClass();

    protected abstract VariantFactory getVariantFactory();

    protected abstract TaskManager createTaskManager(Project var1, TaskContainer var2, AndroidBuilder var3, BaseExtension var4, SdkHandler var5, DependencyManager var6, ToolingModelBuilderRegistry var7);

    protected boolean isLibrary() {
        return false;
    }

    public VariantManager getVariantManager() {
        return this.variantManager;
    }

    protected ILogger getLogger() {
        if (this.loggerWrapper == null) {
            LoggerWrapper loggerWrapper;
            this.loggerWrapper = loggerWrapper = new LoggerWrapper(this.project.getLogger());
        }
        return this.loggerWrapper;
    }

    protected void apply(Project project) {
        Project project2;
        this.project = project2 = project;
        this.configureProject();
        this.createExtension();
        this.createTasks();
    }

    protected void configureProject() {
        AndroidBuilder androidBuilder;
        SdkHandler sdkHandler;
        ExtraModelInfo extraModelInfo;
        this.checkGradleVersion();
        this.extraModelInfo = extraModelInfo = new ExtraModelInfo(this.project);
        this.sdkHandler = sdkHandler = new SdkHandler(this.project, this.getLogger());
        this.androidBuilder = androidBuilder = new AndroidBuilder(ScriptBytecodeAdapter.compareEqual((Object)this.project, (Object)this.project.getRootProject()) ? this.project.getName() : this.project.getPath(), this.creator, (ProcessExecutor)new GradleProcessExecutor(this.project), (JavaProcessExecutor)new GradleJavaProcessExecutor(this.project), (ProcessOutputHandler)new BlameAwareLoggedProcessOutputHandler(this.getLogger(), this.extraModelInfo.getErrorFormatMode()), this.getLogger(), this.isVerbose());
        this.project.apply(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"plugin", JavaBasePlugin.class}));
        this.project.apply(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"plugin", JacocoPlugin.class}));
        Plugin plugin = this.project.getPlugins().getPlugin(JacocoPlugin.class);
        this.jacocoPlugin = (JacocoPlugin)ScriptBytecodeAdapter.castToType((Object)plugin, JacocoPlugin.class);
        this.project.getTasks().getByName("assemble").setDescription("Assembles all variants of all applications and secondary packages.");
        this.project.getGradle().buildFinished((Closure)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(Object it) {
                ExecutorSingleton.shutdown();
                ((SdkHandler)this.getProperty("sdkHandler")).unload();
                PreDexCache.getCache().clear(((Project)this.getProperty("project")).getRootProject().file((Object)new GStringImpl(new Object[]{((Project)this.getProperty("project")).getRootProject().getBuildDir(), AndroidProject.FD_INTERMEDIATES}, new String[]{"", "/", "/dex-cache/cache.xml"})), (ILogger)ScriptBytecodeAdapter.castToType((Object)this.getProperty("logger"), ILogger.class));
                JackConversionCache.getCache().clear(((Project)this.getProperty("project")).getRootProject().file((Object)new GStringImpl(new Object[]{((Project)this.getProperty("project")).getRootProject().getBuildDir(), AndroidProject.FD_INTERMEDIATES}, new String[]{"", "/", "/jack-cache/cache.xml"})), (ILogger)ScriptBytecodeAdapter.castToType((Object)this.getProperty("logger"), ILogger.class));
                return LibraryCache.getCache().unload();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _configureProject_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _configureProject_closure1.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_configureProject_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _configureProject_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        this.project.getGradle().getTaskGraph().whenReady((Closure)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(TaskExecutionGraph taskGraph) {
                Task task = null;
                Iterator iterator = taskGraph.getAllTasks().iterator();
                while (iterator.hasNext()) {
                    task = (Task)ScriptBytecodeAdapter.castToType(iterator.next(), Task.class);
                    if (task instanceof PreDex) {
                        PreDexCache.getCache().load(((Project)this.getProperty("project")).getRootProject().file((Object)new GStringImpl(new Object[]{((Project)this.getProperty("project")).getRootProject().getBuildDir(), AndroidProject.FD_INTERMEDIATES}, new String[]{"", "/", "/dex-cache/cache.xml"})));
                        break;
                    }
                    if (!(task instanceof JillTask)) continue;
                    JackConversionCache.getCache().load(((Project)this.getProperty("project")).getRootProject().file((Object)new GStringImpl(new Object[]{((Project)this.getProperty("project")).getRootProject().getBuildDir(), AndroidProject.FD_INTERMEDIATES}, new String[]{"", "/", "/jack-cache/cache.xml"})));
                    break;
                }
                return null;
            }

            public Object call(TaskExecutionGraph taskGraph) {
                return this.doCall(taskGraph);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _configureProject_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _configureProject_closure2.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_configureProject_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _configureProject_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    private void createExtension() {
        VariantManager variantManager;
        TaskManager taskManager;
        NamedDomainObjectContainer buildTypeContainer = this.project.container(BuildType.class, (NamedDomainObjectFactory)new BuildTypeFactory(this.instantiator, this.project, this.project.getLogger()));
        NamedDomainObjectContainer productFlavorContainer = this.project.container(GroupableProductFlavor.class, (NamedDomainObjectFactory)new GroupableProductFlavorFactory(this.instantiator, this.project, this.project.getLogger()));
        NamedDomainObjectContainer signingConfigContainer = this.project.container(SigningConfig.class, (NamedDomainObjectFactory)new SigningConfigFactory(this.instantiator));
        Object object = this.project.getExtensions().create("android", this.getExtensionClass(), new Object[]{(ProjectInternal)ScriptBytecodeAdapter.castToType((Object)this.project, ProjectInternal.class), this.instantiator, this.androidBuilder, this.sdkHandler, buildTypeContainer, productFlavorContainer, signingConfigContainer, this.extraModelInfo, this.isLibrary()});
        this.extension = (BaseExtension)ScriptBytecodeAdapter.castToType((Object)object, BaseExtension.class);
        DependencyManager dependencyManager = new DependencyManager(this.project, this.extraModelInfo);
        this.taskManager = taskManager = this.createTaskManager(this.project, this.project.getTasks(), this.androidBuilder, this.extension, this.sdkHandler, dependencyManager, this.registry);
        this.variantManager = variantManager = new VariantManager(this.project, this.androidBuilder, this.extension, this.getVariantFactory(), this.taskManager, this.instantiator);
        ModelBuilder modelBuilder = new ModelBuilder(this.androidBuilder, this.variantManager, this.taskManager, this.extension, this.extraModelInfo, this.isLibrary());
        this.registry.register((ToolingModelBuilder)modelBuilder);
        signingConfigContainer.whenObjectAdded((Closure)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(SigningConfig signingConfig) {
                ((VariantManager)this.getProperty("variantManager")).addSigningConfig(signingConfig);
                return null;
            }

            public Object call(SigningConfig signingConfig) {
                return this.doCall(signingConfig);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createExtension_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _createExtension_closure3.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_createExtension_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createExtension_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        buildTypeContainer.whenObjectAdded((Closure)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(DefaultBuildType buildType) {
                ((VariantManager)this.getProperty("variantManager")).addBuildType((BuildType)ScriptBytecodeAdapter.castToType((Object)buildType, BuildType.class));
                return null;
            }

            public Object call(DefaultBuildType buildType) {
                return this.doCall(buildType);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createExtension_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _createExtension_closure4.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_createExtension_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createExtension_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        productFlavorContainer.whenObjectAdded((Closure)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(GroupableProductFlavor productFlavor) {
                ((VariantManager)this.getProperty("variantManager")).addProductFlavor(productFlavor);
                return null;
            }

            public Object call(GroupableProductFlavor productFlavor) {
                return this.doCall(productFlavor);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createExtension_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _createExtension_closure5.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_createExtension_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createExtension_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        signingConfigContainer.create(BuilderConstants.DEBUG);
        buildTypeContainer.create(BuilderConstants.DEBUG);
        buildTypeContainer.create(BuilderConstants.RELEASE);
        signingConfigContainer.whenObjectRemoved((Closure)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(Object it) {
                throw (Throwable)new UnsupportedOperationException("Removing signingConfigs is not supported.");
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createExtension_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _createExtension_closure6.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_createExtension_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createExtension_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        buildTypeContainer.whenObjectRemoved((Closure)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(Object it) {
                throw (Throwable)new UnsupportedOperationException("Removing build types is not supported.");
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createExtension_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _createExtension_closure7.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_createExtension_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createExtension_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        productFlavorContainer.whenObjectRemoved((Closure)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(Object it) {
                throw (Throwable)new UnsupportedOperationException("Removing product flavors is not supported.");
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createExtension_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _createExtension_closure8.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_createExtension_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createExtension_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    private void createTasks() {
        this.taskManager.createTasks();
        this.project.afterEvaluate((Closure)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(Object it) {
                ((BasePlugin)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), BasePlugin.class)).ensureTargetSetup();
                ((BasePlugin)ScriptBytecodeAdapter.castToType((Object)this.getProperty("thisObject"), BasePlugin.class)).createAndroidTasks(false);
                return null;
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createTasks_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _createTasks_closure9.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_createTasks_closure9.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createTasks_closure9.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    private void checkGradleVersion() {
        if (!GRADLE_ACCEPTABLE_VERSIONS.matcher(this.project.getGradle().getGradleVersion()).matches()) {
            boolean allowNonMatching = Boolean.getBoolean(GRADLE_VERSION_CHECK_OVERRIDE_PROPERTY);
            File file = new File(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"gradle", (CharSequence)File.separator), (CharSequence)"wrapper"), (CharSequence)File.separator), (CharSequence)"gradle-wrapper.properties"));
            String errorMessage = String.format(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Gradle version %s is required. Current version is %s. ", (CharSequence)"If using the gradle wrapper, try editing the distributionUrl in %s "), (CharSequence)"to gradle-%s-all.zip"), GRADLE_MIN_VERSION, this.project.getGradle().getGradleVersion(), file.getAbsolutePath(), GRADLE_MIN_VERSION);
            if (allowNonMatching) {
                this.getLogger().warning(errorMessage, new Object[0]);
                this.getLogger().warning("As %s is set, continuing anyways.", new Object[]{GRADLE_VERSION_CHECK_OVERRIDE_PROPERTY});
            } else {
                throw (Throwable)new BuildException(errorMessage, null);
            }
        }
    }

    public final void createAndroidTasks(boolean force) {
        boolean bl;
        if (this.project.getPlugins().hasPlugin(JavaPlugin.class)) {
            throw (Throwable)new BadPluginException("The 'java' plugin has been applied, but it is not compatible with the Android plugins.");
        }
        if (!force && (!this.project.getState().getExecuted() || this.project.getState().getFailure() != null) && SdkHandler.sTestSdkFolder == null) {
            return;
        }
        if (this.hasCreatedTasks) {
            return;
        }
        this.hasCreatedTasks = bl = true;
        this.extension.disableWrite();
        Reference file = new Reference(null);
        UnmodifiableIterator unmodifiableIterator = this.sdkHandler.getSdkLoader().getRepositories().iterator();
        while (unmodifiableIterator.hasNext()) {
            file.set((Object)((File)ScriptBytecodeAdapter.castToType(unmodifiableIterator.next(), File.class)));
            this.project.getRepositories().maven((Closure)new GeneratedClosure(this, this, file){
                private /* synthetic */ Reference file;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    Reference reference;
                    this.file = reference = file;
                }

                public Object doCall(MavenArtifactRepository repo) {
                    repo.setUrl((Object)((File)this.file.get()).toURI());
                    return null;
                }

                public Object call(MavenArtifactRepository repo) {
                    return this.doCall(repo);
                }

                public File getFile() {
                    return (File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _createAndroidTasks_closure10.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public static /* synthetic */ void __$swapInit() {
                }

                static {
                    _createAndroidTasks_closure10.__$swapInit();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_createAndroidTasks_closure10.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _createAndroidTasks_closure10.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            });
        }
        this.taskManager.createMockableJarTask();
        this.variantManager.createAndroidTasks((com.android.builder.model.SigningConfig)this.getSigningOverride());
    }

    private SigningConfig getSigningOverride() {
        if (this.project.hasProperty(AndroidProject.PROPERTY_SIGNING_STORE_FILE) && this.project.hasProperty(AndroidProject.PROPERTY_SIGNING_STORE_PASSWORD) && this.project.hasProperty(AndroidProject.PROPERTY_SIGNING_KEY_ALIAS) && this.project.hasProperty(AndroidProject.PROPERTY_SIGNING_KEY_PASSWORD)) {
            SigningConfig signingConfigDsl = new SigningConfig("externalOverride");
            Map props = this.project.getProperties();
            signingConfigDsl.setStoreFile(new File(ShortTypeHandling.castToString(props.get(AndroidProject.PROPERTY_SIGNING_STORE_FILE))));
            signingConfigDsl.setStorePassword(ShortTypeHandling.castToString(props.get(AndroidProject.PROPERTY_SIGNING_STORE_PASSWORD)));
            signingConfigDsl.setKeyAlias(ShortTypeHandling.castToString(props.get(AndroidProject.PROPERTY_SIGNING_KEY_ALIAS)));
            signingConfigDsl.setKeyPassword(ShortTypeHandling.castToString(props.get(AndroidProject.PROPERTY_SIGNING_KEY_PASSWORD)));
            if (this.project.hasProperty(AndroidProject.PROPERTY_SIGNING_STORE_TYPE)) {
                signingConfigDsl.setStoreType(ShortTypeHandling.castToString(props.get(AndroidProject.PROPERTY_SIGNING_STORE_TYPE)));
            }
            return signingConfigDsl;
        }
        return (SigningConfig)ScriptBytecodeAdapter.castToType(null, SigningConfig.class);
    }

    private boolean isVerbose() {
        return this.project.getLogger().isEnabled(LogLevel.INFO);
    }

    private void ensureTargetSetup() {
        TargetInfo targetInfo = this.androidBuilder.getTargetInfo();
        if (targetInfo == null) {
            this.sdkHandler.initTarget(this.extension.getCompileSdkVersion(), this.extension.getBuildToolsRevision(), this.androidBuilder);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getLocalVersion() {
        String classPath;
        try {
            Class<BasePlugin> clazz = BasePlugin.class;
            String className = StringGroovyMethods.plus((String)clazz.getSimpleName(), (CharSequence)".class");
            classPath = clazz.getResource(className).toString();
            if (!classPath.startsWith("jar")) {
                return ShortTypeHandling.castToString(null);
            }
        }
        catch (Throwable t) {
            String string = ShortTypeHandling.castToString(null);
            return string;
        }
        {
            String manifestPath = StringGroovyMethods.plus((String)classPath.substring(0, classPath.lastIndexOf("!") + 1), (CharSequence)"/META-INF/MANIFEST.MF");
            URLConnection jarConnection = new URL(manifestPath).openConnection();
            jarConnection.setUseCaches(false);
            InputStream jarInputStream = jarConnection.getInputStream();
            Attributes attr = new Manifest(jarInputStream).getMainAttributes();
            jarInputStream.close();
            return attr.getValue("Plugin-Version");
        }
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(BasePlugin.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, BasePlugin.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(BasePlugin.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != BasePlugin.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
    }

    static {
        GregorianCalendar gregorianCalendar;
        Pattern pattern;
        BasePlugin.__$swapInit();
        Long l = 0L;
        __timeStamp__239_neverHappen1422908040946 = l;
        Long l2 = 1422908040946L;
        __timeStamp = l2;
        GRADLE_ACCEPTABLE_VERSIONS = pattern = Pattern.compile("2\\.[2-9].*");
        inceptionDate = gregorianCalendar = new GregorianCalendar(2015, 0, 26);
    }

    public /* synthetic */ void this$2$verifyRetirementAge() {
        this.verifyRetirementAge();
    }

    public /* synthetic */ void this$2$createExtension() {
        this.createExtension();
    }

    public /* synthetic */ void this$2$createTasks() {
        this.createTasks();
    }

    public /* synthetic */ void this$2$checkGradleVersion() {
        this.checkGradleVersion();
    }

    public /* synthetic */ SigningConfig this$2$getSigningOverride() {
        return this.getSigningOverride();
    }

    public /* synthetic */ boolean this$2$isVerbose() {
        return this.isVerbose();
    }

    public /* synthetic */ void this$2$ensureTargetSetup() {
        this.ensureTargetSetup();
    }

    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ void super$1$wait(long l) {
        super.wait(l);
    }

    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ Class super$1$getClass() {
        return super.getClass();
    }

    public /* synthetic */ Object super$1$clone() {
        return super.clone();
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(BasePlugin.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = BasePlugin.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

