/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.internal.ConfigurationDependencies;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.model.ArtifactMetaDataImpl;
import com.android.build.gradle.internal.model.JavaArtifactImpl;
import com.android.build.gradle.internal.model.SyncIssueImpl;
import com.android.build.gradle.internal.model.SyncIssueKey;
import com.android.build.gradle.internal.variant.DefaultSourceProviderContainer;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.ArtifactMetaData;
import com.android.builder.model.JavaArtifact;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.android.builder.model.SyncIssue;
import com.android.ide.common.blame.output.GradleMessageRewriter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;

public class ExtraModelInfo {
    @NonNull
    private final Project project;
    private final ModelQueryMode modelQueryMode;
    private final GradleMessageRewriter.ErrorFormatMode errorFormatMode;
    private final Map<SyncIssueKey, SyncIssue> syncIssues = Maps.newHashMap();
    private final Map<String, ArtifactMetaData> extraArtifactMap = Maps.newHashMap();
    private final ListMultimap<String, AndroidArtifact> extraAndroidArtifacts = ArrayListMultimap.create();
    private final ListMultimap<String, JavaArtifact> extraJavaArtifacts = ArrayListMultimap.create();
    private final ListMultimap<String, SourceProviderContainer> extraVariantSourceProviders = ArrayListMultimap.create();
    private final ListMultimap<String, SourceProviderContainer> extraBuildTypeSourceProviders = ArrayListMultimap.create();
    private final ListMultimap<String, SourceProviderContainer> extraProductFlavorSourceProviders = ArrayListMultimap.create();
    private final ListMultimap<String, SourceProviderContainer> extraMultiFlavorSourceProviders = ArrayListMultimap.create();

    public ExtraModelInfo(@NonNull Project project) {
        this.project = project;
        this.modelQueryMode = ExtraModelInfo.computeModelQueryMode(project);
        this.errorFormatMode = ExtraModelInfo.computeErrorFormatMode(project);
    }

    public Map<SyncIssueKey, SyncIssue> getSyncIssues() {
        return this.syncIssues;
    }

    public ModelQueryMode getModelQueryMode() {
        return this.modelQueryMode;
    }

    public GradleMessageRewriter.ErrorFormatMode getErrorFormatMode() {
        return this.errorFormatMode;
    }

    public SyncIssue handleSyncError(@NonNull String data, int type, @NonNull String msg) {
        switch (this.modelQueryMode) {
            case STANDARD: {
                if (ExtraModelInfo.isDependencyIssue(type)) {
                    this.project.getLogger().warn("WARNING: " + msg);
                    return new SyncIssueImpl(type, 2, data, msg);
                }
                throw new GradleException(msg);
            }
            case IDE: {
                if (type != 2) {
                    throw new GradleException(msg);
                }
            }
            case IDE_ADVANCED: {
                SyncIssueImpl syncIssue = new SyncIssueImpl(type, 2, data, msg);
                this.syncIssues.put(SyncIssueKey.from(syncIssue), syncIssue);
            }
        }
        return null;
    }

    private static boolean isDependencyIssue(int type) {
        switch (type) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public Collection<ArtifactMetaData> getExtraArtifacts() {
        return this.extraArtifactMap.values();
    }

    public Collection<AndroidArtifact> getExtraAndroidArtifacts(@NonNull String variantName) {
        return this.extraAndroidArtifacts.get((Object)variantName);
    }

    public Collection<JavaArtifact> getExtraJavaArtifacts(@NonNull String variantName) {
        return this.extraJavaArtifacts.get((Object)variantName);
    }

    public Collection<SourceProviderContainer> getExtraVariantSourceProviders(@NonNull String variantName) {
        return this.extraVariantSourceProviders.get((Object)variantName);
    }

    public Collection<SourceProviderContainer> getExtraFlavorSourceProviders(@NonNull String flavorName) {
        return this.extraProductFlavorSourceProviders.get((Object)flavorName);
    }

    public Collection<SourceProviderContainer> getExtraBuildTypeSourceProviders(@NonNull String buildTypeName) {
        return this.extraBuildTypeSourceProviders.get((Object)buildTypeName);
    }

    public void registerArtifactType(@NonNull String name, boolean isTest, int artifactType) {
        if (this.extraArtifactMap.get(name) != null) {
            throw new IllegalArgumentException("Artifact with name $name already registered.");
        }
        this.extraArtifactMap.put(name, new ArtifactMetaDataImpl(name, isTest, artifactType));
    }

    public void registerBuildTypeSourceProvider(@NonNull String name, @NonNull BuildType buildType, @NonNull SourceProvider sourceProvider) {
        if (this.extraArtifactMap.get(name) == null) {
            throw new IllegalArgumentException("Artifact with name $name is not yet registered. Use registerArtifactType()");
        }
        this.extraBuildTypeSourceProviders.put((Object)buildType.getName(), (Object)new DefaultSourceProviderContainer(name, sourceProvider));
    }

    public void registerProductFlavorSourceProvider(@NonNull String name, @NonNull ProductFlavor productFlavor, @NonNull SourceProvider sourceProvider) {
        if (this.extraArtifactMap.get(name) == null) {
            throw new IllegalArgumentException("Artifact with name $name is not yet registered. Use registerArtifactType()");
        }
        this.extraProductFlavorSourceProviders.put((Object)productFlavor.getName(), (Object)new DefaultSourceProviderContainer(name, sourceProvider));
    }

    public void registerMultiFlavorSourceProvider(@NonNull String name, @NonNull String flavorName, @NonNull SourceProvider sourceProvider) {
        if (this.extraArtifactMap.get(name) == null) {
            throw new IllegalArgumentException("Artifact with name $name is not yet registered. Use registerArtifactType()");
        }
        this.extraMultiFlavorSourceProviders.put((Object)flavorName, (Object)new DefaultSourceProviderContainer(name, sourceProvider));
    }

    public void registerJavaArtifact(@NonNull String name, @NonNull BaseVariant variant, @NonNull String assembleTaskName, @NonNull String javaCompileTaskName, @NonNull Iterable<String> ideSetupTaskNames, @NonNull Configuration configuration, @NonNull File classesFolder, @Nullable SourceProvider sourceProvider) {
        ArtifactMetaData artifactMetaData = this.extraArtifactMap.get(name);
        if (artifactMetaData == null) {
            throw new IllegalArgumentException("Artifact with name $name is not yet registered. Use registerArtifactType()");
        }
        if (artifactMetaData.getType() != 2) {
            throw new IllegalArgumentException("Artifact with name $name is not of type JAVA");
        }
        JavaArtifactImpl artifact = new JavaArtifactImpl(name, assembleTaskName, javaCompileTaskName, ideSetupTaskNames, classesFolder, new ConfigurationDependencies(configuration), sourceProvider, null);
        this.extraJavaArtifacts.put((Object)variant.getName(), (Object)artifact);
    }

    private static ModelQueryMode computeModelQueryMode(@NonNull Project project) {
        if (ExtraModelInfo.isPropertyTrue(project, "android.injected.build.model.only.advanced")) {
            return ModelQueryMode.IDE_ADVANCED;
        }
        if (ExtraModelInfo.isPropertyTrue(project, "android.injected.build.model.only")) {
            return ModelQueryMode.IDE;
        }
        return ModelQueryMode.STANDARD;
    }

    private static GradleMessageRewriter.ErrorFormatMode computeErrorFormatMode(@NonNull Project project) {
        if (ExtraModelInfo.isPropertyTrue(project, "android.injected.invoked.from.ide")) {
            return GradleMessageRewriter.ErrorFormatMode.MACHINE_PARSABLE;
        }
        return GradleMessageRewriter.ErrorFormatMode.HUMAN_READABLE;
    }

    private static boolean isPropertyTrue(@NonNull Project project, @NonNull String propertyName) {
        Object value;
        if (project.hasProperty(propertyName) && (value = project.getProperties().get(propertyName)) instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return false;
    }

    public static enum ModelQueryMode {
        STANDARD,
        IDE,
        IDE_ADVANCED;

    }
}

