/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.annotations.NonNull;
import com.android.build.gradle.internal.dsl.AbiSplitOptions;
import com.android.build.gradle.internal.dsl.DensitySplitOptions;
import com.android.build.gradle.internal.dsl.LanguageSplitOptions;
import com.android.resources.Density;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.internal.reflect.Instantiator;

public class Splits {
    private final DensitySplitOptions density;
    private final AbiSplitOptions abi;
    private final LanguageSplitOptions language;
    private static final Set<String> ABI_LIST = ImmutableSet.of((Object)"armeabi", (Object)"armeabi-v7a", (Object)"arm64-v8a", (Object)"x86", (Object)"x86_64", (Object)"mips", (Object[])new String[]{"mips64"});

    public Splits(@NonNull Instantiator instantiator) {
        this.density = (DensitySplitOptions)instantiator.newInstance(DensitySplitOptions.class, new Object[0]);
        this.abi = (AbiSplitOptions)instantiator.newInstance(AbiSplitOptions.class, new Object[0]);
        this.language = (LanguageSplitOptions)instantiator.newInstance(LanguageSplitOptions.class, new Object[0]);
    }

    public DensitySplitOptions getDensity() {
        return this.density;
    }

    public void density(Action<DensitySplitOptions> action) {
        action.execute((Object)this.density);
    }

    public AbiSplitOptions getAbi() {
        return this.abi;
    }

    public void abi(Action<AbiSplitOptions> action) {
        action.execute((Object)this.abi);
    }

    public LanguageSplitOptions getLanguage() {
        return this.language;
    }

    public void language(Action<LanguageSplitOptions> action) {
        action.execute((Object)this.language);
    }

    @NonNull
    public Set<String> getDensityFilters() {
        Density[] values = Density.values();
        HashSet fullList = Sets.newHashSetWithExpectedSize((int)(values.length - 1));
        for (Density value : values) {
            if (value == Density.NODPI || value == Density.ANYDPI || !value.isRecommended()) continue;
            fullList.add(value.getResourceValue());
        }
        return this.density.getApplicableFilters(fullList);
    }

    @NonNull
    public Set<String> getAbiFilters() {
        return this.abi.getApplicableFilters(ABI_LIST);
    }

    @NonNull
    public Set<String> getLanguageFilters() {
        return this.language.getApplicationFilters();
    }
}

