/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.annotations.NonNull;
import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantModel;
import com.android.build.gradle.internal.api.ApkVariantImpl;
import com.android.build.gradle.internal.api.ApkVariantOutputImpl;
import com.android.build.gradle.internal.api.ApplicationVariantImpl;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.model.FilterDataImpl;
import com.android.build.gradle.internal.variant.ApkVariantOutputData;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.internal.reflect.Instantiator;

public class ApplicationVariantFactory
implements VariantFactory<ApplicationVariantData> {
    Instantiator instantiator;
    @NonNull
    private final BaseExtension extension;
    @NonNull
    private final AndroidBuilder androidBuilder;

    public ApplicationVariantFactory(@NonNull Instantiator instantiator, @NonNull AndroidBuilder androidBuilder, @NonNull BaseExtension extension) {
        this.instantiator = instantiator;
        this.androidBuilder = androidBuilder;
        this.extension = extension;
    }

    @Override
    @NonNull
    public ApplicationVariantData createVariantData(@NonNull GradleVariantConfiguration variantConfiguration, @NonNull Set<String> densities, @NonNull Set<String> abis, @NonNull Set<String> compatibleScreens, @NonNull TaskManager taskManager) {
        ApplicationVariantData variant = new ApplicationVariantData(this.extension, variantConfiguration, taskManager);
        if (!densities.isEmpty()) {
            variant.setCompatibleScreens(compatibleScreens);
        }
        if (variant.getSplitHandlingPolicy() == BaseVariantData.SplitHandlingPolicy.PRE_21_POLICY) {
            for (String density : densities) {
                for (String abi : abis) {
                    ImmutableList.Builder builder = ImmutableList.builder();
                    if (density != null) {
                        builder.add((Object)FilterDataImpl.Builder.build(OutputFile.DENSITY, density));
                    }
                    if (abi != null) {
                        builder.add((Object)FilterDataImpl.Builder.build(OutputFile.ABI, abi));
                    }
                    variant.createOutput(OutputFile.OutputType.FULL_SPLIT, (Collection<FilterData>)builder.build());
                }
            }
        } else {
            variant.createOutput(OutputFile.OutputType.MAIN, Collections.<FilterData>emptyList());
        }
        return variant;
    }

    @Override
    @NonNull
    public BaseVariant createVariantApi(@NonNull BaseVariantData<? extends BaseVariantOutputData> variantData, @NonNull ReadOnlyObjectProvider readOnlyObjectProvider) {
        ApplicationVariantImpl variant = (ApplicationVariantImpl)this.instantiator.newInstance(ApplicationVariantImpl.class, new Object[]{variantData, this.androidBuilder, readOnlyObjectProvider});
        ApplicationVariantFactory.createApkOutputApiObjects(this.instantiator, variantData, variant);
        return variant;
    }

    public static void createApkOutputApiObjects(@NonNull Instantiator instantiator, @NonNull BaseVariantData<? extends BaseVariantOutputData> variantData, @NonNull ApkVariantImpl variant) {
        List<? extends BaseVariantOutputData> outputList = variantData.getOutputs();
        ArrayList apiOutputList = Lists.newArrayListWithCapacity((int)outputList.size());
        for (BaseVariantOutputData baseVariantOutputData : outputList) {
            ApkVariantOutputData apkOutput = (ApkVariantOutputData)baseVariantOutputData;
            ApkVariantOutputImpl output = (ApkVariantOutputImpl)instantiator.newInstance(ApkVariantOutputImpl.class, new Object[]{apkOutput});
            apiOutputList.add(output);
        }
        variant.addOutputs((List)apiOutputList);
    }

    @Override
    @NonNull
    public VariantType getVariantConfigurationType() {
        return VariantType.DEFAULT;
    }

    @Override
    public boolean isLibrary() {
        return false;
    }

    @Override
    public void validateModel(@NonNull VariantModel model) {
    }
}

