/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.OutputFile;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.TestedExtension;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ConfigurationProvider;
import com.android.build.gradle.internal.ProductFlavorCombo;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.StringHelper;
import com.android.build.gradle.internal.TaskContainerAdaptor;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantModel;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.api.TestVariantImpl;
import com.android.build.gradle.internal.api.TestedVariant;
import com.android.build.gradle.internal.api.VariantFilter;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.GroupableProductFlavor;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.dsl.Splits;
import com.android.build.gradle.internal.profile.SpanRecorders;
import com.android.build.gradle.internal.variant.ApplicationVariantFactory;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.model.SourceProvider;
import com.android.builder.profile.ExecutionType;
import com.android.builder.profile.Recorder;
import com.android.builder.profile.ThreadRecorder;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.internal.reflect.Instantiator;

public class VariantManager
implements VariantModel {
    protected static final String COM_ANDROID_SUPPORT_MULTIDEX = "com.android.support:multidex:1.0.1";
    @NonNull
    private final Project project;
    @NonNull
    private final AndroidBuilder androidBuilder;
    @NonNull
    private final BaseExtension extension;
    @NonNull
    private final VariantFactory variantFactory;
    @NonNull
    private final TaskManager taskManager;
    @NonNull
    private final Instantiator instantiator;
    @NonNull
    private ProductFlavorData<ProductFlavor> defaultConfigData;
    @NonNull
    private final Map<String, BuildTypeData> buildTypes = Maps.newHashMap();
    @NonNull
    private final Map<String, ProductFlavorData<GroupableProductFlavor>> productFlavors = Maps.newHashMap();
    @NonNull
    private final Map<String, SigningConfig> signingConfigs = Maps.newHashMap();
    @NonNull
    private final ReadOnlyObjectProvider readOnlyObjectProvider = new ReadOnlyObjectProvider();
    @NonNull
    private final VariantFilter variantFilter = new VariantFilter(this.readOnlyObjectProvider);
    @NonNull
    private final List<BaseVariantData<? extends BaseVariantOutputData>> variantDataList = Lists.newArrayList();
    @Nullable
    private SigningConfig signingOverride;

    public VariantManager(@NonNull Project project, @NonNull AndroidBuilder androidBuilder, @NonNull BaseExtension extension, @NonNull VariantFactory variantFactory, @NonNull TaskManager taskManager, @NonNull Instantiator instantiator) {
        this.extension = extension;
        this.androidBuilder = androidBuilder;
        this.project = project;
        this.variantFactory = variantFactory;
        this.taskManager = taskManager;
        this.instantiator = instantiator;
        DefaultAndroidSourceSet mainSourceSet = (DefaultAndroidSourceSet)extension.getSourceSets().getByName(extension.getDefaultConfig().getName());
        DefaultAndroidSourceSet androidTestSourceSet = null;
        DefaultAndroidSourceSet unitTestSourceSet = null;
        if (variantFactory.hasTestScope()) {
            androidTestSourceSet = (DefaultAndroidSourceSet)extension.getSourceSets().getByName(VariantType.ANDROID_TEST.getPrefix());
            unitTestSourceSet = (DefaultAndroidSourceSet)extension.getSourceSets().getByName(VariantType.UNIT_TEST.getPrefix());
        }
        this.defaultConfigData = new ProductFlavorData<ProductFlavor>(extension.getDefaultConfig(), mainSourceSet, androidTestSourceSet, unitTestSourceSet, project);
        this.signingOverride = this.createSigningOverride();
    }

    @Override
    @NonNull
    public ProductFlavorData<ProductFlavor> getDefaultConfig() {
        return this.defaultConfigData;
    }

    @Override
    @NonNull
    public Map<String, BuildTypeData> getBuildTypes() {
        return this.buildTypes;
    }

    @Override
    @NonNull
    public Map<String, ProductFlavorData<GroupableProductFlavor>> getProductFlavors() {
        return this.productFlavors;
    }

    @NonNull
    public Map<String, SigningConfig> getSigningConfigs() {
        return this.signingConfigs;
    }

    public void addSigningConfig(@NonNull SigningConfig signingConfig) {
        this.signingConfigs.put(signingConfig.getName(), signingConfig);
    }

    public void addBuildType(@NonNull BuildType buildType) {
        buildType.init(this.signingConfigs.get("debug"));
        String name = buildType.getName();
        VariantManager.checkName(name, "BuildType");
        if (this.productFlavors.containsKey(name)) {
            throw new RuntimeException("BuildType names cannot collide with ProductFlavor names");
        }
        DefaultAndroidSourceSet mainSourceSet = (DefaultAndroidSourceSet)this.extension.getSourceSetsContainer().maybeCreate(name);
        DefaultAndroidSourceSet unitTestSourceSet = null;
        if (this.variantFactory.hasTestScope()) {
            unitTestSourceSet = (DefaultAndroidSourceSet)this.extension.getSourceSetsContainer().maybeCreate(VariantType.UNIT_TEST.getPrefix() + StringHelper.capitalize(buildType.getName()));
        }
        BuildTypeData buildTypeData = new BuildTypeData(buildType, this.project, mainSourceSet, unitTestSourceSet);
        this.project.getTasks().getByName("assemble").dependsOn(new Object[]{buildTypeData.getAssembleTask()});
        this.buildTypes.put(name, buildTypeData);
    }

    public void addProductFlavor(@NonNull GroupableProductFlavor productFlavor) {
        String name = productFlavor.getName();
        VariantManager.checkName(name, "ProductFlavor");
        if (this.buildTypes.containsKey(name)) {
            throw new RuntimeException("ProductFlavor names cannot collide with BuildType names");
        }
        DefaultAndroidSourceSet mainSourceSet = (DefaultAndroidSourceSet)this.extension.getSourceSetsContainer().maybeCreate(productFlavor.getName());
        DefaultAndroidSourceSet androidTestSourceSet = null;
        DefaultAndroidSourceSet unitTestSourceSet = null;
        if (this.variantFactory.hasTestScope()) {
            androidTestSourceSet = (DefaultAndroidSourceSet)this.extension.getSourceSetsContainer().maybeCreate(VariantType.ANDROID_TEST.getPrefix() + StringHelper.capitalize(productFlavor.getName()));
            unitTestSourceSet = (DefaultAndroidSourceSet)this.extension.getSourceSetsContainer().maybeCreate(VariantType.UNIT_TEST.getPrefix() + StringHelper.capitalize(productFlavor.getName()));
        }
        ProductFlavorData<GroupableProductFlavor> productFlavorData = new ProductFlavorData<GroupableProductFlavor>(productFlavor, mainSourceSet, androidTestSourceSet, unitTestSourceSet, this.project);
        this.productFlavors.put(productFlavor.getName(), productFlavorData);
    }

    @NonNull
    public List<BaseVariantData<? extends BaseVariantOutputData>> getVariantDataList() {
        return this.variantDataList;
    }

    public void createAndroidTasks() {
        this.variantFactory.validateModel(this);
        this.variantFactory.preVariantWork(this.project);
        this.taskManager.createAssembleAndroidTestTask();
        if (this.variantDataList.isEmpty()) {
            this.populateVariantDataList();
        }
        final TaskContainerAdaptor tasks = new TaskContainerAdaptor(this.project.getTasks());
        ThreadRecorder.get().record(ExecutionType.VARIANT_MANAGER_CREATE_TESTS_TASKS, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                VariantManager.this.taskManager.createTopLevelTestTasks(tasks, !VariantManager.this.productFlavors.isEmpty());
                return null;
            }
        }, new Recorder.Property[0]);
        for (final BaseVariantData<? extends BaseVariantOutputData> variantData : this.variantDataList) {
            SpanRecorders.record(this.project, ExecutionType.VARIANT_MANAGER_CREATE_TASKS_FOR_VARIANT, new Recorder.Block<Void>(){

                public Void call() throws Exception {
                    VariantManager.this.createTasksForVariantData(tasks, variantData);
                    return null;
                }
            }, new Recorder.Property("variant", variantData.getName()));
        }
        ThreadRecorder.get().record(ExecutionType.VARIANT_MANAGER_CREATE_LINT_TASKS, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                VariantManager.this.taskManager.createLintTasks(VariantManager.this.variantDataList);
                return null;
            }
        }, new Recorder.Property[0]);
        this.createApiObjects();
        this.taskManager.createReportTasks(this.variantDataList);
    }

    private void createAssembleTaskForVariantData(TaskFactory tasks, final BaseVariantData<?> variantData) {
        if (variantData.getType().isForTesting()) {
            variantData.assembleVariantTask = this.taskManager.createAssembleTask(variantData);
        } else {
            BuildTypeData buildTypeData = this.buildTypes.get(((BuildType)variantData.getVariantConfiguration().getBuildType()).getName());
            if (this.productFlavors.isEmpty()) {
                variantData.assembleVariantTask = buildTypeData.getAssembleTask();
            } else {
                variantData.assembleVariantTask = this.taskManager.createAssembleTask(variantData);
                buildTypeData.getAssembleTask().dependsOn(new Object[]{variantData.assembleVariantTask});
                GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
                for (GroupableProductFlavor flavor : variantConfig.getProductFlavors()) {
                    this.productFlavors.get(flavor.getName()).getAssembleTask().dependsOn(new Object[]{variantData.assembleVariantTask});
                }
                if (variantConfig.getProductFlavors().size() > 1) {
                    final String name = StringHelper.capitalize(variantConfig.getFlavorName());
                    final String variantAssembleTaskName = "assemble" + name;
                    if (!tasks.containsKey(variantAssembleTaskName)) {
                        tasks.create(variantAssembleTaskName, (Action<? super Task>)new Action<Task>(){

                            public void execute(Task task) {
                                task.setDescription("Assembles all builds for flavor combination: " + name);
                                task.setGroup("Build");
                                task.dependsOn(new Object[]{variantData.assembleVariantTask});
                            }
                        });
                    }
                    tasks.named("assemble", (Action<? super Task>)new Action<Task>(){

                        public void execute(Task task) {
                            task.dependsOn(new Object[]{variantAssembleTaskName});
                        }
                    });
                }
            }
        }
    }

    public void createTasksForVariantData(TaskFactory tasks, BaseVariantData<? extends BaseVariantOutputData> variantData) {
        VariantType variantType = variantData.getType();
        this.createAssembleTaskForVariantData(tasks, variantData);
        if (variantType.isForTesting()) {
            final GradleVariantConfiguration testVariantConfig = variantData.getVariantConfiguration();
            final BaseVariantData testedVariantData = (BaseVariantData)((Object)((TestVariantData)variantData).getTestedVariantData());
            ArrayList testVariantProviders = Lists.newArrayListWithExpectedSize((int)(2 + testVariantConfig.getProductFlavors().size()));
            for (GroupableProductFlavor productFlavor : testVariantConfig.getProductFlavors()) {
                ProductFlavorData<GroupableProductFlavor> data = this.productFlavors.get(productFlavor.getName());
                testVariantProviders.add(data.getTestConfigurationProvider(variantType));
            }
            testVariantProviders.add(this.defaultConfigData.getTestConfigurationProvider(variantType));
            assert (testVariantConfig.getTestedConfig() != null);
            if (testVariantConfig.getTestedConfig().getType() == VariantType.LIBRARY) {
                testVariantProviders.add(testedVariantData.getVariantDependency());
            }
            final VariantDependencies variantDep = VariantDependencies.compute(this.project, testVariantConfig.getFullName(), false, variantType, testVariantProviders.toArray(new ConfigurationProvider[testVariantProviders.size()]));
            variantData.setVariantDependency(variantDep);
            SpanRecorders.record(this.project, ExecutionType.RESOLVE_DEPENDENCIES, new Recorder.Block<Void>(){

                public Void call() {
                    VariantManager.this.taskManager.resolveDependencies(variantDep, testVariantConfig.getTestedConfig().getType() == VariantType.LIBRARY ? null : testedVariantData.getVariantDependency());
                    return null;
                }
            }, new Recorder.Property("variant", testVariantConfig.getFullName()));
            testVariantConfig.setDependencies(variantDep);
            switch (variantType) {
                case ANDROID_TEST: {
                    this.taskManager.createAndroidTestVariantTasks(tasks, (TestVariantData)variantData);
                    break;
                }
                case UNIT_TEST: {
                    this.taskManager.createUnitTestVariantTasks(tasks, (TestVariantData)variantData);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown test type " + variantType);
                }
            }
        } else {
            this.taskManager.createTasksForVariantData(tasks, variantData);
        }
    }

    public void populateVariantDataList() {
        this.taskManager.createLintCompileTask();
        if (this.productFlavors.isEmpty()) {
            this.createVariantDataForProductFlavors(Collections.<com.android.build.gradle.api.GroupableProductFlavor>emptyList());
        } else {
            List<String> flavorDimensionList = this.extension.getFlavorDimensionList();
            Iterable flavorDsl = Iterables.transform(this.productFlavors.values(), (Function)new Function<ProductFlavorData<GroupableProductFlavor>, GroupableProductFlavor>(){

                public GroupableProductFlavor apply(ProductFlavorData<GroupableProductFlavor> data) {
                    return data.getProductFlavor();
                }
            });
            List<ProductFlavorCombo> flavorComboList = ProductFlavorCombo.createCombinations(flavorDimensionList, flavorDsl);
            for (ProductFlavorCombo flavorCombo : flavorComboList) {
                this.createVariantDataForProductFlavors(flavorCombo.getFlavorList());
            }
        }
    }

    public BaseVariantData<? extends BaseVariantOutputData> createVariantData(@NonNull com.android.builder.model.BuildType buildType, @NonNull List<? extends com.android.build.gradle.api.GroupableProductFlavor> productFlavorList) {
        Splits splits = this.extension.getSplits();
        Set<String> densities = splits.getDensityFilters();
        Set<String> abis = splits.getAbiFilters();
        densities = densities.isEmpty() ? Collections.singleton(OutputFile.NO_FILTER) : densities;
        abis = abis.isEmpty() ? Collections.singleton(OutputFile.NO_FILTER) : abis;
        ProductFlavor defaultConfig = this.defaultConfigData.getProductFlavor();
        DefaultAndroidSourceSet defaultConfigSourceSet = this.defaultConfigData.getSourceSet();
        BuildTypeData buildTypeData = this.buildTypes.get(buildType.getName());
        Set<String> compatibleScreens = this.extension.getSplits().getDensity().getCompatibleScreens();
        GradleVariantConfiguration variantConfig = new GradleVariantConfiguration(defaultConfig, defaultConfigSourceSet, buildTypeData.getBuildType(), buildTypeData.getSourceSet(), this.variantFactory.getVariantConfigurationType(), (com.android.builder.model.SigningConfig)this.signingOverride);
        NamedDomainObjectContainer<AndroidSourceSet> sourceSetsContainer = this.extension.getSourceSetsContainer();
        for (com.android.build.gradle.api.GroupableProductFlavor groupableProductFlavor : productFlavorList) {
            ProductFlavorData<GroupableProductFlavor> productFlavorData = this.productFlavors.get(groupableProductFlavor.getName());
            String dimensionName = groupableProductFlavor.getDimension();
            if (dimensionName == null) {
                dimensionName = "";
            }
            variantConfig.addProductFlavor(productFlavorData.getProductFlavor(), (SourceProvider)productFlavorData.getSourceSet(), dimensionName);
        }
        ArrayList variantProviders = Lists.newArrayListWithExpectedSize((int)(productFlavorList.size() + 4));
        if (!productFlavorList.isEmpty()) {
            DefaultAndroidSourceSet defaultAndroidSourceSet = (DefaultAndroidSourceSet)sourceSetsContainer.maybeCreate(variantConfig.getFullName());
            variantConfig.setVariantSourceProvider(defaultAndroidSourceSet);
            variantProviders.add(new ProductFlavorData.ConfigurationProviderImpl(this.project, defaultAndroidSourceSet));
        }
        variantProviders.add(buildTypeData);
        if (productFlavorList.size() > 1) {
            DefaultAndroidSourceSet defaultAndroidSourceSet = (DefaultAndroidSourceSet)sourceSetsContainer.maybeCreate(variantConfig.getFlavorName());
            variantConfig.setMultiFlavorSourceProvider(defaultAndroidSourceSet);
            variantProviders.add(new ProductFlavorData.ConfigurationProviderImpl(this.project, defaultAndroidSourceSet));
        }
        for (com.android.build.gradle.api.GroupableProductFlavor groupableProductFlavor : productFlavorList) {
            variantProviders.add(this.productFlavors.get(groupableProductFlavor.getName()).getMainProvider());
        }
        variantProviders.add(this.defaultConfigData.getMainProvider());
        BaseVariantData baseVariantData = this.variantFactory.createVariantData(variantConfig, densities, abis, compatibleScreens, this.taskManager);
        final VariantDependencies variantDependencies = VariantDependencies.compute(this.project, variantConfig.getFullName(), this.isVariantPublished(), baseVariantData.getType(), variantProviders.toArray(new ConfigurationProvider[variantProviders.size()]));
        baseVariantData.setVariantDependency(variantDependencies);
        if (variantConfig.isMultiDexEnabled() && variantConfig.isLegacyMultiDexMode()) {
            this.project.getDependencies().add(variantDependencies.getCompileConfiguration().getName(), (Object)COM_ANDROID_SUPPORT_MULTIDEX);
            this.project.getDependencies().add(variantDependencies.getPackageConfiguration().getName(), (Object)COM_ANDROID_SUPPORT_MULTIDEX);
        }
        SpanRecorders.record(this.project, ExecutionType.RESOLVE_DEPENDENCIES, new Recorder.Block<Void>(){

            public Void call() {
                VariantManager.this.taskManager.resolveDependencies(variantDependencies, null);
                return null;
            }
        }, new Recorder.Property("variant", variantConfig.getFullName()));
        variantConfig.setDependencies(variantDependencies);
        return baseVariantData;
    }

    public TestVariantData createTestVariantData(BaseVariantData testedVariantData, VariantType type) {
        ProductFlavor defaultConfig = this.defaultConfigData.getProductFlavor();
        BuildType buildType = (BuildType)testedVariantData.getVariantConfiguration().getBuildType();
        BuildTypeData buildTypeData = this.buildTypes.get(buildType.getName());
        GradleVariantConfiguration testedConfig = testedVariantData.getVariantConfiguration();
        List productFlavorList = testedConfig.getProductFlavors();
        GradleVariantConfiguration testVariantConfig = new GradleVariantConfiguration(testedVariantData.getVariantConfiguration(), defaultConfig, this.defaultConfigData.getTestSourceSet(type), buildType, buildTypeData.getTestSourceSet(type), type, (com.android.builder.model.SigningConfig)this.signingOverride);
        for (com.android.build.gradle.api.GroupableProductFlavor productFlavor : productFlavorList) {
            ProductFlavorData<GroupableProductFlavor> data = this.productFlavors.get(productFlavor.getName());
            String dimensionName = productFlavor.getDimension();
            if (dimensionName == null) {
                dimensionName = "";
            }
            testVariantConfig.addProductFlavor(data.getProductFlavor(), (SourceProvider)data.getTestSourceSet(type), dimensionName);
        }
        TestVariantData testVariantData = new TestVariantData(this.extension, this.taskManager, testVariantConfig, (TestedVariantData)((Object)testedVariantData));
        ((TestedVariantData)((Object)testedVariantData)).setTestVariantData(testVariantData, type);
        return testVariantData;
    }

    private void createVariantDataForProductFlavors(@NonNull List<com.android.build.gradle.api.GroupableProductFlavor> productFlavorList) {
        TestedExtension testedExtension;
        BuildTypeData testBuildTypeData = null;
        if (this.extension instanceof TestedExtension && (testBuildTypeData = this.buildTypes.get((testedExtension = (TestedExtension)this.extension).getTestBuildType())) == null) {
            throw new RuntimeException(String.format("Test Build Type '%1$s' does not exist.", testedExtension.getTestBuildType()));
        }
        BaseVariantData<? extends BaseVariantOutputData> variantForAndroidTest = null;
        ProductFlavor defaultConfig = this.defaultConfigData.getProductFlavor();
        Closure<Void> variantFilterClosure = this.extension.getVariantFilter();
        for (BuildTypeData buildTypeData : this.buildTypes.values()) {
            boolean ignore = false;
            if (variantFilterClosure != null) {
                this.variantFilter.reset((com.android.builder.model.ProductFlavor)defaultConfig, (com.android.builder.model.BuildType)buildTypeData.getBuildType(), productFlavorList);
                variantFilterClosure.call((Object)this.variantFilter);
                ignore = this.variantFilter.isIgnore();
            }
            if (ignore) continue;
            BaseVariantData<? extends BaseVariantOutputData> variantData = this.createVariantData((com.android.builder.model.BuildType)buildTypeData.getBuildType(), productFlavorList);
            this.variantDataList.add(variantData);
            if (!this.variantFactory.hasTestScope()) continue;
            TestVariantData unitTestVariantData = this.createTestVariantData(variantData, VariantType.UNIT_TEST);
            this.variantDataList.add(unitTestVariantData);
            if (buildTypeData != testBuildTypeData) continue;
            GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
            if (variantConfig.isMinifyEnabled() && variantConfig.getUseJack()) {
                throw new RuntimeException("Cannot test obfuscated variants when compiling with jack.");
            }
            variantForAndroidTest = variantData;
        }
        if (variantForAndroidTest != null) {
            TestVariantData androidTestVariantData = this.createTestVariantData(variantForAndroidTest, VariantType.ANDROID_TEST);
            this.variantDataList.add(androidTestVariantData);
        }
    }

    public void createApiObjects() {
        for (BaseVariantData<? extends BaseVariantOutputData> variantData : this.variantDataList) {
            TestVariantData androidTestVariantData;
            if (variantData.getType().isForTesting()) continue;
            BaseVariant variantApi = this.variantFactory.createVariantApi(variantData, this.readOnlyObjectProvider);
            this.extension.addVariant(variantApi);
            if (!this.variantFactory.hasTestScope() || (androidTestVariantData = ((TestedVariantData)((Object)variantData)).getTestVariantData(VariantType.ANDROID_TEST)) == null) continue;
            TestVariantImpl androidTestVariant = (TestVariantImpl)this.instantiator.newInstance(TestVariantImpl.class, new Object[]{androidTestVariantData, variantApi, this.androidBuilder, this.readOnlyObjectProvider});
            ApplicationVariantFactory.createApkOutputApiObjects(this.instantiator, androidTestVariantData, androidTestVariant);
            ((TestedExtension)this.extension).addTestVariant(androidTestVariant);
            ((TestedVariant)((Object)variantApi)).setTestVariant(androidTestVariant);
        }
    }

    private boolean isVariantPublished() {
        return this.extension.getPublishNonDefault();
    }

    private static void checkName(@NonNull String name, @NonNull String displayName) {
        VariantManager.checkPrefix(name, displayName, VariantType.ANDROID_TEST.getPrefix());
        VariantManager.checkPrefix(name, displayName, VariantType.UNIT_TEST.getPrefix());
        if ("lint".equals(name)) {
            throw new RuntimeException(String.format("%1$s names cannot be %2$s", displayName, "lint"));
        }
    }

    private static void checkPrefix(String name, String displayName, String prefix) {
        if (name.startsWith(prefix)) {
            throw new RuntimeException(String.format("%1$s names cannot start with '%2$s'", displayName, prefix));
        }
    }

    private SigningConfig createSigningOverride() {
        if (this.project.hasProperty("android.injected.signing.store.file") && this.project.hasProperty("android.injected.signing.store.password") && this.project.hasProperty("android.injected.signing.key.alias") && this.project.hasProperty("android.injected.signing.key.password")) {
            SigningConfig signingConfigDsl = new SigningConfig("externalOverride");
            Map props = this.project.getProperties();
            signingConfigDsl.setStoreFile(new File((String)props.get("android.injected.signing.store.file")));
            signingConfigDsl.setStorePassword((String)props.get("android.injected.signing.store.password"));
            signingConfigDsl.setKeyAlias((String)props.get("android.injected.signing.key.alias"));
            signingConfigDsl.setKeyPassword((String)props.get("android.injected.signing.key.password"));
            if (this.project.hasProperty("android.injected.signing.store.type")) {
                signingConfigDsl.setStoreType((String)props.get("android.injected.signing.store.type"));
            }
            return signingConfigDsl;
        }
        return null;
    }
}

