/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.annotations.NonNull;
import com.android.build.OutputFile;
import com.android.build.gradle.internal.dsl.SplitOptions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;

public class AbiSplitOptions
extends SplitOptions {
    private static final String[] ABI_LIST = new String[]{"armeabi", "armeabi-v7a", "arm64-v8a", "x86", "x86_64", "mips", "mips64"};
    private boolean universalApk = false;

    @Override
    protected Set<String> getDefaultValues() {
        return Sets.newHashSet((Object[])ABI_LIST);
    }

    @Override
    protected ImmutableSet<String> getAllowedValues() {
        return ImmutableSet.copyOf((Object[])ABI_LIST);
    }

    public boolean isUniversalApk() {
        return this.universalApk;
    }

    public void setUniversalApk(boolean universalApk) {
        this.universalApk = universalApk;
    }

    @Override
    @NonNull
    public Set<String> getApplicableFilters() {
        Set<String> list = super.getApplicableFilters();
        if (this.isEnable() && this.universalApk) {
            list.add(OutputFile.NO_FILTER);
        }
        return list;
    }

    @NonNull
    public static ImmutableSet<String> getAbiFilters(@NonNull Set<String> allFilters) {
        ImmutableSet.Builder filters = ImmutableSet.builder();
        for (String abi : allFilters) {
            if (abi == OutputFile.NO_FILTER) continue;
            filters.add((Object)abi);
        }
        return filters.build();
    }
}

