/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.internal.core.NdkConfig;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;

public class NdkOptions
implements NdkConfig,
Serializable {
    private static final long serialVersionUID = 1L;
    private String moduleName;
    private String cFlags;
    private List<String> ldLibs;
    private Set<String> abiFilters;
    private String stl;

    public NdkOptions() {
    }

    public NdkOptions(@NonNull NdkOptions ndkConfig) {
        this.moduleName = ndkConfig.moduleName;
        this.cFlags = ndkConfig.cFlags;
        this.setLdLibs(ndkConfig.ldLibs);
        this.setAbiFilters(ndkConfig.abiFilters);
    }

    @Override
    @Input
    @Optional
    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    @Override
    @Input
    @Optional
    public String getcFlags() {
        return this.cFlags;
    }

    public void setcFlags(String cFlags) {
        this.cFlags = cFlags;
    }

    @Input
    @Optional
    public List<String> getLdLibs() {
        return this.ldLibs;
    }

    @NonNull
    public NdkOptions ldLibs(String lib) {
        if (this.ldLibs == null) {
            this.ldLibs = Lists.newArrayList();
        }
        this.ldLibs.add(lib);
        return this;
    }

    @NonNull
    public NdkOptions ldLibs(String ... libs) {
        if (this.ldLibs == null) {
            this.ldLibs = Lists.newArrayListWithCapacity((int)libs.length);
        }
        Collections.addAll(this.ldLibs, libs);
        return this;
    }

    @NonNull
    public NdkOptions setLdLibs(Collection<String> libs) {
        if (libs != null) {
            if (this.ldLibs == null) {
                this.ldLibs = Lists.newArrayListWithCapacity((int)libs.size());
            } else {
                this.ldLibs.clear();
            }
            for (String filter : libs) {
                this.ldLibs.add(filter);
            }
        } else {
            this.ldLibs = null;
        }
        return this;
    }

    @Override
    @Input
    @Optional
    public Set<String> getAbiFilters() {
        return this.abiFilters;
    }

    @NonNull
    public NdkOptions abiFilter(String filter) {
        if (this.abiFilters == null) {
            this.abiFilters = Sets.newHashSetWithExpectedSize((int)2);
        }
        this.abiFilters.add(filter);
        return this;
    }

    @NonNull
    public NdkOptions abiFilters(String ... filters) {
        if (this.abiFilters == null) {
            this.abiFilters = Sets.newHashSetWithExpectedSize((int)2);
        }
        Collections.addAll(this.abiFilters, filters);
        return this;
    }

    @NonNull
    public NdkOptions setAbiFilters(Collection<String> filters) {
        if (filters != null) {
            if (this.abiFilters == null) {
                this.abiFilters = Sets.newHashSetWithExpectedSize((int)filters.size());
            } else {
                this.abiFilters.clear();
            }
            for (String filter : filters) {
                this.abiFilters.add(filter);
            }
        } else {
            this.abiFilters = null;
        }
        return this;
    }

    @Override
    @Nullable
    public String getStl() {
        return this.stl;
    }

    public void setStl(String stl) {
        this.stl = stl;
    }
}

