/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.annotations.NonNull;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class SplitOptions {
    @NonNull
    private final Set<String> values = this.getDefaultValues();
    @NonNull
    private final ImmutableSet<String> allowedValues = this.getAllowedValues();
    private boolean enable = false;

    protected SplitOptions() {
    }

    protected abstract Set<String> getDefaultValues();

    protected abstract ImmutableSet<String> getAllowedValues();

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void exclude(String ... excludes) {
        this.values.removeAll(Arrays.asList(excludes));
    }

    public void include(String ... includes) {
        this.values.addAll(Arrays.asList(includes));
    }

    public void reset() {
        this.values.clear();
    }

    @NonNull
    public Set<String> getApplicableFilters() {
        if (!this.enable) {
            return Collections.singleton(null);
        }
        HashSet results = Sets.newHashSetWithExpectedSize((int)this.values.size());
        for (String value : this.values) {
            if (!this.allowedValues.contains((Object)value)) continue;
            results.add(value);
        }
        return results;
    }
}

