/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.ClassField;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

abstract class BaseConfigImpl
implements BaseConfig,
Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final Map<String, Object> mManifestPlaceholders;
    @NonNull
    private final Map<String, ClassField> mBuildConfigFields;
    @NonNull
    private final Map<String, ClassField> mResValues;
    @Nullable
    private Boolean mMultiDexEnabled;
    @Nullable
    private File mMultiDexKeepFile;
    @Nullable
    private File mMultiDexKeepProguard;

    protected BaseConfigImpl(@NonNull BaseConfig baseConfig) {
        this.mManifestPlaceholders = ImmutableMap.copyOf((Map)baseConfig.getManifestPlaceholders());
        this.mBuildConfigFields = ImmutableMap.copyOf((Map)baseConfig.getBuildConfigFields());
        this.mResValues = ImmutableMap.copyOf((Map)baseConfig.getResValues());
        this.mMultiDexEnabled = baseConfig.getMultiDexEnabled();
        this.mMultiDexKeepFile = baseConfig.getMultiDexKeepFile();
        this.mMultiDexKeepProguard = baseConfig.getMultiDexKeepProguard();
    }

    @NonNull
    public Map<String, ClassField> getBuildConfigFields() {
        return this.mBuildConfigFields;
    }

    @NonNull
    public Map<String, ClassField> getResValues() {
        return this.mResValues;
    }

    @NonNull
    public List<File> getProguardFiles() {
        return Collections.emptyList();
    }

    @NonNull
    public List<File> getConsumerProguardFiles() {
        return Collections.emptyList();
    }

    @NonNull
    public Collection<File> getTestProguardFiles() {
        return Collections.emptyList();
    }

    @NonNull
    public Map<String, Object> getManifestPlaceholders() {
        return this.mManifestPlaceholders;
    }

    @Nullable
    public Boolean getMultiDexEnabled() {
        return this.mMultiDexEnabled;
    }

    @Nullable
    public File getMultiDexKeepFile() {
        return this.mMultiDexKeepFile;
    }

    @Nullable
    public File getMultiDexKeepProguard() {
        return this.mMultiDexKeepProguard;
    }

    public String toString() {
        return "BaseConfigImpl{mManifestPlaceholders=" + this.mManifestPlaceholders + ", mBuildConfigFields=" + this.mBuildConfigFields + ", mResValues=" + this.mResValues + ", mMultiDexEnabled=" + this.mMultiDexEnabled + '}';
    }
}

