/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.internal.ConfigurationDependencies;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.model.ArtifactMetaDataImpl;
import com.android.build.gradle.internal.model.JavaArtifactImpl;
import com.android.build.gradle.internal.model.SyncIssueImpl;
import com.android.build.gradle.internal.model.SyncIssueKey;
import com.android.build.gradle.internal.variant.DefaultSourceProviderContainer;
import com.android.builder.core.EvaluationErrorReporter;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.ArtifactMetaData;
import com.android.builder.model.JavaArtifact;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.android.builder.model.SyncIssue;
import com.android.ide.common.blame.output.GradleMessageRewriter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;

public class ExtraModelInfo
extends EvaluationErrorReporter {
    @NonNull
    private final Project project;
    private final boolean isLibrary;
    private final GradleMessageRewriter.ErrorFormatMode errorFormatMode;
    private final Map<SyncIssueKey, SyncIssue> syncIssues = Maps.newHashMap();
    private final Map<String, ArtifactMetaData> extraArtifactMap = Maps.newHashMap();
    private final ListMultimap<String, AndroidArtifact> extraAndroidArtifacts = ArrayListMultimap.create();
    private final ListMultimap<String, JavaArtifact> extraJavaArtifacts = ArrayListMultimap.create();
    private final ListMultimap<String, SourceProviderContainer> extraBuildTypeSourceProviders = ArrayListMultimap.create();
    private final ListMultimap<String, SourceProviderContainer> extraProductFlavorSourceProviders = ArrayListMultimap.create();
    private final ListMultimap<String, SourceProviderContainer> extraMultiFlavorSourceProviders = ArrayListMultimap.create();

    public ExtraModelInfo(@NonNull Project project, boolean isLibrary) {
        super(ExtraModelInfo.computeModelQueryMode(project));
        this.project = project;
        this.isLibrary = isLibrary;
        this.errorFormatMode = ExtraModelInfo.computeErrorFormatMode(project);
    }

    public boolean isLibrary() {
        return this.isLibrary;
    }

    public Map<SyncIssueKey, SyncIssue> getSyncIssues() {
        return this.syncIssues;
    }

    public GradleMessageRewriter.ErrorFormatMode getErrorFormatMode() {
        return this.errorFormatMode;
    }

    @NonNull
    public SyncIssue handleSyncError(@NonNull String data, int type, @NonNull String msg) {
        SyncIssueImpl issue;
        switch (this.getMode()) {
            case STANDARD: {
                if (!ExtraModelInfo.isDependencyIssue(type)) {
                    throw new GradleException(msg);
                }
                this.project.getLogger().warn("WARNING: " + msg);
                issue = new SyncIssueImpl(type, 2, data, msg);
                break;
            }
            case IDE_LEGACY: {
                if (type != 2) {
                    throw new GradleException(msg);
                }
            }
            case IDE: {
                issue = new SyncIssueImpl(type, 2, data, msg);
                this.syncIssues.put(SyncIssueKey.from(issue), issue);
                break;
            }
            default: {
                throw new RuntimeException("Unknown SyncIssue type");
            }
        }
        return issue;
    }

    private static boolean isDependencyIssue(int type) {
        switch (type) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public Collection<ArtifactMetaData> getExtraArtifacts() {
        return this.extraArtifactMap.values();
    }

    public Collection<AndroidArtifact> getExtraAndroidArtifacts(@NonNull String variantName) {
        return this.extraAndroidArtifacts.get((Object)variantName);
    }

    public Collection<JavaArtifact> getExtraJavaArtifacts(@NonNull String variantName) {
        return this.extraJavaArtifacts.get((Object)variantName);
    }

    public Collection<SourceProviderContainer> getExtraFlavorSourceProviders(@NonNull String flavorName) {
        return this.extraProductFlavorSourceProviders.get((Object)flavorName);
    }

    public Collection<SourceProviderContainer> getExtraBuildTypeSourceProviders(@NonNull String buildTypeName) {
        return this.extraBuildTypeSourceProviders.get((Object)buildTypeName);
    }

    public void registerArtifactType(@NonNull String name, boolean isTest, int artifactType) {
        if (this.extraArtifactMap.get(name) != null) {
            throw new IllegalArgumentException(String.format("Artifact with name %1$s already registered.", name));
        }
        this.extraArtifactMap.put(name, new ArtifactMetaDataImpl(name, isTest, artifactType));
    }

    public void registerBuildTypeSourceProvider(@NonNull String name, @NonNull CoreBuildType buildType, @NonNull SourceProvider sourceProvider) {
        if (this.extraArtifactMap.get(name) == null) {
            throw new IllegalArgumentException(String.format("Artifact with name %1$s is not yet registered. Use registerArtifactType()", name));
        }
        this.extraBuildTypeSourceProviders.put((Object)buildType.getName(), (Object)new DefaultSourceProviderContainer(name, sourceProvider));
    }

    public void registerProductFlavorSourceProvider(@NonNull String name, @NonNull CoreProductFlavor productFlavor, @NonNull SourceProvider sourceProvider) {
        if (this.extraArtifactMap.get(name) == null) {
            throw new IllegalArgumentException(String.format("Artifact with name %1$s is not yet registered. Use registerArtifactType()", name));
        }
        this.extraProductFlavorSourceProviders.put((Object)productFlavor.getName(), (Object)new DefaultSourceProviderContainer(name, sourceProvider));
    }

    public void registerMultiFlavorSourceProvider(@NonNull String name, @NonNull String flavorName, @NonNull SourceProvider sourceProvider) {
        if (this.extraArtifactMap.get(name) == null) {
            throw new IllegalArgumentException(String.format("Artifact with name %1$s is not yet registered. Use registerArtifactType()", name));
        }
        this.extraMultiFlavorSourceProviders.put((Object)flavorName, (Object)new DefaultSourceProviderContainer(name, sourceProvider));
    }

    public void registerJavaArtifact(@NonNull String name, @NonNull BaseVariant variant, @NonNull String assembleTaskName, @NonNull String javaCompileTaskName, @NonNull Collection<File> generatedSourceFolders, @NonNull Iterable<String> ideSetupTaskNames, @NonNull Configuration configuration, @NonNull File classesFolder, @NonNull File javaResourcesFolder, @Nullable SourceProvider sourceProvider) {
        ArtifactMetaData artifactMetaData = this.extraArtifactMap.get(name);
        if (artifactMetaData == null) {
            throw new IllegalArgumentException(String.format("Artifact with name %1$s is not yet registered. Use registerArtifactType()", name));
        }
        if (artifactMetaData.getType() != 2) {
            throw new IllegalArgumentException(String.format("Artifact with name %1$s is not of type JAVA", name));
        }
        JavaArtifactImpl artifact = new JavaArtifactImpl(name, assembleTaskName, javaCompileTaskName, ideSetupTaskNames, generatedSourceFolders, classesFolder, javaResourcesFolder, null, new ConfigurationDependencies(configuration), sourceProvider, null);
        this.extraJavaArtifacts.put((Object)variant.getName(), (Object)artifact);
    }

    private static EvaluationErrorReporter.EvaluationMode computeModelQueryMode(@NonNull Project project) {
        if (ExtraModelInfo.isPropertyTrue(project, "android.injected.build.model.only.advanced")) {
            return EvaluationErrorReporter.EvaluationMode.IDE;
        }
        if (ExtraModelInfo.isPropertyTrue(project, "android.injected.build.model.only")) {
            return EvaluationErrorReporter.EvaluationMode.IDE_LEGACY;
        }
        return EvaluationErrorReporter.EvaluationMode.STANDARD;
    }

    private static GradleMessageRewriter.ErrorFormatMode computeErrorFormatMode(@NonNull Project project) {
        if (ExtraModelInfo.isPropertyTrue(project, "android.injected.invoked.from.ide")) {
            return GradleMessageRewriter.ErrorFormatMode.MACHINE_PARSABLE;
        }
        return GradleMessageRewriter.ErrorFormatMode.HUMAN_READABLE;
    }

    private static boolean isPropertyTrue(@NonNull Project project, @NonNull String propertyName) {
        Object value;
        if (project.hasProperty(propertyName) && (value = project.getProperties().get(propertyName)) instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return false;
    }
}

