/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.dependency.JarDependency;
import com.android.builder.model.MavenCoordinates;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;

public class JarInfo {
    @NonNull
    private final File jarFile;
    @Nullable
    private final String gradlePath;
    @NonNull
    final List<JarInfo> dependencies = Lists.newArrayList();
    @NonNull
    private final MavenCoordinates resolvedCoordinates;
    private boolean compiled = false;
    private boolean packaged = false;

    public JarInfo(@NonNull File jarFile, @NonNull MavenCoordinates resolvedCoordinates, @Nullable String gradlePath, @NonNull List<JarInfo> dependencies) {
        Preconditions.checkNotNull((Object)jarFile);
        Preconditions.checkNotNull((Object)resolvedCoordinates);
        Preconditions.checkNotNull(dependencies);
        this.jarFile = jarFile;
        this.resolvedCoordinates = resolvedCoordinates;
        this.gradlePath = gradlePath;
        this.dependencies.addAll(dependencies);
    }

    public void setCompiled(boolean compiled) {
        this.compiled = compiled;
    }

    public void setPackaged(boolean packaged) {
        this.packaged = packaged;
    }

    public boolean isPackaged() {
        return this.packaged;
    }

    @NonNull
    public File getJarFile() {
        return this.jarFile;
    }

    @NonNull
    public MavenCoordinates getResolvedCoordinates() {
        return this.resolvedCoordinates;
    }

    @Nullable
    public String getGradlePath() {
        return this.gradlePath;
    }

    @NonNull
    public List<JarInfo> getDependencies() {
        return this.dependencies;
    }

    @NonNull
    public JarDependency createJarDependency() {
        return new JarDependency(this.jarFile, this.compiled, this.packaged, true, this.resolvedCoordinates, this.gradlePath);
    }

    public String toString() {
        return "JarInfo{jarFile=" + this.jarFile + ", gradlePath='" + this.gradlePath + '\'' + ", compiled=" + this.compiled + ", packaged=" + this.packaged + ", dependencies=" + this.dependencies + ", resolvedCoordinates=" + this.resolvedCoordinates + '}';
    }
}

