/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.HtmlReporter;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.TextReporter;
import com.android.tools.lint.XmlReporter;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;

public class LintOptions
implements com.android.builder.model.LintOptions,
Serializable {
    public static final String STDOUT = "stdout";
    public static final String STDERR = "stderr";
    private static final long serialVersionUID = 1L;
    @NonNull
    private Set<String> disable = Sets.newHashSet();
    @NonNull
    private Set<String> enable = Sets.newHashSet();
    @Nullable
    private Set<String> check = Sets.newHashSet();
    private boolean abortOnError = true;
    private boolean absolutePaths = true;
    private boolean noLines;
    private boolean quiet;
    private boolean checkAllWarnings;
    private boolean ignoreWarnings;
    private boolean warningsAsErrors;
    private boolean showAll;
    private boolean checkReleaseBuilds = true;
    private boolean explainIssues = true;
    @Nullable
    private File lintConfig;
    private boolean textReport;
    @Nullable
    private File textOutput;
    private boolean htmlReport = true;
    @Nullable
    private File htmlOutput;
    private boolean xmlReport = true;
    @Nullable
    private File xmlOutput;
    private Map<String, Severity> severities = Maps.newHashMap();

    public LintOptions() {
    }

    public LintOptions(@NonNull Set<String> disable, @NonNull Set<String> enable, @Nullable Set<String> check, @Nullable File lintConfig, boolean textReport, @Nullable File textOutput, boolean htmlReport, @Nullable File htmlOutput, boolean xmlReport, @Nullable File xmlOutput, boolean abortOnError, boolean absolutePaths, boolean noLines, boolean quiet, boolean checkAllWarnings, boolean ignoreWarnings, boolean warningsAsErrors, boolean showAll, boolean explainIssues, boolean checkReleaseBuilds, @Nullable Map<String, Integer> severityOverrides) {
        this.disable = disable;
        this.enable = enable;
        this.check = check;
        this.lintConfig = lintConfig;
        this.textReport = textReport;
        this.textOutput = textOutput;
        this.htmlReport = htmlReport;
        this.htmlOutput = htmlOutput;
        this.xmlReport = xmlReport;
        this.xmlOutput = xmlOutput;
        this.abortOnError = abortOnError;
        this.absolutePaths = absolutePaths;
        this.noLines = noLines;
        this.quiet = quiet;
        this.checkAllWarnings = checkAllWarnings;
        this.ignoreWarnings = ignoreWarnings;
        this.warningsAsErrors = warningsAsErrors;
        this.showAll = showAll;
        this.explainIssues = explainIssues;
        this.checkReleaseBuilds = checkReleaseBuilds;
        if (severityOverrides != null) {
            for (Map.Entry<String, Integer> entry : severityOverrides.entrySet()) {
                this.severities.put(entry.getKey(), LintOptions.convert(entry.getValue()));
            }
        }
    }

    @NonNull
    public static com.android.builder.model.LintOptions create(@NonNull com.android.builder.model.LintOptions source) {
        return new LintOptions(source.getDisable(), source.getEnable(), source.getCheck(), source.getLintConfig(), source.getTextReport(), source.getTextOutput(), source.getHtmlReport(), source.getHtmlOutput(), source.getXmlReport(), source.getXmlOutput(), source.isAbortOnError(), source.isAbsolutePaths(), source.isNoLines(), source.isQuiet(), source.isCheckAllWarnings(), source.isIgnoreWarnings(), source.isWarningsAsErrors(), source.isShowAll(), source.isExplainIssues(), source.isCheckReleaseBuilds(), source.getSeverityOverrides());
    }

    @Input
    @NonNull
    public Set<String> getDisable() {
        return this.disable;
    }

    public void setDisable(@Nullable Set<String> ids) {
        this.disable.addAll(ids);
    }

    @Input
    @NonNull
    public Set<String> getEnable() {
        return this.enable;
    }

    public void setEnable(@Nullable Set<String> ids) {
        this.enable.addAll(ids);
    }

    @Optional
    @Input
    @Nullable
    public Set<String> getCheck() {
        return this.check;
    }

    public void setCheck(@NonNull Set<String> ids) {
        this.check.addAll(ids);
    }

    @Input
    public boolean isAbortOnError() {
        return this.abortOnError;
    }

    public void setAbortOnError(boolean abortOnError) {
        this.abortOnError = abortOnError;
    }

    @Input
    public boolean isAbsolutePaths() {
        return this.absolutePaths;
    }

    public void setAbsolutePaths(boolean absolutePaths) {
        this.absolutePaths = absolutePaths;
    }

    @Input
    public boolean isNoLines() {
        return this.noLines;
    }

    public void setNoLines(boolean noLines) {
        this.noLines = noLines;
    }

    @Input
    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    @Input
    public boolean isCheckAllWarnings() {
        return this.checkAllWarnings;
    }

    public void setCheckAllWarnings(boolean warnAll) {
        this.checkAllWarnings = warnAll;
    }

    @Input
    public boolean isIgnoreWarnings() {
        return this.ignoreWarnings;
    }

    public void setIgnoreWarnings(boolean noWarnings) {
        this.ignoreWarnings = noWarnings;
    }

    @Input
    public boolean isWarningsAsErrors() {
        return this.warningsAsErrors;
    }

    public void setWarningsAsErrors(boolean allErrors) {
        this.warningsAsErrors = allErrors;
    }

    @Input
    public boolean isExplainIssues() {
        return this.explainIssues;
    }

    public void setExplainIssues(boolean explainIssues) {
        this.explainIssues = explainIssues;
    }

    @Input
    public boolean isShowAll() {
        return this.showAll;
    }

    public void setShowAll(boolean showAll) {
        this.showAll = showAll;
    }

    @Input
    public boolean isCheckReleaseBuilds() {
        return this.checkReleaseBuilds;
    }

    public void setCheckReleaseBuilds(boolean checkReleaseBuilds) {
        this.checkReleaseBuilds = checkReleaseBuilds;
    }

    @Optional
    @InputFile
    public File getLintConfig() {
        return this.lintConfig;
    }

    @Input
    public boolean getTextReport() {
        return this.textReport;
    }

    public void setTextReport(boolean textReport) {
        this.textReport = textReport;
    }

    public void setHtmlReport(boolean htmlReport) {
        this.htmlReport = htmlReport;
    }

    public void setHtmlOutput(@NonNull File htmlOutput) {
        this.htmlOutput = htmlOutput;
    }

    public void setXmlReport(boolean xmlReport) {
        this.xmlReport = xmlReport;
    }

    public void setXmlOutput(@NonNull File xmlOutput) {
        this.xmlOutput = xmlOutput;
    }

    @Optional
    @Input
    @Nullable
    public File getTextOutput() {
        return this.textOutput;
    }

    @Input
    public boolean getHtmlReport() {
        return this.htmlReport;
    }

    @Optional
    @OutputFile
    @Nullable
    public File getHtmlOutput() {
        return this.htmlOutput;
    }

    @Input
    public boolean getXmlReport() {
        return this.xmlReport;
    }

    @Optional
    @OutputFile
    @Nullable
    public File getXmlOutput() {
        return this.xmlOutput;
    }

    public void setLintConfig(@NonNull File lintConfig) {
        this.lintConfig = lintConfig;
    }

    public void syncTo(@NonNull LintCliClient client, @NonNull LintCliFlags flags, @Nullable String variantName, @Nullable Project project, boolean report) {
        if (this.disable != null) {
            flags.getSuppressedIds().addAll(this.disable);
        }
        if (this.enable != null) {
            flags.getEnabledIds().addAll(this.enable);
        }
        if (this.check != null && !this.check.isEmpty()) {
            flags.setExactCheckedIds(this.check);
        }
        flags.setSetExitCode(this.abortOnError);
        flags.setFullPath(this.absolutePaths);
        flags.setShowSourceLines(!this.noLines);
        flags.setQuiet(this.quiet);
        flags.setCheckAllWarnings(this.checkAllWarnings);
        flags.setIgnoreWarnings(this.ignoreWarnings);
        flags.setWarningsAsErrors(this.warningsAsErrors);
        flags.setShowEverything(this.showAll);
        flags.setDefaultConfiguration(this.lintConfig);
        flags.setSeverityOverrides(this.severities);
        flags.setExplainIssues(this.explainIssues);
        if (report || flags.isFatalOnly() && this.abortOnError) {
            File output;
            if (this.textReport || flags.isFatalOnly()) {
                boolean closeWriter;
                Writer writer;
                output = this.textOutput;
                if (output == null) {
                    output = new File(flags.isFatalOnly() ? STDERR : STDOUT);
                } else if (!(output.isAbsolute() || LintOptions.isStdOut(output) || LintOptions.isStdErr(output))) {
                    output = project.file((Object)output.getPath());
                }
                output = LintOptions.validateOutputFile(output);
                File file = null;
                if (LintOptions.isStdOut(output)) {
                    writer = new PrintWriter(System.out, true);
                    closeWriter = false;
                } else if (LintOptions.isStdErr(output)) {
                    writer = new PrintWriter(System.err, true);
                    closeWriter = false;
                } else {
                    file = output;
                    try {
                        writer = new BufferedWriter(new FileWriter(output));
                    }
                    catch (IOException e) {
                        throw new GradleException("Text invalid argument.", (Throwable)e);
                    }
                    closeWriter = true;
                }
                flags.getReporters().add(new TextReporter(client, flags, file, writer, closeWriter));
            }
            if (this.htmlReport) {
                output = this.htmlOutput;
                if (output == null || flags.isFatalOnly()) {
                    output = LintOptions.createOutputPath(project, variantName, ".html", flags.isFatalOnly());
                } else if (!output.isAbsolute()) {
                    output = project.file((Object)output.getPath());
                }
                output = LintOptions.validateOutputFile(output);
                try {
                    flags.getReporters().add(new HtmlReporter(client, output));
                }
                catch (IOException e) {
                    throw new GradleException("HTML invalid argument.", (Throwable)e);
                }
            }
            if (this.xmlReport) {
                output = this.xmlOutput;
                if (output == null || flags.isFatalOnly()) {
                    output = LintOptions.createOutputPath(project, variantName, ".xml", flags.isFatalOnly());
                } else if (!output.isAbsolute()) {
                    output = project.file((Object)output.getPath());
                }
                output = LintOptions.validateOutputFile(output);
                try {
                    flags.getReporters().add(new XmlReporter(client, output));
                }
                catch (IOException e) {
                    throw new GradleException("XML invalid argument.", (Throwable)e);
                }
            }
        }
    }

    private static boolean isStdOut(@NonNull File output) {
        return STDOUT.equals(output.getPath());
    }

    private static boolean isStdErr(@NonNull File output) {
        return STDERR.equals(output.getPath());
    }

    @NonNull
    private static File validateOutputFile(@NonNull File output) {
        boolean delete;
        if (LintOptions.isStdOut(output) || LintOptions.isStdErr(output)) {
            return output;
        }
        File parent = output.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        if ((output = output.getAbsoluteFile()).exists() && !(delete = output.delete())) {
            throw new GradleException("Could not delete old " + output);
        }
        if (output.getParentFile() != null && !output.getParentFile().canWrite()) {
            throw new GradleException("Cannot write output file " + output);
        }
        return output;
    }

    private static File createOutputPath(@NonNull Project project, @NonNull String variantName, @NonNull String extension, boolean fatalOnly) {
        StringBuilder base = new StringBuilder();
        base.append("outputs");
        base.append(File.separator);
        base.append("lint-results");
        if (variantName != null) {
            base.append("-");
            base.append(variantName);
        }
        if (fatalOnly) {
            base.append("-fatal");
        }
        base.append(extension);
        return new File(project.getBuildDir(), base.toString());
    }

    @Nullable
    public Map<String, Integer> getSeverityOverrides() {
        if (this.severities == null || this.severities.isEmpty()) {
            return null;
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)this.severities.size());
        for (Map.Entry<String, Severity> entry : this.severities.entrySet()) {
            map.put(entry.getKey(), LintOptions.convert(entry.getValue()));
        }
        return map;
    }

    public void check(String id) {
        this.check.add(id);
    }

    public void check(String ... ids) {
        for (String id : ids) {
            this.check(id);
        }
    }

    public void enable(String id) {
        this.enable.add(id);
        Issue issue = new BuiltinIssueRegistry().getIssue(id);
        this.severities.put(id, issue != null ? issue.getDefaultSeverity() : Severity.WARNING);
    }

    public void enable(String ... ids) {
        for (String id : ids) {
            this.enable(id);
        }
    }

    public void disable(String id) {
        this.disable.add(id);
        this.severities.put(id, Severity.IGNORE);
    }

    public void disable(String ... ids) {
        for (String id : ids) {
            this.disable(id);
        }
    }

    public void textOutput(String textOutput) {
        this.textOutput = new File(textOutput);
    }

    public void textOutput(File textOutput) {
        this.textOutput = textOutput;
    }

    public void fatal(String id) {
        this.severities.put(id, Severity.FATAL);
    }

    public void fatal(String ... ids) {
        for (String id : ids) {
            this.fatal(id);
        }
    }

    public void error(String id) {
        this.severities.put(id, Severity.ERROR);
    }

    public void error(String ... ids) {
        for (String id : ids) {
            this.error(id);
        }
    }

    public void warning(String id) {
        this.severities.put(id, Severity.WARNING);
    }

    public void warning(String ... ids) {
        for (String id : ids) {
            this.warning(id);
        }
    }

    public void ignore(String id) {
        this.severities.put(id, Severity.IGNORE);
    }

    public void ignore(String ... ids) {
        for (String id : ids) {
            this.ignore(id);
        }
    }

    private static int convert(Severity s) {
        switch (s) {
            case FATAL: {
                return 1;
            }
            case ERROR: {
                return 2;
            }
            case WARNING: {
                return 3;
            }
            case INFORMATIONAL: {
                return 4;
            }
        }
        return 5;
    }

    private static Severity convert(int s) {
        switch (s) {
            case 1: {
                return Severity.FATAL;
            }
            case 2: {
                return Severity.ERROR;
            }
            case 3: {
                return Severity.WARNING;
            }
            case 4: {
                return Severity.INFORMATIONAL;
            }
        }
        return Severity.IGNORE;
    }
}

