/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.internal.TaskFactory;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Task;

public class AndroidTask<T extends Task> {
    @NonNull
    private String name;
    @NonNull
    private final Class<T> taskType;
    @Nullable
    private T task;
    @NonNull
    private final List<AndroidTask<? extends Task>> upstreamTasks;
    @NonNull
    private final List<AndroidTask<? extends Task>> downstreamTasks;

    public AndroidTask(@NonNull String name, @NonNull Class<T> taskType) {
        this.name = name;
        this.taskType = taskType;
        this.upstreamTasks = new ArrayList<AndroidTask<? extends Task>>();
        this.downstreamTasks = new ArrayList<AndroidTask<? extends Task>>();
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public Class<T> getTaskType() {
        return this.taskType;
    }

    @NonNull
    public List<AndroidTask<? extends Task>> getUpstreamTasks() {
        return this.upstreamTasks;
    }

    @NonNull
    public List<AndroidTask<? extends Task>> getDownstreamTasks() {
        return this.downstreamTasks;
    }

    public void dependsOn(TaskFactory taskFactory, final AndroidTask<?> other) {
        taskFactory.named(this.name, (Action<? super Task>)new Action<Task>(){

            public void execute(Task task) {
                task.dependsOn(new Object[]{other.name});
            }
        });
        this.upstreamTasks.add(other);
        super.addDependent(this);
    }

    public void dependsOn(TaskFactory taskFactory, final Object ... dependencies) {
        taskFactory.named(this.name, (Action<? super Task>)new Action<Task>(){

            public void execute(Task task) {
                for (Object dependency : dependencies) {
                    if (dependency instanceof AndroidTask) {
                        task.dependsOn(new Object[]{((AndroidTask)dependency).getName()});
                        continue;
                    }
                    task.dependsOn(new Object[]{dependency});
                }
            }
        });
    }

    public void optionalDependsOn(TaskFactory taskFactory, Object ... dependencies) {
        for (Object dependency : dependencies) {
            if (dependency == null) continue;
            if (dependency instanceof AndroidTask) {
                this.dependsOn(taskFactory, ((AndroidTask)dependency).getName());
                continue;
            }
            this.dependsOn(taskFactory, dependency);
        }
    }

    public void optionalDependsOn(TaskFactory taskFactory, @NonNull List<?> dependencies) {
        for (Object dependency : dependencies) {
            if (dependency == null) continue;
            this.dependsOn(taskFactory, dependency);
        }
    }

    private void addDependent(AndroidTask<? extends Task> tAndroidTask) {
        this.downstreamTasks.add(tAndroidTask);
    }

    public void configure(TaskFactory taskFactory, Action<? super Task> configAction) {
        taskFactory.named(this.name, configAction);
    }
}

