/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.annotations.NonNull;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.SdkHandler;
import com.android.builder.core.AndroidBuilder;
import java.io.File;
import org.gradle.api.Project;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class GlobalScope {
    @NonNull
    private Project project;
    @NonNull
    private AndroidBuilder androidBuilder;
    @NonNull
    private String projectBaseName;
    @NonNull
    private AndroidConfig extension;
    @NonNull
    private SdkHandler sdkHandler;
    @NonNull
    private ToolingModelBuilderRegistry toolingRegistry;
    @NonNull
    private final File intermediatesDir;
    @NonNull
    private final File generatedDir;
    @NonNull
    private final File reportsDir;
    @NonNull
    private final File outputsDir;

    public GlobalScope(@NonNull Project project, @NonNull AndroidBuilder androidBuilder, @NonNull String projectBaseName, @NonNull AndroidConfig extension, @NonNull SdkHandler sdkHandler, @NonNull ToolingModelBuilderRegistry toolingRegistry) {
        this.project = project;
        this.androidBuilder = androidBuilder;
        this.projectBaseName = projectBaseName;
        this.extension = extension;
        this.sdkHandler = sdkHandler;
        this.toolingRegistry = toolingRegistry;
        this.intermediatesDir = new File(this.getBuildDir(), "intermediates");
        this.generatedDir = new File(this.getBuildDir(), "generated");
        this.reportsDir = new File(this.getBuildDir(), "reports");
        this.outputsDir = new File(this.getBuildDir(), "outputs");
    }

    @NonNull
    public Project getProject() {
        return this.project;
    }

    @NonNull
    public AndroidConfig getExtension() {
        return this.extension;
    }

    @NonNull
    public AndroidBuilder getAndroidBuilder() {
        return this.androidBuilder;
    }

    @NonNull
    public String getProjectBaseName() {
        return this.projectBaseName;
    }

    @NonNull
    public SdkHandler getSdkHandler() {
        return this.sdkHandler;
    }

    @NonNull
    public ToolingModelBuilderRegistry getToolingRegistry() {
        return this.toolingRegistry;
    }

    @NonNull
    public File getBuildDir() {
        return this.project.getBuildDir();
    }

    @NonNull
    public File getIntermediatesDir() {
        return this.intermediatesDir;
    }

    @NonNull
    public File getGeneratedDir() {
        return this.generatedDir;
    }

    @NonNull
    public File getReportsDir() {
        return this.reportsDir;
    }

    @NonNull
    public File getOutputsDir() {
        return this.outputsDir;
    }

    @NonNull
    public String getDefaultApkLocation() {
        return this.getBuildDir() + "/" + "outputs" + "/apk";
    }

    @NonNull
    public String getApkLocation() {
        String apkLocation = this.getDefaultApkLocation();
        if (this.project.hasProperty("android.injected.apk.location")) {
            apkLocation = (String)this.project.getProperties().get("android.injected.apk.location");
        }
        return apkLocation;
    }
}

