/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.coverage.JacocoInstrumentTask;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.tasks.CheckManifest;
import com.android.build.gradle.internal.tasks.FileSupplier;
import com.android.build.gradle.internal.tasks.PrepareDependenciesTask;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.LibraryVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.tasks.AidlCompile;
import com.android.build.gradle.tasks.BinaryFileProviderTask;
import com.android.build.gradle.tasks.Dex;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.GenerateResValues;
import com.android.build.gradle.tasks.JackTask;
import com.android.build.gradle.tasks.MergeAssets;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.NdkCompile;
import com.android.build.gradle.tasks.PreprocessResourcesTask;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.build.gradle.tasks.RenderscriptCompile;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.core.VariantType;
import com.android.utils.StringHelper;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;

public class VariantScope {
    @NonNull
    private GlobalScope globalScope;
    @NonNull
    private BaseVariantData<? extends BaseVariantOutputData> variantData;
    @Nullable
    private Collection<Object> ndkBuildable;
    @Nullable
    private Collection<File> ndkSoFolder;
    @Nullable
    private File ndkObjFolder;
    @NonNull
    private Map<Abi, File> ndkDebuggableLibraryFolders = Maps.newHashMap();
    @Nullable
    private File mergeResourceOutputDir;
    private AndroidTask<Task> preBuildTask;
    private AndroidTask<PrepareDependenciesTask> prepareDependenciesTask;
    private AndroidTask<ProcessAndroidResources> generateRClassTask;
    private AndroidTask<Task> sourceGenTask;
    private AndroidTask<Task> resourceGenTask;
    private AndroidTask<Task> assetGenTask;
    private AndroidTask<CheckManifest> checkManifestTask;
    private AndroidTask<RenderscriptCompile> renderscriptCompileTask;
    private AndroidTask<AidlCompile> aidlCompileTask;
    @Nullable
    private AndroidTask<MergeResources> mergeResourcesTask;
    @Nullable
    private AndroidTask<MergeAssets> mergeAssetsTask;
    private AndroidTask<GenerateBuildConfig> generateBuildConfigTask;
    private AndroidTask<GenerateResValues> generateResValuesTask;
    @Nullable
    private AndroidTask<Dex> dexTask;
    @Nullable
    private AndroidTask jacocoIntrumentTask;
    @Nullable
    private AndroidTask<PreprocessResourcesTask> preprocessResourcesTask;
    private AndroidTask<Copy> processJavaResourcesTask;
    private AndroidTask<NdkCompile> ndkCompileTask;
    @Nullable
    private AndroidTask<? extends AbstractCompile> javaCompilerTask;
    @Nullable
    private AndroidTask<JavaCompile> javacTask;
    @Nullable
    private AndroidTask<JackTask> jackTask;
    private AndroidTask<Task> compileTask;
    private AndroidTask<JacocoInstrumentTask> jacocoInstrumentTask;
    private FileSupplier mappingFileProviderTask;
    private AndroidTask<BinaryFileProviderTask> binayFileProviderTask;
    private AndroidTask<? extends Task> obfuscationTask;
    private File resourceOutputDir;

    public VariantScope(@NonNull GlobalScope globalScope, @NonNull BaseVariantData<? extends BaseVariantOutputData> variantData) {
        this.globalScope = globalScope;
        this.variantData = variantData;
    }

    @NonNull
    public GlobalScope getGlobalScope() {
        return this.globalScope;
    }

    @NonNull
    public BaseVariantData<? extends BaseVariantOutputData> getVariantData() {
        return this.variantData;
    }

    @NonNull
    public GradleVariantConfiguration getVariantConfiguration() {
        return this.variantData.getVariantConfiguration();
    }

    @NonNull
    public String getTaskName(@NonNull String prefix) {
        return this.getTaskName(prefix, "");
    }

    @NonNull
    public String getTaskName(@NonNull String prefix, @NonNull String suffix) {
        return prefix + StringHelper.capitalize((String)this.getVariantConfiguration().getFullName()) + suffix;
    }

    @Nullable
    public Collection<Object> getNdkBuildable() {
        return this.ndkBuildable;
    }

    public void setNdkBuildable(@NonNull Collection<Object> ndkBuildable) {
        this.ndkBuildable = ndkBuildable;
    }

    @Nullable
    public Collection<File> getNdkSoFolder() {
        return this.ndkSoFolder;
    }

    public void setNdkSoFolder(@NonNull Collection<File> ndkSoFolder) {
        this.ndkSoFolder = ndkSoFolder;
    }

    @Nullable
    public File getNdkObjFolder() {
        return this.ndkObjFolder;
    }

    public void setNdkObjFolder(@NonNull File ndkObjFolder) {
        this.ndkObjFolder = ndkObjFolder;
    }

    @Nullable
    public File getNdkDebuggableLibraryFolders(@NonNull Abi abi) {
        return this.ndkDebuggableLibraryFolders.get((Object)abi);
    }

    public void addNdkDebuggableLibraryFolders(@NonNull Abi abi, @NonNull File searchPath) {
        this.ndkDebuggableLibraryFolders.put(abi, searchPath);
    }

    @NonNull
    public Set<File> getJniFolders() {
        File rsLibs;
        assert (this.getNdkSoFolder() != null);
        GradleVariantConfiguration config = this.getVariantConfiguration();
        ApkVariantData apkVariantData = (ApkVariantData)this.variantData;
        HashSet set = Sets.newHashSet();
        set.addAll(this.getNdkSoFolder());
        set.add(this.getRenderscriptLibOutputDir());
        set.addAll(config.getLibraryJniFolders());
        set.addAll(config.getJniLibsList());
        if (config.getMergedFlavor().getRenderscriptSupportModeEnabled() != null && config.getMergedFlavor().getRenderscriptSupportModeEnabled().booleanValue() && (rsLibs = this.globalScope.getAndroidBuilder().getSupportNativeLibFolder()) != null && rsLibs.isDirectory()) {
            set.add(rsLibs);
        }
        return set;
    }

    @Nullable
    public BaseVariantData getTestedVariantData() {
        return this.variantData instanceof TestVariantData ? (BaseVariantData)((Object)((TestVariantData)this.variantData).getTestedVariantData()) : null;
    }

    @NonNull
    public File getDexOutputFolder() {
        return new File(this.globalScope.getIntermediatesDir(), "/dex/" + this.getVariantConfiguration().getDirName());
    }

    @NonNull
    public FileCollection getJavaClasspath() {
        return this.getGlobalScope().getProject().files(new Object[]{this.getGlobalScope().getAndroidBuilder().getCompileClasspath((VariantConfiguration)this.getVariantData().getVariantConfiguration())});
    }

    @NonNull
    public File getJavaOutputDir() {
        return new File(this.globalScope.getIntermediatesDir(), "/classes/" + this.variantData.getVariantConfiguration().getDirName());
    }

    @NonNull
    public File getJavaDependencyCache() {
        return new File(this.globalScope.getIntermediatesDir(), "/dependency-cache/" + this.variantData.getVariantConfiguration().getDirName());
    }

    @NonNull
    public File getPreDexOutputDir() {
        return new File(this.globalScope.getIntermediatesDir(), "/pre-dexed/" + this.getVariantConfiguration().getDirName());
    }

    @NonNull
    public File getProguardOutputFile() {
        return this.variantData instanceof LibraryVariantData ? new File(this.globalScope.getIntermediatesDir(), "bundles/" + this.getVariantConfiguration().getDirName() + "/classes.jar") : new File(this.globalScope.getIntermediatesDir(), "/classes-proguard/" + this.getVariantConfiguration().getDirName() + "/classes.jar");
    }

    @NonNull
    public File getProguardComponentsJarFile() {
        return new File(this.globalScope.getIntermediatesDir(), "multi-dex/" + this.getVariantConfiguration().getDirName() + "/componentClasses.jar");
    }

    @NonNull
    public File getJarMergingOutputFile() {
        return new File(this.globalScope.getIntermediatesDir(), "multi-dex/" + this.getVariantConfiguration().getDirName() + "/allclasses.jar");
    }

    @NonNull
    public File getManifestKeepListFile() {
        return new File(this.globalScope.getIntermediatesDir(), "multi-dex/" + this.getVariantConfiguration().getDirName() + "/manifest_keep.txt");
    }

    @NonNull
    public File getMainDexListFile() {
        return new File(this.globalScope.getIntermediatesDir(), "multi-dex/" + this.getVariantConfiguration().getDirName() + "/maindexlist.txt");
    }

    @NonNull
    public File getRenderscriptSourceOutputDir() {
        return new File(this.globalScope.getGeneratedDir(), "source/rs/" + this.variantData.getVariantConfiguration().getDirName());
    }

    @NonNull
    public File getRenderscriptLibOutputDir() {
        return new File(this.globalScope.getGeneratedDir(), "rs/" + this.variantData.getVariantConfiguration().getDirName() + "/lib");
    }

    @NonNull
    public File getSymbolLocation() {
        return new File(this.globalScope.getIntermediatesDir() + "/symbols/" + this.variantData.getVariantConfiguration().getDirName());
    }

    @NonNull
    public File getFinalResourcesDir() {
        if (this.preprocessResourcesTask != null) {
            return this.getPreprocessResourceOutputDir();
        }
        return this.resourceOutputDir;
    }

    public void setResourceOutputDir(@NonNull File resourceOutputDir) {
        this.resourceOutputDir = resourceOutputDir;
    }

    @NonNull
    public File getPreprocessResourceOutputDir() {
        return new File(this.getGlobalScope().getIntermediatesDir(), "res/preprocessed/" + this.getVariantConfiguration().getDirName());
    }

    @NonNull
    public File getDefaultMergeResourcesOutputDir() {
        return new File(this.globalScope.getIntermediatesDir(), "/res/merged/" + this.getVariantConfiguration().getDirName());
    }

    @NonNull
    public File getMergeResourcesOutputDir() {
        if (this.mergeResourceOutputDir == null) {
            return this.getDefaultMergeResourcesOutputDir();
        }
        return this.mergeResourceOutputDir;
    }

    public void setMergeResourceOutputDir(@Nullable File mergeResourceOutputDir) {
        this.mergeResourceOutputDir = mergeResourceOutputDir;
    }

    @NonNull
    public File getMergeAssetsOutputDir() {
        return this.getVariantConfiguration().getType() == VariantType.LIBRARY ? new File(this.globalScope.getIntermediatesDir(), "bundles/" + this.getVariantConfiguration().getDirName() + "/assets") : new File(this.globalScope.getIntermediatesDir(), "/assets/" + this.getVariantConfiguration().getDirName());
    }

    @NonNull
    public File getBuildConfigSourceOutputDir() {
        return new File(this.globalScope.getBuildDir() + "/" + "generated" + "/source/buildConfig/" + this.variantData.getVariantConfiguration().getDirName());
    }

    @NonNull
    public File getGeneratedResOutputDir() {
        return new File(this.globalScope.getGeneratedDir(), "res/resValues/" + this.getVariantConfiguration().getDirName());
    }

    @NonNull
    public File getRenderscriptResOutputDir() {
        return new File(this.globalScope.getGeneratedDir(), "res/rs/" + this.getVariantConfiguration().getDirName());
    }

    @NonNull
    public File getJavaResourcesDestinationDir() {
        return new File(this.globalScope.getIntermediatesDir(), "javaResources/" + this.getVariantConfiguration().getDirName());
    }

    @NonNull
    public File getRClassSourceOutputDir() {
        return new File(this.globalScope.getGeneratedDir(), "source/r/" + this.getVariantConfiguration().getDirName());
    }

    @NonNull
    public File getAidlSourceOutputDir() {
        return new File(this.globalScope.getGeneratedDir(), "source/aidl/" + this.getVariantConfiguration().getDirName());
    }

    @NonNull
    public File getJackIncrementalDir() {
        return new File(this.globalScope.getIntermediatesDir(), "incremental/jack/" + this.getVariantConfiguration().getDirName());
    }

    @NonNull
    public File getJackTempDir() {
        return new File(this.globalScope.getIntermediatesDir(), "tmp/jack/" + this.getVariantConfiguration().getDirName());
    }

    @NonNull
    public File getJillPackagedLibrariesDir() {
        return new File(this.globalScope.getIntermediatesDir(), "jill/" + this.getVariantConfiguration().getDirName() + "/packaged");
    }

    @NonNull
    public File getJillRuntimeLibrariesDir() {
        return new File(this.globalScope.getIntermediatesDir(), "jill/" + this.getVariantConfiguration().getDirName() + "/runtime");
    }

    @NonNull
    public File getJackDestinationDir() {
        return new File(this.globalScope.getIntermediatesDir(), "dex/" + this.getVariantConfiguration().getDirName());
    }

    @NonNull
    public File getJackClassesZip() {
        return new File(this.globalScope.getIntermediatesDir(), "packaged/" + this.getVariantConfiguration().getDirName() + "/classes.zip");
    }

    @NonNull
    public File getProguardOutputFolder() {
        return new File(this.globalScope.getBuildDir(), "/outputs/mapping/" + this.getVariantConfiguration().getDirName());
    }

    @NonNull
    public File getProcessAndroidResourcesProguardOutputFile() {
        return new File(this.globalScope.getIntermediatesDir(), "/proguard-rules/" + this.getVariantConfiguration().getDirName() + "/aapt_rules.txt");
    }

    public File getMappingFile() {
        return new File(this.globalScope.getOutputsDir(), "/mapping/" + this.getVariantConfiguration().getDirName() + "/mapping.txt");
    }

    public AndroidTask<Task> getPreBuildTask() {
        return this.preBuildTask;
    }

    public void setPreBuildTask(AndroidTask<Task> preBuildTask) {
        this.preBuildTask = preBuildTask;
    }

    public AndroidTask<PrepareDependenciesTask> getPrepareDependenciesTask() {
        return this.prepareDependenciesTask;
    }

    public void setPrepareDependenciesTask(AndroidTask<PrepareDependenciesTask> prepareDependenciesTask) {
        this.prepareDependenciesTask = prepareDependenciesTask;
    }

    public AndroidTask<ProcessAndroidResources> getGenerateRClassTask() {
        return this.generateRClassTask;
    }

    public void setGenerateRClassTask(AndroidTask<ProcessAndroidResources> generateRClassTask) {
        this.generateRClassTask = generateRClassTask;
    }

    public AndroidTask<Task> getSourceGenTask() {
        return this.sourceGenTask;
    }

    public void setSourceGenTask(AndroidTask<Task> sourceGenTask) {
        this.sourceGenTask = sourceGenTask;
    }

    public AndroidTask<Task> getResourceGenTask() {
        return this.resourceGenTask;
    }

    public void setResourceGenTask(AndroidTask<Task> resourceGenTask) {
        this.resourceGenTask = resourceGenTask;
    }

    public AndroidTask<Task> getAssetGenTask() {
        return this.assetGenTask;
    }

    public void setAssetGenTask(AndroidTask<Task> assetGenTask) {
        this.assetGenTask = assetGenTask;
    }

    public AndroidTask<CheckManifest> getCheckManifestTask() {
        return this.checkManifestTask;
    }

    public void setCheckManifestTask(AndroidTask<CheckManifest> checkManifestTask) {
        this.checkManifestTask = checkManifestTask;
    }

    public AndroidTask<RenderscriptCompile> getRenderscriptCompileTask() {
        return this.renderscriptCompileTask;
    }

    public void setRenderscriptCompileTask(AndroidTask<RenderscriptCompile> renderscriptCompileTask) {
        this.renderscriptCompileTask = renderscriptCompileTask;
    }

    public AndroidTask<AidlCompile> getAidlCompileTask() {
        return this.aidlCompileTask;
    }

    public void setAidlCompileTask(AndroidTask<AidlCompile> aidlCompileTask) {
        this.aidlCompileTask = aidlCompileTask;
    }

    @Nullable
    public AndroidTask<MergeResources> getMergeResourcesTask() {
        return this.mergeResourcesTask;
    }

    public void setMergeResourcesTask(@Nullable AndroidTask<MergeResources> mergeResourcesTask) {
        this.mergeResourcesTask = mergeResourcesTask;
    }

    @Nullable
    public AndroidTask<MergeAssets> getMergeAssetsTask() {
        return this.mergeAssetsTask;
    }

    public void setMergeAssetsTask(@Nullable AndroidTask<MergeAssets> mergeAssetsTask) {
        this.mergeAssetsTask = mergeAssetsTask;
    }

    public AndroidTask<GenerateBuildConfig> getGenerateBuildConfigTask() {
        return this.generateBuildConfigTask;
    }

    public void setGenerateBuildConfigTask(AndroidTask<GenerateBuildConfig> generateBuildConfigTask) {
        this.generateBuildConfigTask = generateBuildConfigTask;
    }

    public AndroidTask<GenerateResValues> getGenerateResValuesTask() {
        return this.generateResValuesTask;
    }

    public void setGenerateResValuesTask(AndroidTask<GenerateResValues> generateResValuesTask) {
        this.generateResValuesTask = generateResValuesTask;
    }

    @Nullable
    public AndroidTask<Dex> getDexTask() {
        return this.dexTask;
    }

    public void setDexTask(@Nullable AndroidTask<Dex> dexTask) {
        this.dexTask = dexTask;
    }

    @Nullable
    public AndroidTask<PreprocessResourcesTask> getPreprocessResourcesTask() {
        return this.preprocessResourcesTask;
    }

    public void setPreprocessResourcesTask(@Nullable AndroidTask<PreprocessResourcesTask> preprocessResourcesTask) {
        this.preprocessResourcesTask = preprocessResourcesTask;
    }

    public AndroidTask<Copy> getProcessJavaResourcesTask() {
        return this.processJavaResourcesTask;
    }

    public void setProcessJavaResourcesTask(AndroidTask<Copy> processJavaResourcesTask) {
        this.processJavaResourcesTask = processJavaResourcesTask;
    }

    @Nullable
    public AndroidTask<? extends AbstractCompile> getJavaCompilerTask() {
        return this.javaCompilerTask;
    }

    @Nullable
    public AndroidTask<JackTask> getJackTask() {
        return this.jackTask;
    }

    public void setJackTask(@Nullable AndroidTask<JackTask> jackTask) {
        this.jackTask = jackTask;
    }

    @Nullable
    public AndroidTask<JavaCompile> getJavacTask() {
        return this.javacTask;
    }

    public void setJavacTask(@Nullable AndroidTask<JavaCompile> javacTask) {
        this.javacTask = javacTask;
    }

    public void setJavaCompilerTask(@NonNull AndroidTask<? extends AbstractCompile> javaCompileTask) {
        this.javaCompilerTask = javaCompileTask;
    }

    public AndroidTask<Task> getCompileTask() {
        return this.compileTask;
    }

    public void setCompileTask(AndroidTask<Task> compileTask) {
        this.compileTask = compileTask;
    }

    public AndroidTask<? extends Task> getObfuscationTask() {
        return this.obfuscationTask;
    }

    public void setObfuscationTask(AndroidTask<? extends Task> obfuscationTask) {
        this.obfuscationTask = obfuscationTask;
    }
}

