/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.annotations.NonNull;
import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;

public class TestVariantData
extends ApkVariantData {
    public DeviceProviderInstrumentTestTask connectedTestTask;
    public final List<DeviceProviderInstrumentTestTask> providerTestTaskList = Lists.newArrayList();
    @NonNull
    private final TestedVariantData testedVariantData;

    public TestVariantData(@NonNull AndroidConfig androidConfig, @NonNull TaskManager taskManager, @NonNull GradleVariantConfiguration config, @NonNull TestedVariantData testedVariantData) {
        super(androidConfig, taskManager, config);
        this.testedVariantData = testedVariantData;
        this.createOutput(OutputFile.OutputType.MAIN, Collections.<FilterData>emptyList());
    }

    @NonNull
    public TestedVariantData getTestedVariantData() {
        return this.testedVariantData;
    }

    @Override
    @NonNull
    public String getDescription() {
        String prefix;
        switch (this.getType()) {
            case ANDROID_TEST: {
                prefix = "android (on device) tests";
                break;
            }
            case UNIT_TEST: {
                prefix = "unit tests";
                break;
            }
            default: {
                throw new IllegalStateException("Unknown test variant type.");
            }
        }
        if (this.getVariantConfiguration().hasFlavors()) {
            return String.format("%s for the %s%s build", prefix, this.getCapitalizedFlavorName(), this.getCapitalizedBuildTypeName());
        }
        return String.format("%s for the %s build", prefix, this.getCapitalizedBuildTypeName());
    }

    @Override
    public boolean getZipAlignEnabled() {
        return false;
    }
}

