/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.annotations.NonNull;
import com.android.build.OutputFile;
import com.android.build.gradle.internal.annotations.ApkFile;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AbiSplitOptions;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.dsl.PackagingOptions;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantOutputScope;
import com.android.build.gradle.internal.tasks.FileSupplier;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.build.gradle.internal.tasks.ValidateSigningTask;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.build.gradle.internal.variant.ApkVariantOutputData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.tasks.ShrinkResources;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.model.SigningConfig;
import com.android.builder.packaging.DuplicateFileException;
import com.android.utils.StringHelper;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.gradle.api.Task;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.tooling.BuildException;

@ParallelizableTask
public class PackageApplication
extends IncrementalTask
implements FileSupplier {
    private File resourceFile;
    private File dexFolder;
    private Collection<File> dexedLibraries;
    private File javaResourceDir;
    private Set<File> jniFolders;
    private File mergingFolder;
    @ApkFile
    private File outputFile;
    private Set<String> abiFilters;
    private Set<File> packagedJars;
    private boolean jniDebugBuild;
    private CoreSigningConfig signingConfig;
    private PackagingOptions packagingOptions;

    @InputFile
    public File getResourceFile() {
        return this.resourceFile;
    }

    public void setResourceFile(File resourceFile) {
        this.resourceFile = resourceFile;
    }

    @InputDirectory
    public File getDexFolder() {
        return this.dexFolder;
    }

    public void setDexFolder(File dexFolder) {
        this.dexFolder = dexFolder;
    }

    @InputFiles
    public Collection<File> getDexedLibraries() {
        return this.dexedLibraries;
    }

    public void setDexedLibraries(Collection<File> dexedLibraries) {
        this.dexedLibraries = dexedLibraries;
    }

    @InputDirectory
    @Optional
    public File getJavaResourceDir() {
        return this.javaResourceDir;
    }

    public void setJavaResourceDir(File javaResourceDir) {
        this.javaResourceDir = javaResourceDir;
    }

    public Set<File> getJniFolders() {
        return this.jniFolders;
    }

    public void setJniFolders(Set<File> jniFolders) {
        this.jniFolders = jniFolders;
    }

    public File getMergingFolder() {
        return this.mergingFolder;
    }

    public void setMergingFolder(File mergingFolder) {
        this.mergingFolder = mergingFolder;
    }

    @org.gradle.api.tasks.OutputFile
    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    @Input
    @Optional
    public Set<String> getAbiFilters() {
        return this.abiFilters;
    }

    public void setAbiFilters(Set<String> abiFilters) {
        this.abiFilters = abiFilters;
    }

    @InputFiles
    public Set<File> getPackagedJars() {
        return this.packagedJars;
    }

    public void setPackagedJars(Set<File> packagedJars) {
        this.packagedJars = packagedJars;
    }

    @Input
    public boolean getJniDebugBuild() {
        return this.jniDebugBuild;
    }

    public boolean isJniDebugBuild() {
        return this.jniDebugBuild;
    }

    public void setJniDebugBuild(boolean jniDebugBuild) {
        this.jniDebugBuild = jniDebugBuild;
    }

    @Nested
    @Optional
    public CoreSigningConfig getSigningConfig() {
        return this.signingConfig;
    }

    public void setSigningConfig(CoreSigningConfig signingConfig) {
        this.signingConfig = signingConfig;
    }

    @Nested
    public PackagingOptions getPackagingOptions() {
        return this.packagingOptions;
    }

    public void setPackagingOptions(PackagingOptions packagingOptions) {
        this.packagingOptions = packagingOptions;
    }

    @InputFiles
    public FileTree getNativeLibraries() {
        FileTree src = null;
        Set<File> folders = this.getJniFolders();
        if (!folders.isEmpty()) {
            src = this.getProject().files(new Object[]{new ArrayList<File>(folders)}).getAsFileTree();
        }
        return src == null ? this.getProject().files(new Object[0]).getAsFileTree() : src;
    }

    @Override
    protected void doFullTaskAction() {
        try {
            File dir = this.getJavaResourceDir();
            this.getBuilder().packageApk(this.getResourceFile().getAbsolutePath(), this.getDexFolder(), this.getDexedLibraries(), this.getPackagedJars(), dir == null ? null : dir.getAbsolutePath(), this.getJniFolders(), this.getMergingFolder(), this.getAbiFilters(), this.getJniDebugBuild(), (SigningConfig)this.getSigningConfig(), (com.android.builder.model.PackagingOptions)this.getPackagingOptions(), this.getOutputFile().getAbsolutePath());
        }
        catch (DuplicateFileException e) {
            Logger logger = this.getLogger();
            logger.error("Error: duplicate files during packaging of APK " + this.getOutputFile().getAbsolutePath());
            logger.error("\tPath in archive: " + e.getArchivePath());
            logger.error("\tOrigin 1: " + e.getFile1());
            logger.error("\tOrigin 2: " + e.getFile2());
            logger.error("You can ignore those files in your build.gradle:");
            logger.error("\tandroid {");
            logger.error("\t  packagingOptions {");
            logger.error("\t    exclude '" + e.getArchivePath() + "'");
            logger.error("\t  }");
            logger.error("\t}");
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    public File get() {
        return this.getOutputFile();
    }

    @Override
    @NonNull
    public Task getTask() {
        return this;
    }

    public static class ConfigAction
    implements TaskConfigAction<PackageApplication> {
        private VariantOutputScope scope;

        public ConfigAction(VariantOutputScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("package");
        }

        @Override
        public Class<PackageApplication> getType() {
            return PackageApplication.class;
        }

        public void execute(PackageApplication packageApp) {
            final ApkVariantData variantData = (ApkVariantData)this.scope.getVariantScope().getVariantData();
            final ApkVariantOutputData variantOutputData = (ApkVariantOutputData)this.scope.getVariantOutputData();
            final GradleVariantConfiguration config = this.scope.getVariantScope().getVariantConfiguration();
            variantOutputData.packageApplicationTask = packageApp;
            packageApp.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            if (config.isMinifyEnabled() && ((CoreBuildType)config.getBuildType()).isShrinkResources() && !config.getUseJack()) {
                ConventionMappingHelper.map((Task)packageApp, "resourceFile", new Callable<File>(){

                    @Override
                    public File call() {
                        return ConfigAction.this.scope.getCompressedResourceFile();
                    }
                });
            } else {
                ConventionMappingHelper.map((Task)packageApp, "resourceFile", new Callable<File>(){

                    @Override
                    public File call() {
                        return variantOutputData.processResourcesTask.getPackageOutputFile();
                    }
                });
            }
            ConventionMappingHelper.map((Task)packageApp, "dexFolder", new Callable<File>(){

                @Override
                public File call() {
                    return ConfigAction.this.scope.getVariantScope().getDexOutputFolder();
                }
            });
            ConventionMappingHelper.map((Task)packageApp, "dexedLibraries", new Callable<Collection<File>>(){

                @Override
                public Collection<File> call() {
                    if (config.isMultiDexEnabled() && !config.isLegacyMultiDexMode() && variantData.preDexTask != null) {
                        return ConfigAction.this.scope.getGlobalScope().getProject().fileTree((Object)variantData.preDexTask.getOutputFolder()).getFiles();
                    }
                    return Collections.emptyList();
                }
            });
            ConventionMappingHelper.map((Task)packageApp, "packagedJars", new Callable<Set<File>>(){

                @Override
                public Set<File> call() {
                    if (config.isMinifyEnabled() && variantData.obfuscationTask != null) {
                        return variantData.obfuscationTask.getOutputs().getFiles().getFiles();
                    }
                    return ConfigAction.this.scope.getGlobalScope().getAndroidBuilder().getPackagedJars((VariantConfiguration)config);
                }
            });
            packageApp.setMergingFolder(new File(this.scope.getGlobalScope().getIntermediatesDir(), variantOutputData.getFullName() + "/merging"));
            if (!config.isMinifyEnabled()) {
                ConventionMappingHelper.map((Task)packageApp, "javaResourceDir", new Callable<File>(){

                    @Override
                    public File call() {
                        return ConfigAction.getOptionalDir(variantData.processJavaResourcesTask.getDestinationDir());
                    }
                });
            }
            ConventionMappingHelper.map((Task)packageApp, "jniFolders", new Callable<Set<File>>(){

                @Override
                public Set<File> call() {
                    if (variantData.getSplitHandlingPolicy() == BaseVariantData.SplitHandlingPolicy.PRE_21_POLICY) {
                        return ConfigAction.this.scope.getVariantScope().getJniFolders();
                    }
                    ImmutableSet<String> filters = AbiSplitOptions.getAbiFilters(ConfigAction.this.scope.getGlobalScope().getExtension().getSplits().getAbiFilters());
                    return filters.isEmpty() ? ConfigAction.this.scope.getVariantScope().getJniFolders() : Collections.emptySet();
                }
            });
            ConventionMappingHelper.map((Task)packageApp, "abiFilters", new Callable<Set<String>>(){

                @Override
                public Set<String> call() throws Exception {
                    if (variantOutputData.getMainOutputFile().getFilter(OutputFile.ABI) != null) {
                        return ImmutableSet.of((Object)variantOutputData.getMainOutputFile().getFilter(OutputFile.ABI));
                    }
                    return config.getSupportedAbis();
                }
            });
            ConventionMappingHelper.map((Task)packageApp, "jniDebugBuild", new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ((CoreBuildType)config.getBuildType()).isJniDebuggable();
                }
            });
            CoreSigningConfig sc = (CoreSigningConfig)config.getSigningConfig();
            packageApp.setSigningConfig(sc);
            if (sc != null) {
                String validateSigningTaskName = "validate" + StringHelper.capitalize((String)sc.getName()) + "Signing";
                ValidateSigningTask validateSigningTask = (ValidateSigningTask)((Object)this.scope.getGlobalScope().getProject().getTasks().findByName(validateSigningTaskName));
                if (validateSigningTask == null) {
                    validateSigningTask = (ValidateSigningTask)this.scope.getGlobalScope().getProject().getTasks().create("validate" + StringHelper.capitalize((String)sc.getName()) + "Signing", ValidateSigningTask.class);
                    validateSigningTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
                    validateSigningTask.setSigningConfig(sc);
                }
                packageApp.dependsOn(new Object[]{validateSigningTask});
            }
            ConventionMappingHelper.map((Task)packageApp, "packagingOptions", new Callable<PackagingOptions>(){

                @Override
                public PackagingOptions call() throws Exception {
                    return ConfigAction.this.scope.getGlobalScope().getExtension().getPackagingOptions();
                }
            });
            ConventionMappingHelper.map((Task)packageApp, "outputFile", new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return ConfigAction.this.scope.getPackageApk();
                }
            });
        }

        private ShrinkResources createShrinkResourcesTask(final ApkVariantOutputData variantOutputData) {
            BaseVariantData variantData = variantOutputData.variantData;
            ShrinkResources task = (ShrinkResources)this.scope.getGlobalScope().getProject().getTasks().create("shrink" + StringGroovyMethods.capitalize((String)variantOutputData.getFullName()) + "Resources", ShrinkResources.class);
            task.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            task.variantOutputData = variantOutputData;
            String outputBaseName = variantOutputData.getBaseName();
            task.setCompressedResources(new File(this.scope.getGlobalScope().getBuildDir() + "/" + "intermediates" + "/res/" + "resources-" + outputBaseName + "-stripped.ap_"));
            ConventionMappingHelper.map((Task)task, "uncompressedResources", new Callable<File>(){

                @Override
                public File call() {
                    return variantOutputData.processResourcesTask.getPackageOutputFile();
                }
            });
            task.dependsOn(new Object[]{this.scope.getVariantScope().getObfuscationTask().getName(), this.scope.getManifestProcessorTask().getName(), variantOutputData.processResourcesTask});
            return task;
        }

        private static File getOptionalDir(File dir) {
            if (dir.isDirectory()) {
                return dir;
            }
            return null;
        }
    }
}

