/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.OutputFile;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.DependencyManager;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.NdkHandler;
import com.android.build.gradle.internal.PostCompilationData;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.coverage.JacocoInstrumentTask;
import com.android.build.gradle.internal.coverage.JacocoReportTask;
import com.android.build.gradle.internal.dependency.LibraryDependencyImpl;
import com.android.build.gradle.internal.dependency.ManifestDependencyImpl;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.dsl.AbiSplitOptions;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreNdkOptions;
import com.android.build.gradle.internal.dsl.PackagingOptions;
import com.android.build.gradle.internal.publishing.ApkPublishArtifact;
import com.android.build.gradle.internal.publishing.MappingPublishArtifact;
import com.android.build.gradle.internal.publishing.MetadataPublishArtifact;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.AndroidTaskRegistry;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantOutputScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidReportTask;
import com.android.build.gradle.internal.tasks.CheckManifest;
import com.android.build.gradle.internal.tasks.DependencyReportTask;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.tasks.FileSupplier;
import com.android.build.gradle.internal.tasks.GenerateApkDataTask;
import com.android.build.gradle.internal.tasks.InstallVariantTask;
import com.android.build.gradle.internal.tasks.MockableAndroidJarTask;
import com.android.build.gradle.internal.tasks.PrepareDependenciesTask;
import com.android.build.gradle.internal.tasks.SigningReportTask;
import com.android.build.gradle.internal.tasks.SourceSetsTask;
import com.android.build.gradle.internal.tasks.TestServerTask;
import com.android.build.gradle.internal.tasks.UninstallTask;
import com.android.build.gradle.internal.tasks.multidex.CreateMainDexList;
import com.android.build.gradle.internal.tasks.multidex.CreateManifestKeepList;
import com.android.build.gradle.internal.tasks.multidex.JarMergingTask;
import com.android.build.gradle.internal.tasks.multidex.RetraceMainDexList;
import com.android.build.gradle.internal.test.TestDataImpl;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.build.gradle.internal.variant.ApkVariantOutputData;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.LibraryVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.tasks.AidlCompile;
import com.android.build.gradle.tasks.AndroidJarTask;
import com.android.build.gradle.tasks.AndroidProGuardTask;
import com.android.build.gradle.tasks.CompatibleScreensManifest;
import com.android.build.gradle.tasks.Dex;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.GenerateResValues;
import com.android.build.gradle.tasks.GenerateSplitAbiRes;
import com.android.build.gradle.tasks.JackTask;
import com.android.build.gradle.tasks.JillTask;
import com.android.build.gradle.tasks.Lint;
import com.android.build.gradle.tasks.MergeAssets;
import com.android.build.gradle.tasks.MergeManifests;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.NdkCompile;
import com.android.build.gradle.tasks.PackageApplication;
import com.android.build.gradle.tasks.PackageSplitAbi;
import com.android.build.gradle.tasks.PackageSplitRes;
import com.android.build.gradle.tasks.PreDex;
import com.android.build.gradle.tasks.PreprocessResourcesTask;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.build.gradle.tasks.ProcessManifest;
import com.android.build.gradle.tasks.ProcessTestManifest;
import com.android.build.gradle.tasks.RenderscriptCompile;
import com.android.build.gradle.tasks.ShrinkResources;
import com.android.build.gradle.tasks.SplitZipAlign;
import com.android.build.gradle.tasks.ZipAlign;
import com.android.build.gradle.tasks.factory.JavaCompileConfigAction;
import com.android.build.gradle.tasks.factory.ProGuardTaskConfigAction;
import com.android.build.gradle.tasks.factory.ProcessJavaResConfigAction;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.BuilderConstants;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.core.VariantType;
import com.android.builder.dependency.LibraryDependency;
import com.android.builder.sdk.TargetInfo;
import com.android.builder.testing.ConnectedDeviceProvider;
import com.android.builder.testing.api.DeviceProvider;
import com.android.builder.testing.api.TestServer;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.ILogger;
import com.android.utils.StringHelper;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.reporting.ConfigurableReport;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestTaskReports;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import proguard.gradle.ProGuardTask;

public abstract class TaskManager {
    public static final String FILE_JACOCO_AGENT = "jacocoagent.jar";
    public static final String DEFAULT_PROGUARD_CONFIG_FILE = "proguard-android.txt";
    public static final String DIR_BUNDLES = "bundles";
    public static final String INSTALL_GROUP = "Install";
    public static final String BUILD_GROUP = "build";
    public static final String ANDROID_GROUP = "Android";
    public static final String TEST_RUNNER_ARGS_PROP = "android.testInstrumentationRunnerArguments.";
    protected Project project;
    protected AndroidBuilder androidBuilder;
    private DependencyManager dependencyManager;
    protected SdkHandler sdkHandler;
    protected AndroidConfig extension;
    protected ToolingModelBuilderRegistry toolingRegistry;
    private final GlobalScope globalScope;
    private AndroidTaskRegistry androidTasks = new AndroidTaskRegistry();
    private Logger logger;
    protected boolean isNdkTaskNeeded = true;
    private static final String MAIN_PREBUILD = "preBuild";
    private static final String UNINSTALL_ALL = "uninstallAll";
    private static final String DEVICE_CHECK = "deviceCheck";
    protected static final String CONNECTED_CHECK = "connectedCheck";
    private static final String ASSEMBLE_ANDROID_TEST = "assembleAndroidTest";
    private static final String SOURCE_SETS = "sourceSets";
    private static final String LINT = "lint";
    protected static final String LINT_COMPILE = "compileLint";
    private Copy jacocoAgentTask;
    public MockableAndroidJarTask createMockableJar;

    public TaskManager(Project project, AndroidBuilder androidBuilder, AndroidConfig extension, SdkHandler sdkHandler, DependencyManager dependencyManager, ToolingModelBuilderRegistry toolingRegistry) {
        this.project = project;
        this.androidBuilder = androidBuilder;
        this.sdkHandler = sdkHandler;
        this.extension = extension;
        this.toolingRegistry = toolingRegistry;
        this.dependencyManager = dependencyManager;
        this.logger = Logging.getLogger(this.getClass());
        this.globalScope = new GlobalScope(project, androidBuilder, extension, sdkHandler, toolingRegistry);
    }

    private boolean isVerbose() {
        return this.project.getLogger().isEnabled(LogLevel.INFO);
    }

    private boolean isDebugLog() {
        return this.project.getLogger().isEnabled(LogLevel.DEBUG);
    }

    public abstract void createTasksForVariantData(@NonNull TaskFactory var1, @NonNull BaseVariantData<? extends BaseVariantOutputData> var2);

    public GlobalScope getGlobalScope() {
        return this.globalScope;
    }

    protected Collection<Object> getNdkBuildable(BaseVariantData variantData) {
        return Collections.singleton(variantData.ndkCompileTask);
    }

    public void configureScopeForNdk(@NonNull VariantScope scope) {
        BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        scope.setNdkSoFolder(Collections.singleton(new File(scope.getGlobalScope().getIntermediatesDir(), "ndk/" + variantData.getVariantConfiguration().getDirName() + "/lib")));
        File objFolder = new File(scope.getGlobalScope().getIntermediatesDir(), "ndk/" + variantData.getVariantConfiguration().getDirName() + "/obj");
        scope.setNdkObjFolder(objFolder);
        for (Abi abi : NdkHandler.getAbiList()) {
            scope.addNdkDebuggableLibraryFolders(abi, new File(objFolder, "local/" + abi.getName()));
        }
    }

    protected AndroidConfig getExtension() {
        return this.extension;
    }

    public void resolveDependencies(@NonNull VariantDependencies variantDeps, @Nullable VariantDependencies testedVariantDeps, @Nullable String testedProjectPath) {
        this.dependencyManager.resolveDependencies(variantDeps, testedVariantDeps, testedProjectPath);
    }

    public void createTasksBeforeEvaluate(@NonNull TaskFactory tasks) {
        tasks.create(UNINSTALL_ALL, (Action<? super Task>)new Action<Task>(){

            public void execute(Task uninstallAllTask) {
                uninstallAllTask.setDescription("Uninstall all applications.");
                uninstallAllTask.setGroup(TaskManager.INSTALL_GROUP);
            }
        });
        tasks.create(DEVICE_CHECK, (Action<? super Task>)new Action<Task>(){

            public void execute(Task deviceCheckTask) {
                deviceCheckTask.setDescription("Runs all device checks using Device Providers and Test Servers.");
                deviceCheckTask.setGroup("verification");
            }
        });
        tasks.create(CONNECTED_CHECK, (Action<? super Task>)new Action<Task>(){

            public void execute(Task connectedCheckTask) {
                connectedCheckTask.setDescription("Runs all device checks on currently connected devices.");
                connectedCheckTask.setGroup("verification");
            }
        });
        tasks.create(MAIN_PREBUILD);
        tasks.create(SOURCE_SETS, SourceSetsTask.class, new Action<SourceSetsTask>(){

            public void execute(SourceSetsTask sourceSetsTask) {
                sourceSetsTask.setConfig(TaskManager.this.extension);
                sourceSetsTask.setDescription("Prints out all the source sets defined in this project.");
                sourceSetsTask.setGroup(TaskManager.ANDROID_GROUP);
            }
        });
        tasks.create(ASSEMBLE_ANDROID_TEST, (Action<? super Task>)new Action<Task>(){

            public void execute(Task assembleAndroidTestTask) {
                assembleAndroidTestTask.setGroup(TaskManager.BUILD_GROUP);
                assembleAndroidTestTask.setDescription("Assembles all the Test applications.");
            }
        });
        tasks.create(LINT, Lint.class, new Action<Lint>(){

            public void execute(Lint lintTask) {
                lintTask.setDescription("Runs lint on all variants.");
                lintTask.setGroup("verification");
                lintTask.setLintOptions(TaskManager.this.getExtension().getLintOptions());
                lintTask.setSdkHome(TaskManager.this.sdkHandler.getSdkFolder());
                lintTask.setToolingRegistry(TaskManager.this.toolingRegistry);
            }
        });
        tasks.named("check", (Action<? super Task>)new Action<Task>(){

            public void execute(Task it) {
                it.dependsOn(new Object[]{TaskManager.LINT});
            }
        });
        this.createLintCompileTask(tasks);
    }

    public void createMockableJarTask() {
        this.createMockableJar = (MockableAndroidJarTask)this.project.getTasks().create("mockableAndroidJar", MockableAndroidJarTask.class);
        this.createMockableJar.setGroup(BUILD_GROUP);
        this.createMockableJar.setDescription("Creates a version of android.jar that's suitable for unit tests.");
        ConventionMappingHelper.map((Task)this.createMockableJar, "androidJar", new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(TaskManager.this.androidBuilder.getTarget().getPath(1));
            }
        });
        CharMatcher safeCharacters = CharMatcher.JAVA_LETTER_OR_DIGIT.or(CharMatcher.anyOf((CharSequence)"-."));
        String sdkName = safeCharacters.negate().replaceFrom((CharSequence)this.extension.getCompileSdkVersion(), '-');
        this.createMockableJar.setOutputFile(new File(this.globalScope.getIntermediatesDir(), "mockable-" + sdkName + ".jar"));
        ConventionMappingHelper.map((Task)this.createMockableJar, "returnDefaultValues", new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return TaskManager.this.extension.getTestOptions().getUnitTests().isReturnDefaultValues();
            }
        });
    }

    public void createMergeAppManifestsTask(@NonNull TaskFactory tasks, @NonNull VariantScope variantScope) {
        ApplicationVariantData appVariantData = (ApplicationVariantData)variantScope.getVariantData();
        Set<String> screenSizes = appVariantData.getCompatibleScreens();
        for (ApkVariantOutputData vod : appVariantData.getOutputs()) {
            VariantOutputScope scope = vod.getScope();
            AndroidTask<CompatibleScreensManifest> csmTask = null;
            if (vod.getMainOutputFile().getFilter(OutputFile.DENSITY) != null) {
                csmTask = this.androidTasks.create(tasks, new CompatibleScreensManifest.ConfigAction(scope, screenSizes));
                scope.setCompatibleScreensManifestTask(csmTask);
            }
            scope.setManifestProcessorTask(this.androidTasks.create(tasks, new MergeManifests.ConfigAction(scope)));
            if (csmTask == null) continue;
            scope.getManifestProcessorTask().dependsOn(tasks, csmTask);
        }
    }

    public void createMergeLibManifestsTask(@NonNull TaskFactory tasks, @NonNull VariantScope scope) {
        AndroidTask<ProcessManifest> processManifest = this.androidTasks.create(tasks, new ProcessManifest.ConfigAction(scope));
        processManifest.dependsOn(tasks, new Object[]{scope.getVariantData().prepareDependenciesTask});
        BaseVariantOutputData variantOutputData = scope.getVariantData().getOutputs().get(0);
        variantOutputData.getScope().setManifestProcessorTask(processManifest);
    }

    protected void createProcessTestManifestTask(@NonNull TaskFactory tasks, @NonNull VariantScope scope) {
        AndroidTask<ProcessTestManifest> processTestManifestTask = this.androidTasks.create(tasks, new ProcessTestManifest.ConfigAction(scope));
        processTestManifestTask.dependsOn(tasks, new Object[]{scope.getVariantData().prepareDependenciesTask});
        BaseVariantOutputData variantOutputData = scope.getVariantData().getOutputs().get(0);
        variantOutputData.getScope().setManifestProcessorTask(processTestManifestTask);
    }

    public void createRenderscriptTask(@NonNull TaskFactory tasks, @NonNull VariantScope scope) {
        scope.setRenderscriptCompileTask(this.androidTasks.create(tasks, new RenderscriptCompile.ConfigAction(scope)));
        BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        GradleVariantConfiguration config = variantData.getVariantConfiguration();
        BaseVariantOutputData variantOutputData = variantData.getOutputs().get(0);
        scope.getRenderscriptCompileTask().dependsOn(tasks, new Object[]{variantData.prepareDependenciesTask});
        if (config.getType().isForTesting()) {
            scope.getRenderscriptCompileTask().dependsOn(tasks, variantOutputData.getScope().getManifestProcessorTask());
        } else {
            scope.getRenderscriptCompileTask().dependsOn(tasks, scope.getCheckManifestTask());
        }
        scope.getResourceGenTask().dependsOn(tasks, scope.getRenderscriptCompileTask());
        if (!config.getRenderscriptNdkModeEnabled()) {
            scope.getSourceGenTask().dependsOn(tasks, scope.getRenderscriptCompileTask());
        }
    }

    public AndroidTask<MergeResources> createMergeResourcesTask(@NonNull TaskFactory tasks, @NonNull VariantScope scope) {
        return this.basicCreateMergeResourcesTask(tasks, scope, "merge", null, true, true);
    }

    public AndroidTask<MergeResources> basicCreateMergeResourcesTask(@NonNull TaskFactory tasks, @NonNull VariantScope scope, @NonNull String taskNamePrefix, @Nullable File outputLocation, boolean includeDependencies, boolean process9Patch) {
        AndroidTask<MergeResources> mergeResourcesTask = this.androidTasks.create(tasks, new MergeResources.ConfigAction(scope, taskNamePrefix, outputLocation, includeDependencies, process9Patch));
        mergeResourcesTask.dependsOn(tasks, new Object[]{scope.getVariantData().prepareDependenciesTask, scope.getResourceGenTask()});
        scope.setMergeResourcesTask(mergeResourcesTask);
        scope.setResourceOutputDir((File)Objects.firstNonNull((Object)outputLocation, (Object)scope.getDefaultMergeResourcesOutputDir()));
        return scope.getMergeResourcesTask();
    }

    public void createMergeAssetsTask(TaskFactory tasks, VariantScope scope) {
        AndroidTask<MergeAssets> mergeAssetsTask = this.androidTasks.create(tasks, new MergeAssets.ConfigAction(scope));
        mergeAssetsTask.dependsOn(tasks, new Object[]{scope.getVariantData().prepareDependenciesTask, scope.getAssetGenTask()});
        scope.setMergeAssetsTask(mergeAssetsTask);
    }

    public void createBuildConfigTask(@NonNull TaskFactory tasks, @NonNull VariantScope scope) {
        AndroidTask<GenerateBuildConfig> generateBuildConfigTask = this.androidTasks.create(tasks, new GenerateBuildConfig.ConfigAction(scope));
        scope.setGenerateBuildConfigTask(generateBuildConfigTask);
        scope.getSourceGenTask().dependsOn(tasks, generateBuildConfigTask.getName());
        if (scope.getVariantConfiguration().getType().isForTesting()) {
            BaseVariantOutputData variantOutputData = scope.getVariantData().getOutputs().get(0);
            generateBuildConfigTask.dependsOn(tasks, variantOutputData.getScope().getManifestProcessorTask());
        } else {
            generateBuildConfigTask.dependsOn(tasks, scope.getCheckManifestTask());
        }
    }

    public void createGenerateResValuesTask(@NonNull TaskFactory tasks, @NonNull VariantScope scope) {
        AndroidTask<GenerateResValues> generateResValuesTask = this.androidTasks.create(tasks, new GenerateResValues.ConfigAction(scope));
        scope.getResourceGenTask().dependsOn(tasks, generateResValuesTask);
    }

    public void createPreprocessResourcesTask(@NonNull TaskFactory tasks, final @NonNull VariantScope scope) {
        if (!"true".equals(this.project.getProperties().get("com.android.build.gradle.experimentalPreprocessResources"))) {
            return;
        }
        final BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        int minSdk = variantData.getVariantConfiguration().getMinSdkVersion().getApiLevel();
        if (this.extension.getPreprocessingOptions().getPreprocessResources() && minSdk < 21) {
            Preconditions.checkArgument((this.extension.getBuildToolsRevision().compareTo(MergeResources.NORMALIZE_RESOURCES_BUILD_TOOLS) >= 0 ? 1 : 0) != 0, (String)"To preprocess resources, you have to use build tools >= %1$s", (Object[])new Object[]{MergeResources.NORMALIZE_RESOURCES_BUILD_TOOLS});
            scope.setPreprocessResourcesTask(this.androidTasks.create(tasks, scope.getTaskName("preprocess", "Resources"), PreprocessResourcesTask.class, new Action<PreprocessResourcesTask>(){

                public void execute(PreprocessResourcesTask preprocessResourcesTask) {
                    variantData.preprocessResourcesTask = preprocessResourcesTask;
                    preprocessResourcesTask.dependsOn(new Object[]{variantData.mergeResourcesTask});
                    preprocessResourcesTask.setVariantName(variantData.getName());
                    String variantDirName = variantData.getVariantConfiguration().getDirName();
                    preprocessResourcesTask.setMergedResDirectory(scope.getMergeResourcesOutputDir());
                    preprocessResourcesTask.setGeneratedResDirectory(new File(scope.getGlobalScope().getGeneratedDir(), "res/pngs/" + variantDirName));
                    preprocessResourcesTask.setOutputResDirectory(scope.getPreprocessResourceOutputDir());
                    preprocessResourcesTask.setIncrementalFolder(new File(scope.getGlobalScope().getIntermediatesDir(), "incremental/preprocessResourcesTask/" + variantDirName));
                    preprocessResourcesTask.setDensitiesToGenerate(TaskManager.this.extension.getPreprocessingOptions().getTypedDensities());
                }
            }));
        }
    }

    public void createProcessResTask(@NonNull TaskFactory tasks, @NonNull VariantScope scope, boolean generateResourcePackage) {
        this.createProcessResTask(tasks, scope, new File(this.globalScope.getIntermediatesDir(), "symbols/" + scope.getVariantData().getVariantConfiguration().getDirName()), generateResourcePackage);
    }

    public void createProcessResTask(@NonNull TaskFactory tasks, @NonNull VariantScope scope, @Nullable File symbolLocation, boolean generateResourcePackage) {
        BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        variantData.calculateFilters(scope.getGlobalScope().getExtension().getSplits());
        for (BaseVariantOutputData baseVariantOutputData : variantData.getOutputs()) {
            VariantOutputScope variantOutputScope = baseVariantOutputData.getScope();
            variantOutputScope.setProcessResourcesTask(this.androidTasks.create(tasks, new ProcessAndroidResources.ConfigAction(variantOutputScope, symbolLocation, generateResourcePackage)));
            variantOutputScope.getProcessResourcesTask().dependsOn(tasks, variantOutputScope.getManifestProcessorTask(), scope.getMergeResourcesTask(), scope.getMergeAssetsTask());
            variantOutputScope.getProcessResourcesTask().optionalDependsOn(tasks, scope.getPreprocessResourcesTask());
            if (baseVariantOutputData.getMainOutputFile().getFilter(OutputFile.DENSITY) != null) continue;
            scope.setGenerateRClassTask(variantOutputScope.getProcessResourcesTask());
            scope.getSourceGenTask().optionalDependsOn(tasks, variantOutputScope.getProcessResourcesTask());
        }
    }

    public void createSplitResourcesTasks(@NonNull VariantScope scope) {
        BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        Preconditions.checkState((boolean)variantData.getSplitHandlingPolicy().equals((Object)BaseVariantData.SplitHandlingPolicy.RELEASE_21_AND_AFTER_POLICY), (Object)"Can only create split resources tasks for pure splits.");
        GradleVariantConfiguration config = variantData.getVariantConfiguration();
        Set<String> densityFilters = variantData.getFilters(OutputFile.FilterType.DENSITY);
        Set<String> abiFilters = variantData.getFilters(OutputFile.FilterType.ABI);
        Set<String> languageFilters = variantData.getFilters(OutputFile.FilterType.LANGUAGE);
        List<? extends BaseVariantOutputData> outputs = variantData.getOutputs();
        if (outputs.size() != 1) {
            throw new RuntimeException("In release 21 and later, there can be only one main APK, found " + outputs.size());
        }
        final BaseVariantOutputData variantOutputData = outputs.get(0);
        VariantOutputScope variantOutputScope = variantOutputData.getScope();
        variantOutputData.packageSplitResourcesTask = (PackageSplitRes)this.project.getTasks().create(scope.getTaskName("package", "SplitResources"), PackageSplitRes.class);
        variantOutputData.packageSplitResourcesTask.setInputDirectory(variantOutputScope.getProcessResourcePackageOutputFile().getParentFile());
        variantOutputData.packageSplitResourcesTask.setDensitySplits(densityFilters);
        variantOutputData.packageSplitResourcesTask.setLanguageSplits(languageFilters);
        variantOutputData.packageSplitResourcesTask.setOutputBaseName(config.getBaseName());
        variantOutputData.packageSplitResourcesTask.setSigningConfig(config.getSigningConfig());
        variantOutputData.packageSplitResourcesTask.setOutputDirectory(new File(scope.getGlobalScope().getIntermediatesDir(), "splits/" + config.getDirName()));
        variantOutputData.packageSplitResourcesTask.setAndroidBuilder(this.androidBuilder);
        variantOutputData.packageSplitResourcesTask.dependsOn(new Object[]{variantOutputScope.getProcessResourcesTask().getName()});
        SplitZipAlign zipAlign = (SplitZipAlign)this.project.getTasks().create(scope.getTaskName("zipAlign", "SplitPackages"), SplitZipAlign.class);
        ConventionMappingHelper.map((Task)zipAlign, "zipAlignExe", new Callable<File>(){

            @Override
            public File call() throws Exception {
                TargetInfo info = TaskManager.this.androidBuilder.getTargetInfo();
                if (info == null) {
                    return null;
                }
                String path = info.getBuildTools().getPath(BuildToolInfo.PathId.ZIP_ALIGN);
                if (path == null) {
                    return null;
                }
                return new File(path);
            }
        });
        zipAlign.setOutputDirectory(new File(scope.getGlobalScope().getBuildDir(), "outputs/apk"));
        ConventionMappingHelper.map((Task)zipAlign, "densityOrLanguageInputFiles", new Callable<List<File>>(){

            @Override
            public List<File> call() {
                return variantOutputData.packageSplitResourcesTask.getOutputFiles();
            }
        });
        zipAlign.setOutputBaseName(config.getBaseName());
        zipAlign.setAbiFilters(abiFilters);
        zipAlign.setLanguageFilters(languageFilters);
        zipAlign.setDensityFilters(densityFilters);
        File metadataDirectory = new File(zipAlign.getOutputDirectory().getParentFile(), "metadata");
        zipAlign.setApkMetadataFile(new File(metadataDirectory, config.getFullName() + ".mtd"));
        ((ApkVariantOutputData)variantOutputData).splitZipAlign = zipAlign;
        zipAlign.dependsOn(new Object[]{variantOutputData.packageSplitResourcesTask});
    }

    public void createSplitAbiTasks(final @NonNull VariantScope scope) {
        ApplicationVariantData variantData = (ApplicationVariantData)scope.getVariantData();
        Preconditions.checkState((boolean)variantData.getSplitHandlingPolicy().equals((Object)BaseVariantData.SplitHandlingPolicy.RELEASE_21_AND_AFTER_POLICY), (Object)"split ABI tasks are only compatible with pure splits.");
        final VariantConfiguration config = variantData.getVariantConfiguration();
        ImmutableSet<String> filters = AbiSplitOptions.getAbiFilters(this.getExtension().getSplits().getAbiFilters());
        if (filters.isEmpty()) {
            return;
        }
        List outputs = variantData.getOutputs();
        if (outputs.size() != 1) {
            throw new RuntimeException("In release 21 and later, there can be only one main APK, found " + outputs.size());
        }
        BaseVariantOutputData variantOutputData = (BaseVariantOutputData)outputs.get(0);
        GenerateSplitAbiRes generateSplitAbiRes = (GenerateSplitAbiRes)this.project.getTasks().create(scope.getTaskName("generate", "SplitAbiRes"), GenerateSplitAbiRes.class);
        generateSplitAbiRes.setAndroidBuilder(this.androidBuilder);
        generateSplitAbiRes.setOutputDirectory(new File(scope.getGlobalScope().getIntermediatesDir(), "abi/" + config.getDirName()));
        generateSplitAbiRes.setSplits((Set<String>)filters);
        generateSplitAbiRes.setOutputBaseName(config.getBaseName());
        generateSplitAbiRes.setApplicationId(config.getApplicationId());
        generateSplitAbiRes.setVersionCode(config.getVersionCode());
        generateSplitAbiRes.setVersionName(config.getVersionName());
        ConventionMappingHelper.map((Task)generateSplitAbiRes, "debuggable", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return config.getBuildType().isDebuggable();
            }
        });
        ConventionMappingHelper.map((Task)generateSplitAbiRes, "aaptOptions", new Callable<AaptOptions>(){

            @Override
            public AaptOptions call() throws Exception {
                return TaskManager.this.getExtension().getAaptOptions();
            }
        });
        generateSplitAbiRes.dependsOn(new Object[]{variantOutputData.getScope().getProcessResourcesTask().getName()});
        variantOutputData.packageSplitAbiTask = (PackageSplitAbi)this.project.getTasks().create(scope.getTaskName("package", "SplitAbi"), PackageSplitAbi.class);
        variantOutputData.packageSplitAbiTask.setInputFiles(generateSplitAbiRes.getOutputFiles());
        variantOutputData.packageSplitAbiTask.setSplits((Set<String>)filters);
        variantOutputData.packageSplitAbiTask.setOutputBaseName(config.getBaseName());
        variantOutputData.packageSplitAbiTask.setSigningConfig(config.getSigningConfig());
        variantOutputData.packageSplitAbiTask.setOutputDirectory(new File(scope.getGlobalScope().getIntermediatesDir(), "splits/" + config.getDirName()));
        variantOutputData.packageSplitAbiTask.setMergingFolder(new File(scope.getGlobalScope().getIntermediatesDir(), "package-merge/" + variantOutputData.getDirName()));
        variantOutputData.packageSplitAbiTask.setAndroidBuilder(this.androidBuilder);
        variantOutputData.packageSplitAbiTask.dependsOn(new Object[]{generateSplitAbiRes});
        variantOutputData.packageSplitAbiTask.dependsOn(new Object[]{scope.getNdkBuildable()});
        ConventionMappingHelper.map((Task)variantOutputData.packageSplitAbiTask, "jniFolders", new Callable<Set<File>>(){

            @Override
            public Set<File> call() throws Exception {
                return TaskManager.this.getJniFolders(scope);
            }
        });
        ConventionMappingHelper.map((Task)variantOutputData.packageSplitAbiTask, "jniDebuggable", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return config.getBuildType().isJniDebuggable();
            }
        });
        ConventionMappingHelper.map((Task)variantOutputData.packageSplitAbiTask, "packagingOptions", new Callable<PackagingOptions>(){

            @Override
            public PackagingOptions call() throws Exception {
                return TaskManager.this.getExtension().getPackagingOptions();
            }
        });
        ((ApkVariantOutputData)variantOutputData).splitZipAlign.getAbiInputFiles().addAll(variantOutputData.packageSplitAbiTask.getOutputFiles());
        ((ApkVariantOutputData)variantOutputData).splitZipAlign.dependsOn(new Object[]{variantOutputData.packageSplitAbiTask});
    }

    @NonNull
    public Set<File> getJniFolders(@NonNull VariantScope scope) {
        File rsLibs;
        BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        GradleVariantConfiguration config = variantData.getVariantConfiguration();
        HashSet set = Sets.newHashSet();
        TaskManager.addAllIfNotNull(set, scope.getNdkSoFolder());
        set.add(variantData.renderscriptCompileTask.getLibOutputDir());
        TaskManager.addAllIfNotNull(set, config.getLibraryJniFolders());
        TaskManager.addAllIfNotNull(set, config.getJniLibsList());
        if (Boolean.TRUE.equals(config.getMergedFlavor().getRenderscriptSupportModeEnabled()) && (rsLibs = this.androidBuilder.getSupportNativeLibFolder()) != null && rsLibs.isDirectory()) {
            set.add(rsLibs);
        }
        return set;
    }

    private static <T> void addAllIfNotNull(@NonNull Collection<T> main, @Nullable Collection<T> toAdd) {
        if (toAdd != null) {
            main.addAll(toAdd);
        }
    }

    public void createProcessJavaResTask(@NonNull TaskFactory tasks, @NonNull VariantScope scope) {
        scope.setProcessJavaResourcesTask(this.androidTasks.create(tasks, new ProcessJavaResConfigAction(scope)));
    }

    public void createAidlTask(@NonNull TaskFactory tasks, @NonNull VariantScope scope) {
        scope.setAidlCompileTask(this.androidTasks.create(tasks, new AidlCompile.ConfigAction(scope)));
        scope.getSourceGenTask().dependsOn(tasks, scope.getAidlCompileTask());
        scope.getAidlCompileTask().dependsOn(tasks, new Object[]{scope.getVariantData().prepareDependenciesTask});
    }

    public AndroidTask<JavaCompile> createJavacTask(@NonNull TaskFactory tasks, final @NonNull VariantScope scope) {
        final BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        final AndroidTask<JavaCompile> javacTask = this.androidTasks.create(tasks, new JavaCompileConfigAction(scope));
        scope.setJavacTask(javacTask);
        javacTask.optionalDependsOn(tasks, scope.getSourceGenTask());
        javacTask.dependsOn(tasks, new Object[]{scope.getVariantData().prepareDependenciesTask, scope.getProcessJavaResourcesTask()});
        javacTask.dependsOn(tasks, scope.getVariantData().getVariantDependency().getCompileConfiguration().getBuildDependencies());
        if (variantData.getType().isForTesting()) {
            BaseVariantData testedVariantData = (BaseVariantData)((Object)((TestVariantData)variantData).getTestedVariantData());
            JavaCompile testedJavacTask = testedVariantData.javacTask;
            javacTask.dependsOn(tasks, testedJavacTask != null ? testedJavacTask : testedVariantData.getScope().getJavacTask());
        }
        if (variantData.getVariantDependency().getClassesConfiguration() != null) {
            tasks.create(scope.getTaskName("package", "JarArtifact"), Jar.class, new Action<Jar>(){

                public void execute(Jar jar) {
                    variantData.classesJarTask = jar;
                    jar.dependsOn(new Object[]{javacTask.getName()});
                    jar.from(new Object[]{scope.getJavaOutputDir()});
                    jar.setDestinationDir(new File(scope.getGlobalScope().getIntermediatesDir(), "classes-jar/" + variantData.getVariantConfiguration().getDirName()));
                    jar.setArchiveName("classes.jar");
                }
            });
        }
        return javacTask;
    }

    public static void setJavaCompilerTask(@NonNull AndroidTask<? extends AbstractCompile> javaCompilerTask, @NonNull TaskFactory tasks, @NonNull VariantScope scope) {
        scope.getCompileTask().dependsOn(tasks, javaCompilerTask);
        scope.setJavaCompilerTask(javaCompilerTask);
        if (scope.getVariantData().javacTask != null) {
            scope.getVariantData().javaCompilerTask = (AbstractCompile)tasks.named(javaCompilerTask.getName());
        }
    }

    public void createGenerateMicroApkDataTask(@NonNull TaskFactory tasks, @NonNull VariantScope scope, @NonNull Configuration config) {
        AndroidTask<GenerateApkDataTask> generateMicroApkTask = this.androidTasks.create(tasks, new GenerateApkDataTask.ConfigAction(scope, config));
        generateMicroApkTask.dependsOn(tasks, config);
        scope.getResourceGenTask().dependsOn(tasks, generateMicroApkTask);
    }

    public void createNdkTasks(@NonNull VariantScope scope) {
        final BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        NdkCompile ndkCompile = (NdkCompile)this.project.getTasks().create(scope.getTaskName("compile", "Ndk"), NdkCompile.class);
        ndkCompile.dependsOn(new Object[]{variantData.preBuildTask});
        ndkCompile.setAndroidBuilder(this.androidBuilder);
        ndkCompile.setNdkDirectory(this.sdkHandler.getNdkFolder());
        ndkCompile.setIsForTesting(variantData.getType().isForTesting());
        variantData.ndkCompileTask = ndkCompile;
        variantData.compileTask.dependsOn(new Object[]{variantData.ndkCompileTask});
        final GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
        if (Boolean.TRUE.equals(variantConfig.getMergedFlavor().getRenderscriptNdkModeEnabled())) {
            ndkCompile.setNdkRenderScriptMode(true);
            ndkCompile.dependsOn(new Object[]{variantData.renderscriptCompileTask});
        } else {
            ndkCompile.setNdkRenderScriptMode(false);
        }
        ConventionMappingHelper.map((Task)ndkCompile, "sourceFolders", new Callable<List<File>>(){

            @Override
            public List<File> call() {
                List sourceList = variantConfig.getJniSourceList();
                if (Boolean.TRUE.equals(variantConfig.getMergedFlavor().getRenderscriptNdkModeEnabled())) {
                    sourceList.add(variantData.renderscriptCompileTask.getSourceOutputDir());
                }
                return sourceList;
            }
        });
        ndkCompile.setGeneratedMakefile(new File(scope.getGlobalScope().getIntermediatesDir(), "ndk/" + variantData.getVariantConfiguration().getDirName() + "/Android.mk"));
        ConventionMappingHelper.map((Task)ndkCompile, "ndkConfig", new Callable<CoreNdkOptions>(){

            @Override
            public CoreNdkOptions call() {
                return variantConfig.getNdkConfig();
            }
        });
        ConventionMappingHelper.map((Task)ndkCompile, "debuggable", new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return ((CoreBuildType)variantConfig.getBuildType()).isJniDebuggable();
            }
        });
        ndkCompile.setObjFolder(new File(scope.getGlobalScope().getIntermediatesDir(), "ndk/" + variantData.getVariantConfiguration().getDirName() + "/obj"));
        Collection<File> ndkSoFolder = scope.getNdkSoFolder();
        if (ndkSoFolder != null && !ndkSoFolder.isEmpty()) {
            ndkCompile.setSoFolder(ndkSoFolder.iterator().next());
        }
    }

    public void createUnitTestVariantTasks(@NonNull TaskFactory tasks, @NonNull TestVariantData variantData) {
        variantData.assembleVariantTask.dependsOn(new Object[]{this.createMockableJar});
        VariantScope variantScope = variantData.getScope();
        this.createPreBuildTasks(tasks, variantScope);
        this.createProcessJavaResTask(tasks, variantScope);
        this.createCompileAnchorTask(tasks, variantScope);
        AndroidTask<JavaCompile> javacTask = this.createJavacTask(tasks, variantScope);
        TaskManager.setJavaCompilerTask(javacTask, tasks, variantScope);
        this.createUnitTestTask(tasks, variantData);
        variantData.assembleVariantTask.setGroup(null);
    }

    public void createAndroidTestVariantTasks(@NonNull TaskFactory tasks, @NonNull TestVariantData variantData) {
        VariantScope variantScope = variantData.getScope();
        final BaseVariantOutputData variantOutputData = (BaseVariantOutputData)variantData.getOutputs().get(0);
        BaseVariantData baseTestedVariantData = (BaseVariantData)((Object)variantData.getTestedVariantData());
        BaseVariantOutputData testedVariantOutputData = (BaseVariantOutputData)baseTestedVariantData.getOutputs().get(0);
        this.createAnchorTasks(tasks, variantScope);
        this.createProcessTestManifestTask(tasks, variantScope);
        this.createGenerateResValuesTask(tasks, variantScope);
        this.createRenderscriptTask(tasks, variantScope);
        this.createMergeResourcesTask(tasks, variantScope);
        this.createMergeAssetsTask(tasks, variantScope);
        if (variantData.getTestedVariantData().getVariantConfiguration().getType().equals((Object)VariantType.LIBRARY) && testedVariantOutputData.assembleTask != null) {
            variantOutputData.getScope().getManifestProcessorTask().dependsOn(tasks, testedVariantOutputData.assembleTask);
            variantScope.getMergeResourcesTask().dependsOn(tasks, testedVariantOutputData.assembleTask);
        }
        this.createBuildConfigTask(tasks, variantScope);
        this.createPreprocessResourcesTask(tasks, variantScope);
        this.createProcessResTask(tasks, variantScope, true);
        this.createProcessJavaResTask(tasks, variantScope);
        this.createAidlTask(tasks, variantScope);
        if (this.isNdkTaskNeeded) {
            this.createNdkTasks(variantScope);
        }
        variantScope.setNdkBuildable(this.getNdkBuildable(variantData));
        if (variantData.getVariantConfiguration().getUseJack()) {
            this.createJackTask(tasks, variantScope);
        } else {
            AndroidTask<JavaCompile> javacTask = this.createJavacTask(tasks, variantScope);
            TaskManager.setJavaCompilerTask(javacTask, tasks, variantScope);
            this.createPostCompilationTasks(tasks, variantScope);
        }
        this.createPackagingTask(tasks, variantScope, false);
        tasks.named(ASSEMBLE_ANDROID_TEST, (Action<? super Task>)new Action<Task>(){

            public void execute(Task it) {
                it.dependsOn(new Object[]{variantOutputData.assembleTask});
            }
        });
        this.createConnectedTestForVariant(tasks, variantScope);
    }

    private void createLintCompileTask(TaskFactory tasks) {
        tasks.create(LINT_COMPILE, Task.class, new Action<Task>(){

            public void execute(Task lintCompile) {
                final File outputDir = new File(TaskManager.this.getGlobalScope().getIntermediatesDir(), TaskManager.LINT);
                lintCompile.doFirst((Action)new Action<Task>(){

                    public void execute(Task task) {
                        boolean mkdirs;
                        if (!outputDir.exists() && !(mkdirs = outputDir.mkdirs())) {
                            throw new GradleException("Unable to create lint output directory.");
                        }
                    }
                });
            }
        });
    }

    private static boolean isLintVariant(@NonNull BaseVariantData<? extends BaseVariantOutputData> baseVariantData) {
        GradleVariantConfiguration config = baseVariantData.getVariantConfiguration();
        return !config.getType().isForTesting();
    }

    public void createLintTasks(TaskFactory tasks, final VariantScope scope) {
        BaseVariantData<? extends BaseVariantOutputData> baseVariantData = scope.getVariantData();
        if (!TaskManager.isLintVariant(baseVariantData)) {
            return;
        }
        tasks.named(LINT, (Action<? super Task>)new Action<Task>(){

            public void execute(Task it) {
                it.dependsOn(new Object[]{TaskManager.LINT_COMPILE});
                it.dependsOn(new Object[]{scope.getJavacTask().getName()});
            }
        });
        AndroidTask<Lint> variantLintCheck = this.androidTasks.create(tasks, new Lint.ConfigAction(scope));
        variantLintCheck.dependsOn(tasks, LINT_COMPILE, scope.getJavacTask());
    }

    private void createLintVitalTask(@NonNull ApkVariantData variantData) {
        Preconditions.checkState((boolean)this.getExtension().getLintOptions().isCheckReleaseBuilds());
        if (!((CoreBuildType)variantData.getVariantConfiguration().getBuildType()).isDebuggable() && !variantData.getVariantConfiguration().getUseJack()) {
            String variantName = variantData.getVariantConfiguration().getFullName();
            String capitalizedVariantName = StringHelper.capitalize((String)variantName);
            String taskName = "lintVital" + capitalizedVariantName;
            final Lint lintReleaseCheck = (Lint)this.project.getTasks().create(taskName, Lint.class);
            TaskManager.optionalDependsOn((Task)lintReleaseCheck, new Task[]{variantData.javacTask});
            lintReleaseCheck.setLintOptions(this.getExtension().getLintOptions());
            lintReleaseCheck.setSdkHome((File)Preconditions.checkNotNull((Object)this.sdkHandler.getSdkFolder(), (Object)"SDK not set up."));
            lintReleaseCheck.setVariantName(variantName);
            lintReleaseCheck.setToolingRegistry(this.toolingRegistry);
            lintReleaseCheck.setFatalOnly(true);
            lintReleaseCheck.setDescription("Runs lint on just the fatal issues in the " + capitalizedVariantName + " build.");
            variantData.assembleVariantTask.dependsOn(new Object[]{lintReleaseCheck});
            this.project.getGradle().getTaskGraph().whenReady((Closure)new Closure<Void>((Object)this, (Object)this){

                public void doCall(TaskExecutionGraph taskGraph) {
                    if (taskGraph.hasTask(TaskManager.LINT)) {
                        lintReleaseCheck.setEnabled(false);
                    }
                }
            });
        }
    }

    private void createUnitTestTask(@NonNull TaskFactory tasks, @NonNull TestVariantData variantData) {
        BaseVariantData testedVariantData = (BaseVariantData)((Object)variantData.getTestedVariantData());
        final Test runTestsTask = (Test)this.project.getTasks().create(variantData.getScope().getTaskName(VariantType.UNIT_TEST.getPrefix()), Test.class);
        runTestsTask.setGroup("verification");
        runTestsTask.setDescription("Run unit tests for the " + testedVariantData.getVariantConfiguration().getFullName() + " build.");
        TaskManager.fixTestTaskSources(runTestsTask);
        runTestsTask.dependsOn(new Object[]{variantData.assembleVariantTask});
        JavaCompile testCompileTask = variantData.javacTask;
        runTestsTask.setTestClassesDir(testCompileTask.getDestinationDir());
        ConventionMappingHelper.map((Task)runTestsTask, "classpath", new Callable<ConfigurableFileCollection>((AbstractCompile)testCompileTask, variantData, testedVariantData){
            final /* synthetic */ AbstractCompile val$testCompileTask;
            final /* synthetic */ TestVariantData val$variantData;
            final /* synthetic */ BaseVariantData val$testedVariantData;
            {
                this.val$testCompileTask = abstractCompile;
                this.val$variantData = testVariantData;
                this.val$testedVariantData = baseVariantData;
            }

            @Override
            public ConfigurableFileCollection call() throws Exception {
                Iterable filteredBootClasspath = Iterables.filter((Iterable)TaskManager.this.androidBuilder.getBootClasspath(), (Predicate)new Predicate<File>(){

                    public boolean apply(@Nullable File file) {
                        return file != null && !"android.jar".equals(file.getName());
                    }
                });
                return TaskManager.this.project.files(new Object[]{this.val$testCompileTask.getClasspath(), this.val$testCompileTask.getOutputs().getFiles(), this.val$variantData.processJavaResourcesTask.getOutputs(), this.val$testedVariantData.processJavaResourcesTask.getOutputs(), filteredBootClasspath, TaskManager.this.createMockableJar.getOutputFile()});
            }
        });
        TestTaskReports testTaskReports = runTestsTask.getReports();
        for (ConfigurableReport report : new ConfigurableReport[]{testTaskReports.getJunitXml(), testTaskReports.getHtml()}) {
            report.setDestination((Object)new File(report.getDestination(), testedVariantData.getName()));
        }
        tasks.named("test", (Action<? super Task>)new Action<Task>(){

            public void execute(Task test) {
                test.dependsOn(new Object[]{runTestsTask});
            }
        });
        this.extension.getTestOptions().getUnitTests().applyConfiguration(runTestsTask);
    }

    private static void fixTestTaskSources(@NonNull Test testTask) {
        ((DefaultConfigurableFileCollection)testTask.getInputs().getSourceFiles()).getFrom().clear();
    }

    public void createTopLevelTestTasks(final TaskFactory tasks, boolean hasFlavors) {
        final ArrayList reportTasks = Lists.newArrayListWithExpectedSize((int)2);
        List<DeviceProvider> providers = this.getExtension().getDeviceProviders();
        final String connectedRootName = "connected" + VariantType.ANDROID_TEST.getSuffix();
        final String defaultReportsDir = this.getGlobalScope().getReportsDir().getAbsolutePath() + "/" + "androidTests";
        final String defaultResultsDir = this.getGlobalScope().getOutputsDir().getAbsolutePath() + "/" + BuilderConstants.FD_ANDROID_RESULTS;
        if (hasFlavors) {
            tasks.create(connectedRootName, AndroidReportTask.class, new Action<AndroidReportTask>(){

                public void execute(AndroidReportTask mainConnectedTask) {
                    mainConnectedTask.setGroup("verification");
                    mainConnectedTask.setDescription("Installs and runs instrumentation tests for all flavors on connected devices.");
                    mainConnectedTask.setReportType(ReportType.MULTI_FLAVOR);
                    ConventionMappingHelper.map((Task)mainConnectedTask, "resultsDir", new Callable<File>(){

                        @Override
                        public File call() {
                            String dir = TaskManager.this.extension.getTestOptions().getResultsDir();
                            String rootLocation = dir != null && !dir.isEmpty() ? dir : defaultResultsDir;
                            return TaskManager.this.project.file((Object)(rootLocation + "/connected/" + "all"));
                        }
                    });
                    ConventionMappingHelper.map((Task)mainConnectedTask, "reportsDir", new Callable<File>(){

                        @Override
                        public File call() {
                            String dir = TaskManager.this.extension.getTestOptions().getReportDir();
                            String rootLocation = dir != null && !dir.isEmpty() ? dir : defaultReportsDir;
                            return TaskManager.this.project.file((Object)(rootLocation + "/connected/" + "all"));
                        }
                    });
                }
            });
            reportTasks.add(connectedRootName);
        } else {
            tasks.create(connectedRootName, (Action<? super Task>)new Action<Task>(){

                public void execute(Task connectedTask) {
                    connectedTask.setGroup("verification");
                    connectedTask.setDescription("Installs and runs instrumentation tests for all flavors on connected devices.");
                }
            });
        }
        tasks.named(CONNECTED_CHECK, (Action<? super Task>)new Action<Task>(){

            public void execute(Task it) {
                it.dependsOn(new Object[]{connectedRootName});
            }
        });
        final String mainProviderTaskName = "device" + VariantType.ANDROID_TEST.getSuffix();
        if (providers.size() > 1 || hasFlavors) {
            tasks.create(mainProviderTaskName, AndroidReportTask.class, new Action<AndroidReportTask>(){

                public void execute(AndroidReportTask mainProviderTask) {
                    mainProviderTask.setGroup("verification");
                    mainProviderTask.setDescription("Installs and runs instrumentation tests using all Device Providers.");
                    mainProviderTask.setReportType(ReportType.MULTI_FLAVOR);
                    ConventionMappingHelper.map((Task)mainProviderTask, "resultsDir", new Callable<File>(){

                        @Override
                        public File call() throws Exception {
                            String dir = TaskManager.this.extension.getTestOptions().getResultsDir();
                            String rootLocation = dir != null && !dir.isEmpty() ? dir : defaultResultsDir;
                            return TaskManager.this.project.file((Object)(rootLocation + "/devices/" + "all"));
                        }
                    });
                    ConventionMappingHelper.map((Task)mainProviderTask, "reportsDir", new Callable<File>(){

                        @Override
                        public File call() throws Exception {
                            String dir = TaskManager.this.extension.getTestOptions().getReportDir();
                            String rootLocation = dir != null && !dir.isEmpty() ? dir : defaultReportsDir;
                            return TaskManager.this.project.file((Object)(rootLocation + "/devices/" + "all"));
                        }
                    });
                }
            });
            reportTasks.add(mainProviderTaskName);
        } else {
            tasks.create(mainProviderTaskName, (Action<? super Task>)new Action<Task>(){

                public void execute(Task providerTask) {
                    providerTask.setGroup("verification");
                    providerTask.setDescription("Installs and runs instrumentation tests using all Device Providers.");
                }
            });
        }
        tasks.named(DEVICE_CHECK, (Action<? super Task>)new Action<Task>(){

            public void execute(Task it) {
                it.dependsOn(new Object[]{mainProviderTaskName});
            }
        });
        tasks.create("test", (Action<? super Task>)new Action<Task>(){

            public void execute(Task unitTestTask) {
                unitTestTask.setGroup("verification");
                unitTestTask.setDescription("Run unit tests for all variants.");
            }
        });
        tasks.named("check", (Action<? super Task>)new Action<Task>(){

            public void execute(Task check) {
                check.dependsOn(new Object[]{"test"});
            }
        });
        if (!reportTasks.isEmpty() && this.project.getGradle().getStartParameter().isContinueOnFailure()) {
            this.project.getGradle().getTaskGraph().whenReady((Closure)new Closure<Void>((Object)this, (Object)this){

                public void doCall(TaskExecutionGraph taskGraph) {
                    for (String reportTask : reportTasks) {
                        if (!taskGraph.hasTask(reportTask)) continue;
                        tasks.named(reportTask, (Action<? super Task>)new Action<Task>(){

                            public void execute(Task task) {
                                ((AndroidReportTask)task).setWillRun();
                            }
                        });
                    }
                }
            });
        }
    }

    protected void createConnectedTestForVariant(@NonNull TaskFactory tasks, final @NonNull VariantScope variantScope) {
        final BaseVariantData baseVariantData = variantScope.getTestedVariantData();
        final TestVariantData testVariantData = (TestVariantData)variantScope.getVariantData();
        final BaseVariantOutputData variantOutputData = (BaseVariantOutputData)baseVariantData.getOutputs().get(0);
        final BaseVariantOutputData testVariantOutputData = (BaseVariantOutputData)testVariantData.getOutputs().get(0);
        String connectedRootName = "connected" + VariantType.ANDROID_TEST.getSuffix();
        TestDataImpl testData = new TestDataImpl(testVariantData);
        testData.setExtraInstrumentationTestRunnerArgs(this.getExtraInstrumentationTestRunnerArgsMap());
        ImmutableList artifactsTasks = ImmutableList.of((Object)((ApkVariantOutputData)testVariantData.getOutputs().get((int)0)).assembleTask, (Object)baseVariantData.assembleVariantTask);
        final AndroidTask<DeviceProviderInstrumentTestTask> connectedTask = this.androidTasks.create(tasks, new DeviceProviderInstrumentTestTask.ConfigAction(testVariantData.getScope(), (DeviceProvider)new ConnectedDeviceProvider(this.sdkHandler.getSdkInfo().getAdb(), (ILogger)new LoggerWrapper(this.logger)), testData));
        connectedTask.dependsOn(tasks, artifactsTasks);
        tasks.named(connectedRootName, (Action<? super Task>)new Action<Task>(){

            public void execute(Task it) {
                it.dependsOn(new Object[]{connectedTask.getName()});
            }
        });
        if (((CoreBuildType)baseVariantData.getVariantConfiguration().getBuildType()).isTestCoverageEnabled() && !baseVariantData.getVariantConfiguration().getUseJack()) {
            final AndroidTask<JacocoReportTask> reportTask = this.androidTasks.create(tasks, variantScope.getTaskName("create", "CoverageReport"), JacocoReportTask.class, new Action<JacocoReportTask>(){

                public void execute(JacocoReportTask reportTask) {
                    reportTask.setDescription("Creates JaCoCo test coverage report from data gathered on the device.");
                    reportTask.setReportName(baseVariantData.getVariantConfiguration().getFullName());
                    ConventionMappingHelper.map((Task)reportTask, "jacocoClasspath", new Callable<FileCollection>(){

                        @Override
                        public FileCollection call() throws Exception {
                            return TaskManager.this.project.getConfigurations().getAt("androidJacocoAnt");
                        }
                    });
                    ConventionMappingHelper.map((Task)reportTask, "coverageFile", new Callable<File>(){

                        @Override
                        public File call() {
                            return new File(((TestVariantData)testVariantData.getScope().getVariantData()).connectedTestTask.getCoverageDir(), "coverage.ec");
                        }
                    });
                    ConventionMappingHelper.map((Task)reportTask, "classDir", new Callable<File>(){

                        @Override
                        public File call() {
                            return baseVariantData.javacTask.getDestinationDir();
                        }
                    });
                    ConventionMappingHelper.map((Task)reportTask, "sourceDir", new Callable<List<File>>(){

                        @Override
                        public List<File> call() {
                            return baseVariantData.getJavaSourceFoldersForCoverage();
                        }
                    });
                    ConventionMappingHelper.map((Task)reportTask, "reportDir", new Callable<File>(){

                        @Override
                        public File call() {
                            return new File(variantScope.getGlobalScope().getReportsDir(), "/coverage/" + baseVariantData.getVariantConfiguration().getDirName());
                        }
                    });
                    reportTask.dependsOn(new Object[]{connectedTask.getName()});
                }
            });
            variantScope.setCoverageReportTask(reportTask);
            baseVariantData.getScope().getCoverageReportTask().dependsOn(tasks, reportTask);
            tasks.named(connectedRootName, (Action<? super Task>)new Action<Task>(){

                public void execute(Task it) {
                    it.dependsOn(new Object[]{reportTask.getName()});
                }
            });
        }
        String mainProviderTaskName = "device" + VariantType.ANDROID_TEST.getSuffix();
        List<DeviceProvider> providers = this.getExtension().getDeviceProviders();
        boolean hasFlavors = baseVariantData.getVariantConfiguration().hasFlavors();
        for (DeviceProvider deviceProvider : providers) {
            final AndroidTask<DeviceProviderInstrumentTestTask> providerTask = this.androidTasks.create(tasks, new DeviceProviderInstrumentTestTask.ConfigAction(testVariantData.getScope(), deviceProvider, testData));
            tasks.named(mainProviderTaskName, (Action<? super Task>)new Action<Task>(){

                public void execute(Task it) {
                    it.dependsOn(new Object[]{providerTask.getName()});
                }
            });
            providerTask.dependsOn(tasks, artifactsTasks);
        }
        List<TestServer> servers = this.getExtension().getTestServers();
        for (TestServer testServer : servers) {
            final TestServerTask serverTask = (TestServerTask)this.project.getTasks().create(hasFlavors ? baseVariantData.getScope().getTaskName(testServer.getName() + "Upload") : testServer.getName() + "Upload", TestServerTask.class);
            serverTask.setDescription("Uploads APKs for Build '" + baseVariantData.getVariantConfiguration().getFullName() + "' to Test Server '" + StringHelper.capitalize((String)testServer.getName()) + "'.");
            serverTask.setGroup("verification");
            serverTask.dependsOn(new Object[]{testVariantOutputData.assembleTask, variantOutputData.assembleTask});
            serverTask.setTestServer(testServer);
            ConventionMappingHelper.map((Task)serverTask, "testApk", new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return testVariantOutputData.getOutputFile();
                }
            });
            if (!(baseVariantData instanceof LibraryVariantData)) {
                ConventionMappingHelper.map((Task)serverTask, "testedApk", new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return variantOutputData.getOutputFile();
                    }
                });
            }
            ConventionMappingHelper.map((Task)serverTask, "variantName", new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return baseVariantData.getVariantConfiguration().getFullName();
                }
            });
            tasks.named(DEVICE_CHECK, (Action<? super Task>)new Action<Task>(){

                public void execute(Task it) {
                    it.dependsOn(new Object[]{serverTask});
                }
            });
            if (testServer.isConfigured()) continue;
            serverTask.setEnabled(false);
        }
    }

    private Map<String, String> getExtraInstrumentationTestRunnerArgsMap() {
        HashMap argsMap = Maps.newHashMap();
        for (Map.Entry entry : this.project.getProperties().entrySet()) {
            if (!((String)entry.getKey()).startsWith(TEST_RUNNER_ARGS_PROP)) continue;
            String argName = ((String)entry.getKey()).substring(TEST_RUNNER_ARGS_PROP.length());
            String argValue = entry.getValue().toString();
            argsMap.put(argName, argValue);
        }
        return argsMap;
    }

    public static void createJarTask(@NonNull TaskFactory tasks, final @NonNull VariantScope scope) {
        final BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        final GradleVariantConfiguration config = variantData.getVariantConfiguration();
        tasks.create(scope.getTaskName("jar", "Classes"), AndroidJarTask.class, new Action<AndroidJarTask>(){

            public void execute(AndroidJarTask jarTask) {
                jarTask.setArchiveName("classes.jar");
                jarTask.setDestinationDir(new File(scope.getGlobalScope().getIntermediatesDir(), "packaged/" + config.getDirName() + "/"));
                jarTask.from(new Object[]{scope.getJavaOutputDir()});
                jarTask.dependsOn(new Object[]{scope.getJavacTask().getName()});
                variantData.binayFileProviderTask = jarTask;
            }
        });
    }

    public void createPostCompilationTasks(TaskFactory tasks, final @NonNull VariantScope scope) {
        boolean isTestCoverageEnabled;
        Preconditions.checkNotNull(scope.getJavacTask());
        final ApkVariantData variantData = (ApkVariantData)scope.getVariantData();
        final GradleVariantConfiguration config = variantData.getVariantConfiguration();
        PostCompilationData pcData = new PostCompilationData();
        pcData.setClassGeneratingTasks(Collections.singletonList(scope.getJavacTask().getName()));
        pcData.setLibraryGeneratingTasks((List<?>)ImmutableList.of((Object)((Object)variantData.prepareDependenciesTask), (Object)variantData.getVariantDependency().getPackageConfiguration().getBuildDependencies()));
        pcData.setInputFilesCallable(new Callable<List<File>>(){

            @Override
            public List<File> call() {
                return new ArrayList<File>(variantData.javacTask.getOutputs().getFiles().getFiles());
            }
        });
        pcData.setInputDir(scope.getJavaOutputDir());
        pcData.setJavaResourcesInputDir(scope.getJavaResourcesDestinationDir());
        pcData.setInputLibrariesCallable(new Callable<List<File>>(){

            @Override
            public List<File> call() {
                return new ArrayList<File>(scope.getGlobalScope().getAndroidBuilder().getPackagedJars((VariantConfiguration)config));
            }
        });
        boolean bl = isTestCoverageEnabled = ((CoreBuildType)config.getBuildType()).isTestCoverageEnabled() && !config.getType().isForTesting();
        if (isTestCoverageEnabled) {
            pcData = this.createJacocoTask(tasks, scope, pcData);
        }
        boolean isTestForApp = config.getType().isForTesting() && ((TestVariantData)variantData).getTestedVariantData().getVariantConfiguration().getType().equals((Object)VariantType.DEFAULT);
        boolean isMinifyEnabled = config.isMinifyEnabled();
        boolean isMultiDexEnabled = config.isMultiDexEnabled() && !isTestForApp;
        boolean isLegacyMultiDexMode = config.isLegacyMultiDexMode();
        File outFile = this.maybeCreateProguardTasks(tasks, scope, pcData);
        if (outFile != null) {
            pcData.setInputFiles(Collections.singletonList(outFile));
            pcData.setInputLibraries(Collections.<File>emptyList());
        } else if (this.getExtension().getDexOptions().getPreDexLibraries() && !isMultiDexEnabled || isMultiDexEnabled && !isLegacyMultiDexMode) {
            AndroidTask<PreDex> preDexTask = this.androidTasks.create(tasks, new PreDex.ConfigAction(scope, pcData));
            preDexTask.dependsOn(tasks, pcData.getLibraryGeneratingTasks());
            pcData.setLibraryGeneratingTasks(Collections.singletonList(preDexTask.getName()));
            if (isMultiDexEnabled) {
                pcData.setInputLibraries(Collections.<File>emptyList());
            } else {
                pcData.setInputLibrariesCallable(new Callable<List<File>>(){

                    @Override
                    public List<File> call() {
                        return new ArrayList<File>(TaskManager.this.project.fileTree((Object)scope.getPreDexOutputDir()).getFiles());
                    }
                });
            }
        }
        AndroidTask<CreateMainDexList> createMainDexListTask = null;
        AndroidTask<RetraceMainDexList> retraceTask = null;
        if (isMultiDexEnabled && isLegacyMultiDexMode) {
            if (!isMinifyEnabled) {
                AndroidTask<JarMergingTask> jarMergingTask = this.androidTasks.create(tasks, new JarMergingTask.ConfigAction(scope, pcData));
                jarMergingTask.optionalDependsOn(tasks, pcData.getClassGeneratingTasks(), pcData.getLibraryGeneratingTasks());
                pcData.setLibraryGeneratingTasks(Collections.singletonList(jarMergingTask.getName()));
                pcData.setClassGeneratingTasks(Collections.singletonList(jarMergingTask.getName()));
                pcData.setInputFiles(Collections.singletonList(scope.getJarMergingOutputFile()));
                pcData.setInputDirCallable(null);
                pcData.setInputLibraries(Collections.<File>emptyList());
            }
            AndroidTask<CreateManifestKeepList> manifestKeepListTask = this.androidTasks.create(tasks, new CreateManifestKeepList.ConfigAction(scope, pcData));
            manifestKeepListTask.dependsOn(tasks, ((ApkVariantOutputData)variantData.getOutputs().get(0)).getScope().getManifestProcessorTask());
            AndroidTask<ProGuardTask> proguardComponentsTask = this.androidTasks.create(tasks, new ProGuardTaskConfigAction(scope, pcData));
            proguardComponentsTask.dependsOn(tasks, manifestKeepListTask);
            proguardComponentsTask.optionalDependsOn(tasks, pcData.getClassGeneratingTasks(), pcData.getLibraryGeneratingTasks());
            createMainDexListTask = this.androidTasks.create(tasks, new CreateMainDexList.ConfigAction(scope, pcData));
            createMainDexListTask.dependsOn(tasks, proguardComponentsTask);
            if (isMinifyEnabled) {
                retraceTask = this.androidTasks.create(tasks, new RetraceMainDexList.ConfigAction(scope, pcData));
                retraceTask.dependsOn(tasks, scope.getObfuscationTask(), createMainDexListTask);
            }
        }
        AndroidTask<Dex> dexTask = this.androidTasks.create(tasks, new Dex.ConfigAction(scope, pcData));
        scope.setDexTask(dexTask);
        dexTask.optionalDependsOn(tasks, pcData.getClassGeneratingTasks(), pcData.getLibraryGeneratingTasks(), createMainDexListTask, retraceTask);
    }

    public PostCompilationData createJacocoTask(@NonNull TaskFactory tasks, final @NonNull VariantScope scope, final @NonNull PostCompilationData pcData) {
        AndroidTask<JacocoInstrumentTask> jacocoTask = this.androidTasks.create(tasks, new JacocoInstrumentTask.ConfigAction(scope, pcData));
        jacocoTask.optionalDependsOn(tasks, pcData.getClassGeneratingTasks());
        final Copy agentTask = this.getJacocoAgentTask();
        jacocoTask.dependsOn(tasks, agentTask);
        PostCompilationData pcData2 = new PostCompilationData();
        pcData2.setClassGeneratingTasks(Collections.singletonList(jacocoTask.getName()));
        pcData2.setLibraryGeneratingTasks(Arrays.asList(pcData.getLibraryGeneratingTasks(), agentTask));
        pcData2.setInputFilesCallable(new Callable<List<File>>(){

            @Override
            public List<File> call() {
                return new ArrayList<File>(TaskManager.this.project.files(new Object[]{scope.getVariantData().jacocoInstrumentTask.getOutputDir()}).getFiles());
            }
        });
        pcData2.setInputDirCallable(new Callable<File>(){

            @Override
            public File call() {
                return scope.getVariantData().jacocoInstrumentTask.getOutputDir();
            }
        });
        pcData2.setInputLibrariesCallable(new Callable<List<File>>(){

            @Override
            public List<File> call() throws Exception {
                ArrayList<File> files = null;
                files = new ArrayList<File>((Collection)pcData.getInputLibrariesCallable().call());
                files.add(new File(agentTask.getDestinationDir(), TaskManager.FILE_JACOCO_AGENT));
                return files;
            }
        });
        return pcData2;
    }

    public void createJackTask(@NonNull TaskFactory tasks, @NonNull VariantScope scope) {
        GradleVariantConfiguration config = scope.getVariantData().getVariantConfiguration();
        AndroidTask<JillTask> jillRuntimeTask = this.androidTasks.create(tasks, new JillTask.RuntimeTaskConfigAction(scope));
        AndroidTask<JillTask> jillPackagedTask = this.androidTasks.create(tasks, new JillTask.PackagedConfigAction(scope));
        jillPackagedTask.dependsOn(tasks, scope.getVariantData().getVariantDependency().getPackageConfiguration().getBuildDependencies());
        AndroidTask<JackTask> jackTask = this.androidTasks.create(tasks, new JackTask.ConfigAction(scope, this.isVerbose(), this.isDebugLog()));
        TaskManager.setJavaCompilerTask(jackTask, tasks, scope);
        jackTask.dependsOn(tasks, scope.getVariantData().sourceGenTask, jillRuntimeTask, jillPackagedTask, scope.getVariantData().getVariantDependency().getCompileConfiguration().getBuildDependencies());
    }

    public void createPackagingTask(@NonNull TaskFactory tasks, @NonNull VariantScope variantScope, boolean publishApk) {
        final ApkVariantData variantData = (ApkVariantData)variantScope.getVariantData();
        GradleVariantConfiguration config = variantData.getVariantConfiguration();
        boolean signedApk = variantData.isSigned();
        File apkLocation = new File(variantScope.getGlobalScope().getApkLocation());
        boolean multiOutput = variantData.getOutputs().size() > 1;
        for (ApkVariantOutputData variantOutputData : variantData.getOutputs()) {
            VariantOutputScope variantOutputScope = variantOutputData.getScope();
            String outputName = variantOutputData.getFullName();
            AndroidTask<ShrinkResources> shrinkTask = null;
            if (config.isMinifyEnabled() && ((CoreBuildType)config.getBuildType()).isShrinkResources() && !config.getUseJack()) {
                shrinkTask = this.androidTasks.create(tasks, new ShrinkResources.ConfigAction(variantOutputScope));
                shrinkTask.dependsOn(tasks, variantScope.getObfuscationTask(), variantOutputScope.getManifestProcessorTask(), variantOutputScope.getProcessResourcesTask());
            }
            AndroidTask<PackageApplication> packageApp = this.androidTasks.create(tasks, new PackageApplication.ConfigAction(variantOutputScope));
            packageApp.dependsOn(tasks, variantOutputScope.getProcessResourcesTask(), variantOutputScope.getVariantScope().getProcessJavaResourcesTask(), variantOutputScope.getVariantScope().getNdkBuildable());
            packageApp.optionalDependsOn(tasks, new Object[]{shrinkTask, variantOutputScope.getVariantScope().getDexTask(), variantOutputScope.getVariantScope().getJavaCompilerTask(), variantData.javaCompilerTask, variantOutputData.packageSplitResourcesTask, variantOutputData.packageSplitAbiTask});
            AndroidTask<DefaultTask> appTask = packageApp;
            if (signedApk && variantData.getZipAlignEnabled()) {
                AndroidTask<ZipAlign> zipAlignTask = this.androidTasks.create(tasks, new ZipAlign.ConfigAction(variantOutputScope));
                zipAlignTask.dependsOn(tasks, packageApp);
                if (variantOutputData.splitZipAlign != null) {
                    zipAlignTask.dependsOn(tasks, new Object[]{variantOutputData.splitZipAlign});
                }
                appTask = zipAlignTask;
            }
            Preconditions.checkState((variantData.assembleVariantTask != null ? 1 : 0) != 0);
            if (multiOutput) {
                variantOutputData.assembleTask = this.createAssembleTask(variantOutputData);
                variantData.assembleVariantTask.dependsOn(new Object[]{variantOutputData.assembleTask});
            } else {
                variantOutputData.assembleTask = variantData.assembleVariantTask;
            }
            if (!signedApk && variantOutputData.packageSplitResourcesTask != null) {
                Copy copyTask = (Copy)this.project.getTasks().create(variantOutputScope.getTaskName("copySplit"), Copy.class);
                copyTask.setDestinationDir(apkLocation);
                copyTask.from(new Object[]{variantOutputData.packageSplitResourcesTask.getOutputDirectory()});
                variantOutputData.assembleTask.dependsOn(new Object[]{copyTask});
                copyTask.mustRunAfter(new Object[]{appTask.getName()});
            }
            variantOutputData.assembleTask.dependsOn(new Object[]{appTask.getName()});
            if (!publishApk) continue;
            final String projectBaseName = this.globalScope.getProjectBaseName();
            if (this.getExtension().getDefaultPublishConfig().equals(outputName)) {
                appTask.configure(tasks, new Action<Task>(){

                    public void execute(Task packageTask) {
                        TaskManager.this.project.getArtifacts().add("default", (Object)new ApkPublishArtifact(projectBaseName, null, (FileSupplier)packageTask));
                    }
                });
                for (FileSupplier outputFileProvider : variantOutputData.getSplitOutputFileSuppliers()) {
                    this.project.getArtifacts().add("default", (Object)new ApkPublishArtifact(projectBaseName, null, outputFileProvider));
                }
                try {
                    if (variantOutputData.getMetadataFile() != null) {
                        this.project.getArtifacts().add("default-metadata", (Object)new MetadataPublishArtifact(projectBaseName, null, variantOutputData.getMetadataFile()));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (variantData.getMappingFileProvider() != null) {
                    this.project.getArtifacts().add("default-mapping", (Object)new MappingPublishArtifact(projectBaseName, null, variantData.getMappingFileProvider()));
                }
            }
            if (!this.getExtension().getPublishNonDefault()) continue;
            appTask.configure(tasks, new Action<Task>(){

                public void execute(Task packageTask) {
                    TaskManager.this.project.getArtifacts().add(variantData.getVariantDependency().getPublishConfiguration().getName(), (Object)new ApkPublishArtifact(projectBaseName, null, (FileSupplier)packageTask));
                }
            });
            for (FileSupplier outputFileProvider : variantOutputData.getSplitOutputFileSuppliers()) {
                this.project.getArtifacts().add(variantData.getVariantDependency().getPublishConfiguration().getName(), (Object)new ApkPublishArtifact(projectBaseName, null, outputFileProvider));
            }
            try {
                if (variantOutputData.getMetadataFile() != null) {
                    this.project.getArtifacts().add(variantData.getVariantDependency().getMetadataConfiguration().getName(), (Object)new MetadataPublishArtifact(projectBaseName, null, variantOutputData.getMetadataFile()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (variantData.getMappingFileProvider() != null) {
                this.project.getArtifacts().add(variantData.getVariantDependency().getMappingConfiguration().getName(), (Object)new MappingPublishArtifact(projectBaseName, null, variantData.getMappingFileProvider()));
            }
            if (variantData.classesJarTask == null) continue;
            this.project.getArtifacts().add(variantData.getVariantDependency().getClassesConfiguration().getName(), (Object)variantData.classesJarTask);
        }
        if (signedApk) {
            AndroidTask<InstallVariantTask> installTask = this.androidTasks.create(tasks, new InstallVariantTask.ConfigAction(variantScope));
            installTask.dependsOn(tasks, variantData.assembleVariantTask);
        }
        if (this.getExtension().getLintOptions().isCheckReleaseBuilds()) {
            this.createLintVitalTask(variantData);
        }
        final AndroidTask<UninstallTask> uninstallTask = this.androidTasks.create(tasks, new UninstallTask.ConfigAction(variantScope));
        tasks.named(UNINSTALL_ALL, (Action<? super Task>)new Action<Task>(){

            public void execute(Task it) {
                it.dependsOn(new Object[]{uninstallTask.getName()});
            }
        });
    }

    public Task createAssembleTask(@NonNull BaseVariantOutputData variantOutputData) {
        Task assembleTask = this.project.getTasks().create(variantOutputData.getScope().getTaskName("assemble"));
        return assembleTask;
    }

    public Task createAssembleTask(TaskFactory tasks, @NonNull BaseVariantData<? extends BaseVariantOutputData> variantData) {
        Task assembleTask = this.project.getTasks().create(variantData.getScope().getTaskName("assemble"));
        return assembleTask;
    }

    public Copy getJacocoAgentTask() {
        if (this.jacocoAgentTask == null) {
            this.jacocoAgentTask = (Copy)this.project.getTasks().create("unzipJacocoAgent", Copy.class);
            this.jacocoAgentTask.from(new Object[]{new Callable<List<FileTree>>(){

                @Override
                public List<FileTree> call() throws Exception {
                    return Lists.newArrayList((Iterable)Iterables.transform((Iterable)TaskManager.this.project.getConfigurations().getByName("androidJacocoAgent"), (Function)new Function<Object, FileTree>(){

                        public FileTree apply(@Nullable Object it) {
                            return TaskManager.this.project.zipTree(it);
                        }
                    }));
                }
            }});
            this.jacocoAgentTask.include(new String[]{FILE_JACOCO_AGENT});
            this.jacocoAgentTask.into((Object)new File(this.getGlobalScope().getIntermediatesDir(), "jacoco"));
        }
        return this.jacocoAgentTask;
    }

    @NonNull
    public ZipAlign createZipAlignTask(@NonNull String name, @NonNull File inputFile, @NonNull File outputFile) {
        ZipAlign zipAlignTask = (ZipAlign)this.project.getTasks().create(name, ZipAlign.class);
        zipAlignTask.setInputFile(inputFile);
        zipAlignTask.setOutputFile(outputFile);
        ConventionMappingHelper.map((Task)zipAlignTask, "zipAlignExe", new Callable<File>(){

            @Override
            public File call() throws Exception {
                String path;
                TargetInfo info = TaskManager.this.androidBuilder.getTargetInfo();
                if (info != null && (path = info.getBuildTools().getPath(BuildToolInfo.PathId.ZIP_ALIGN)) != null) {
                    return new File(path);
                }
                return null;
            }
        });
        return zipAlignTask;
    }

    @Nullable
    public File maybeCreateProguardTasks(@NonNull TaskFactory tasks, @NonNull VariantScope scope, @NonNull PostCompilationData pcData) {
        if (!scope.getVariantData().getVariantConfiguration().isMinifyEnabled()) {
            return null;
        }
        AndroidTask<AndroidProGuardTask> proguardTask = this.androidTasks.create(tasks, new AndroidProGuardTask.ConfigAction(scope, pcData));
        scope.setObfuscationTask(proguardTask);
        proguardTask.optionalDependsOn(tasks, pcData.getClassGeneratingTasks(), pcData.getLibraryGeneratingTasks());
        pcData.setLibraryGeneratingTasks(Collections.singletonList(proguardTask.getName()));
        pcData.setClassGeneratingTasks(Collections.singletonList(proguardTask.getName()));
        return scope.getProguardOutputFile();
    }

    public void createReportTasks(List<BaseVariantData<? extends BaseVariantOutputData>> variantDataList) {
        DependencyReportTask dependencyReportTask = (DependencyReportTask)this.project.getTasks().create("androidDependencies", DependencyReportTask.class);
        dependencyReportTask.setDescription("Displays the Android dependencies of the project.");
        dependencyReportTask.setVariants(variantDataList);
        dependencyReportTask.setGroup(ANDROID_GROUP);
        SigningReportTask signingReportTask = (SigningReportTask)this.project.getTasks().create("signingReport", SigningReportTask.class);
        signingReportTask.setDescription("Displays the signing info for each variant.");
        signingReportTask.setVariants(variantDataList);
        signingReportTask.setGroup(ANDROID_GROUP);
    }

    public void createAnchorTasks(@NonNull TaskFactory tasks, @NonNull VariantScope scope) {
        this.createPreBuildTasks(tasks, scope);
        final BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        scope.setSourceGenTask(this.androidTasks.create(tasks, scope.getTaskName("generate", "Sources"), Task.class, new Action<Task>(){

            public void execute(Task task) {
                variantData.sourceGenTask = task;
            }
        }));
        scope.setResourceGenTask(this.androidTasks.create(tasks, scope.getTaskName("generate", "Resources"), Task.class, new Action<Task>(){

            public void execute(Task task) {
                variantData.resourceGenTask = task;
            }
        }));
        scope.setAssetGenTask(this.androidTasks.create(tasks, scope.getTaskName("generate", "Assets"), Task.class, new Action<Task>(){

            public void execute(Task task) {
                variantData.assetGenTask = task;
            }
        }));
        if (!variantData.getType().isForTesting() && ((CoreBuildType)variantData.getVariantConfiguration().getBuildType()).isTestCoverageEnabled()) {
            scope.setCoverageReportTask(this.androidTasks.create(tasks, scope.getTaskName("create", "CoverageReport"), Task.class, new Action<Task>(){

                public void execute(Task task) {
                    task.setGroup("verification");
                    task.setDescription(String.format("Creates test coverage reports for the %s variant.", variantData.getName()));
                }
            }));
        }
        this.createCompileAnchorTask(tasks, scope);
    }

    private void createPreBuildTasks(@NonNull TaskFactory tasks, @NonNull VariantScope scope) {
        PrepareDependenciesTask prepareDependenciesTask;
        BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        variantData.preBuildTask = this.project.getTasks().create(scope.getTaskName("pre", "Build"));
        variantData.preBuildTask.dependsOn(new Object[]{MAIN_PREBUILD});
        variantData.prepareDependenciesTask = prepareDependenciesTask = (PrepareDependenciesTask)this.project.getTasks().create(scope.getTaskName("prepare", "Dependencies"), PrepareDependenciesTask.class);
        prepareDependenciesTask.dependsOn(new Object[]{variantData.preBuildTask});
        prepareDependenciesTask.setAndroidBuilder(this.androidBuilder);
        prepareDependenciesTask.setVariant(variantData);
        VariantDependencies configurationDependencies = variantData.getVariantDependency();
        prepareDependenciesTask.addChecker(configurationDependencies.getChecker());
        for (LibraryDependencyImpl lib : configurationDependencies.getLibraries()) {
            this.dependencyManager.addDependencyToPrepareTask(variantData, prepareDependenciesTask, lib);
        }
    }

    private void createCompileAnchorTask(@NonNull TaskFactory tasks, final @NonNull VariantScope scope) {
        final BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        scope.setCompileTask(this.androidTasks.create(tasks, new TaskConfigAction<Task>(){

            @Override
            public String getName() {
                return scope.getTaskName("compile", "Sources");
            }

            @Override
            public Class<Task> getType() {
                return Task.class;
            }

            public void execute(Task task) {
                variantData.compileTask = task;
                variantData.compileTask.setGroup(TaskManager.BUILD_GROUP);
            }
        }));
        variantData.assembleVariantTask.dependsOn(new Object[]{scope.getCompileTask().getName()});
    }

    public void createCheckManifestTask(@NonNull TaskFactory tasks, @NonNull VariantScope scope) {
        final BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        final String name = variantData.getVariantConfiguration().getFullName();
        scope.setCheckManifestTask(this.androidTasks.create(tasks, scope.getTaskName("check", "Manifest"), CheckManifest.class, new Action<CheckManifest>(){

            public void execute(CheckManifest checkManifestTask) {
                variantData.checkManifestTask = checkManifestTask;
                checkManifestTask.setVariantName(name);
                ConventionMappingHelper.map((Task)checkManifestTask, "manifest", new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return variantData.getVariantConfiguration().getDefaultSourceSet().getManifestFile();
                    }
                });
            }
        }));
        scope.getCheckManifestTask().dependsOn(tasks, variantData.preBuildTask);
        variantData.prepareDependenciesTask.dependsOn(new Object[]{scope.getCheckManifestTask().getName()});
    }

    public static void optionalDependsOn(@NonNull Task main, Task ... dependencies) {
        for (Task dependency : dependencies) {
            if (dependency == null) continue;
            main.dependsOn(new Object[]{dependency});
        }
    }

    public static void optionalDependsOn(@NonNull Task main, @NonNull List<?> dependencies) {
        for (Object dependency : dependencies) {
            if (dependency == null) continue;
            main.dependsOn(new Object[]{dependency});
        }
    }

    @NonNull
    private static List<ManifestDependencyImpl> getManifestDependencies(List<LibraryDependency> libraries) {
        ArrayList list = Lists.newArrayListWithCapacity((int)libraries.size());
        for (LibraryDependency lib : libraries) {
            List<ManifestDependencyImpl> children = TaskManager.getManifestDependencies(lib.getDependencies());
            list.add(new ManifestDependencyImpl(lib.getName(), lib.getManifest(), children));
        }
        return list;
    }

    @NonNull
    protected Logger getLogger() {
        return this.logger;
    }

    @NonNull
    protected AndroidTaskRegistry getAndroidTasks() {
        return this.androidTasks;
    }

    private File getDefaultProguardFile(String name) {
        File sdkDir = this.sdkHandler.getAndCheckSdkFolder();
        return new File(sdkDir, "tools" + File.separatorChar + "proguard" + File.separatorChar + name);
    }
}

