/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.TestAndroidConfig;
import com.android.build.gradle.internal.ApplicationTaskManager;
import com.android.build.gradle.internal.DependencyManager;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.PostCompilationData;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.test.TestApplicationTestData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.LibraryVariantData;
import com.android.build.gradle.tasks.TestModuleProGuardTask;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.testing.ConnectedDeviceProvider;
import com.android.builder.testing.api.DeviceProvider;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import proguard.ParseException;

public class TestApplicationTaskManager
extends ApplicationTaskManager {
    public TestApplicationTaskManager(Project project, AndroidBuilder androidBuilder, AndroidConfig extension, SdkHandler sdkHandler, DependencyManager dependencyManager, ToolingModelBuilderRegistry toolingRegistry) {
        super(project, androidBuilder, extension, sdkHandler, dependencyManager, toolingRegistry);
    }

    @Override
    public void createTasksForVariantData(TaskFactory tasks, @NonNull BaseVariantData<? extends BaseVariantOutputData> variantData) {
        super.createTasksForVariantData(tasks, variantData);
        Configuration testTarget = (Configuration)this.project.getConfigurations().create("testTarget");
        DependencyHandler dependencyHandler = this.project.getDependencies();
        TestAndroidConfig testExtension = (TestAndroidConfig)this.extension;
        dependencyHandler.add("testTarget", (Object)dependencyHandler.project((Map)ImmutableMap.of((Object)"path", (Object)testExtension.getTargetProjectPath(), (Object)"configuration", (Object)testExtension.getTargetVariant())));
        Configuration testTargetMetadata = (Configuration)this.project.getConfigurations().create("testTargetMetadata");
        dependencyHandler.add("testTargetMetadata", (Object)dependencyHandler.project((Map)ImmutableMap.of((Object)"path", (Object)testExtension.getTargetProjectPath(), (Object)"configuration", (Object)(testExtension.getTargetVariant() + "-metadata"))));
        TestApplicationTestData testData = new TestApplicationTestData(variantData, testTarget, testTargetMetadata, this.androidBuilder);
        AndroidTask<DeviceProviderInstrumentTestTask> testConnectedCheck = this.getAndroidTasks().create(tasks, new DeviceProviderInstrumentTestTask.ConfigAction(variantData.getScope(), (DeviceProvider)new ConnectedDeviceProvider(this.sdkHandler.getSdkInfo().getAdb(), (ILogger)new LoggerWrapper(this.getLogger())), testData));
        testConnectedCheck.dependsOn(tasks, testTarget, testTargetMetadata, variantData.assembleVariantTask);
        Task connectedCheck = tasks.named("connectedCheck");
        if (connectedCheck != null) {
            connectedCheck.dependsOn(new Object[]{testConnectedCheck.getName()});
        }
    }

    @Override
    @Nullable
    public File maybeCreateProguardTasks(@NonNull TaskFactory tasks, final @NonNull VariantScope scope, @NonNull PostCompilationData pcData) {
        File outFile;
        DependencyHandler dependencyHandler = this.project.getDependencies();
        TestAndroidConfig testExtension = (TestAndroidConfig)this.extension;
        Configuration testTargetMapping = (Configuration)this.project.getConfigurations().create("testTargetMapping");
        dependencyHandler.add("testTargetMapping", (Object)dependencyHandler.project((Map)ImmutableMap.of((Object)"path", (Object)testExtension.getTargetProjectPath(), (Object)"configuration", (Object)(testExtension.getTargetVariant() + "-mapping"))));
        if (testTargetMapping.getFiles().isEmpty() || scope.getVariantConfiguration().getProvidedOnlyJars().isEmpty()) {
            return null;
        }
        BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        final TestModuleProGuardTask proguardTask = (TestModuleProGuardTask)this.project.getTasks().create(scope.getTaskName("proguard"), TestModuleProGuardTask.class);
        variantData.obfuscationTask = proguardTask;
        proguardTask.setLogger(this.getLogger());
        variantData.obfuscatedClassesJar = outFile = variantData instanceof LibraryVariantData ? this.project.file((Object)String.format("%s/%s/%s/%s/classes.jar", this.project.getBuildDir(), "intermediates", "bundles", variantData.getVariantConfiguration().getDirName())) : this.project.file((Object)String.format("%s/%s/classes-proguard/%s/classes.jar", this.project.getBuildDir(), "intermediates", variantData.getVariantConfiguration().getDirName()));
        Configuration testClassesMapping = (Configuration)this.project.getConfigurations().create("testTargetClasses");
        dependencyHandler.add("testTargetClasses", (Object)dependencyHandler.project((Map)ImmutableMap.of((Object)"path", (Object)testExtension.getTargetProjectPath(), (Object)"configuration", (Object)(testExtension.getTargetVariant() + "-classes"))));
        proguardTask.setClassesConfiguration(testClassesMapping);
        proguardTask.setMappingConfiguration(testTargetMapping);
        proguardTask.setVariantConfiguration(scope.getVariantConfiguration());
        proguardTask.dontshrink();
        proguardTask.dontoptimize();
        try {
            proguardTask.keep("class * {*;}");
            proguardTask.keep("interface * {*;}");
            proguardTask.keep("enum * {*;}");
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        proguardTask.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                for (String runtimeJar : TestApplicationTaskManager.this.androidBuilder.getBootClasspathAsStrings()) {
                    try {
                        proguardTask.libraryjars(runtimeJar);
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        try {
            proguardTask.injars(pcData.getInputDirCallable());
            if (pcData.getJavaResourcesInputDirCallable() != null) {
                proguardTask.injars(pcData.getJavaResourcesInputDirCallable());
            }
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(1);
            map.put("filter", "!META-INF/MANIFEST.MF");
            proguardTask.injars(map, new Callable<Set<File>>(){

                @Override
                public Set<File> call() throws Exception {
                    return scope.getVariantConfiguration().getPackagedJars();
                }
            });
            proguardTask.libraryjars(new Callable<List<File>>(){

                @Override
                public List<File> call() throws Exception {
                    return scope.getVariantConfiguration().getProvidedOnlyJars();
                }
            });
            proguardTask.configuration(variantData.getVariantConfiguration().getTestProguardFiles());
            proguardTask.outjars(outFile);
            final File proguardOut = this.project.file((Object)new File(this.project.getBuildDir(), "outputs" + File.separatorChar + "mapping" + File.separatorChar + variantData.getVariantConfiguration().getDirName()));
            proguardTask.dump(new File(proguardOut, "dump.txt"));
            proguardTask.printseeds(new File(proguardOut, "seeds.txt"));
            proguardTask.printusage(new File(proguardOut, "usage.txt"));
            proguardTask.printmapping(new File(proguardOut, "mapping.txt"));
            proguardTask.doFirst((Action)new Action<Task>(){

                public void execute(Task task) {
                    proguardOut.mkdirs();
                }
            });
            TestApplicationTaskManager.optionalDependsOn((Task)proguardTask, pcData.getClassGeneratingTasks());
            TestApplicationTaskManager.optionalDependsOn((Task)proguardTask, pcData.getLibraryGeneratingTasks());
            pcData.setLibraryGeneratingTasks((List<?>)ImmutableList.of((Object)((Object)proguardTask)));
            pcData.setClassGeneratingTasks((List<?>)ImmutableList.of((Object)((Object)proguardTask)));
            return outFile;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

