/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.TestAndroidConfig;
import com.android.build.gradle.TestedAndroidConfig;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ConfigurationProvider;
import com.android.build.gradle.internal.ConfigurationProviderImpl;
import com.android.build.gradle.internal.ProductFlavorCombo;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.TaskContainerAdaptor;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantModel;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.api.VariantFilter;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.profile.SpanRecorders;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SourceProvider;
import com.android.builder.profile.ExecutionType;
import com.android.builder.profile.Recorder;
import com.android.builder.profile.ThreadRecorder;
import com.android.utils.StringHelper;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.internal.reflect.Instantiator;

public class VariantManager
implements VariantModel {
    protected static final String COM_ANDROID_SUPPORT_MULTIDEX = "com.android.support:multidex:1.0.1";
    @NonNull
    private final Project project;
    @NonNull
    private final AndroidBuilder androidBuilder;
    @NonNull
    private final AndroidConfig extension;
    @NonNull
    private final VariantFactory variantFactory;
    @NonNull
    private final TaskManager taskManager;
    @NonNull
    private final Instantiator instantiator;
    @NonNull
    private ProductFlavorData<CoreProductFlavor> defaultConfigData;
    @NonNull
    private final Map<String, BuildTypeData> buildTypes = Maps.newHashMap();
    @NonNull
    private final Map<String, ProductFlavorData<CoreProductFlavor>> productFlavors = Maps.newHashMap();
    @NonNull
    private final Map<String, com.android.builder.model.SigningConfig> signingConfigs = Maps.newHashMap();
    @NonNull
    private final ReadOnlyObjectProvider readOnlyObjectProvider = new ReadOnlyObjectProvider();
    @NonNull
    private final VariantFilter variantFilter = new VariantFilter(this.readOnlyObjectProvider);
    @NonNull
    private final List<BaseVariantData<? extends BaseVariantOutputData>> variantDataList = Lists.newArrayList();
    @Nullable
    private com.android.builder.model.SigningConfig signingOverride;

    public VariantManager(@NonNull Project project, @NonNull AndroidBuilder androidBuilder, @NonNull AndroidConfig extension, @NonNull VariantFactory variantFactory, @NonNull TaskManager taskManager, @NonNull Instantiator instantiator) {
        this.extension = extension;
        this.androidBuilder = androidBuilder;
        this.project = project;
        this.variantFactory = variantFactory;
        this.taskManager = taskManager;
        this.instantiator = instantiator;
        DefaultAndroidSourceSet mainSourceSet = (DefaultAndroidSourceSet)extension.getSourceSets().getByName(extension.getDefaultConfig().getName());
        DefaultAndroidSourceSet androidTestSourceSet = null;
        DefaultAndroidSourceSet unitTestSourceSet = null;
        if (variantFactory.hasTestScope()) {
            androidTestSourceSet = (DefaultAndroidSourceSet)extension.getSourceSets().getByName(VariantType.ANDROID_TEST.getPrefix());
            unitTestSourceSet = (DefaultAndroidSourceSet)extension.getSourceSets().getByName(VariantType.UNIT_TEST.getPrefix());
        }
        this.defaultConfigData = new ProductFlavorData<CoreProductFlavor>(extension.getDefaultConfig(), mainSourceSet, androidTestSourceSet, unitTestSourceSet, project);
        this.signingOverride = this.createSigningOverride();
    }

    @Override
    @NonNull
    public ProductFlavorData<CoreProductFlavor> getDefaultConfig() {
        return this.defaultConfigData;
    }

    @Override
    @NonNull
    public Map<String, BuildTypeData> getBuildTypes() {
        return this.buildTypes;
    }

    @Override
    @NonNull
    public Map<String, ProductFlavorData<CoreProductFlavor>> getProductFlavors() {
        return this.productFlavors;
    }

    @NonNull
    public Map<String, com.android.builder.model.SigningConfig> getSigningConfigs() {
        return this.signingConfigs;
    }

    public void addSigningConfig(@NonNull com.android.builder.model.SigningConfig signingConfig) {
        this.signingConfigs.put(signingConfig.getName(), signingConfig);
    }

    public void addBuildType(@NonNull CoreBuildType buildType) {
        String name = buildType.getName();
        VariantManager.checkName(name, "BuildType");
        if (this.productFlavors.containsKey(name)) {
            throw new RuntimeException("BuildType names cannot collide with ProductFlavor names");
        }
        DefaultAndroidSourceSet mainSourceSet = (DefaultAndroidSourceSet)this.extension.getSourceSets().maybeCreate(name);
        DefaultAndroidSourceSet unitTestSourceSet = null;
        if (this.variantFactory.hasTestScope()) {
            unitTestSourceSet = (DefaultAndroidSourceSet)this.extension.getSourceSets().maybeCreate(VariantManager.computeSourceSetName(buildType.getName(), VariantType.UNIT_TEST));
        }
        BuildTypeData buildTypeData = new BuildTypeData(buildType, this.project, mainSourceSet, unitTestSourceSet);
        this.buildTypes.put(name, buildTypeData);
    }

    public void addProductFlavor(@NonNull CoreProductFlavor productFlavor) {
        String name = productFlavor.getName();
        VariantManager.checkName(name, "ProductFlavor");
        if (this.buildTypes.containsKey(name)) {
            throw new RuntimeException("ProductFlavor names cannot collide with BuildType names");
        }
        DefaultAndroidSourceSet mainSourceSet = (DefaultAndroidSourceSet)this.extension.getSourceSets().maybeCreate(productFlavor.getName());
        DefaultAndroidSourceSet androidTestSourceSet = null;
        DefaultAndroidSourceSet unitTestSourceSet = null;
        if (this.variantFactory.hasTestScope()) {
            androidTestSourceSet = (DefaultAndroidSourceSet)this.extension.getSourceSets().maybeCreate(VariantManager.computeSourceSetName(productFlavor.getName(), VariantType.ANDROID_TEST));
            unitTestSourceSet = (DefaultAndroidSourceSet)this.extension.getSourceSets().maybeCreate(VariantManager.computeSourceSetName(productFlavor.getName(), VariantType.UNIT_TEST));
        }
        ProductFlavorData<CoreProductFlavor> productFlavorData = new ProductFlavorData<CoreProductFlavor>(productFlavor, mainSourceSet, androidTestSourceSet, unitTestSourceSet, this.project);
        this.productFlavors.put(productFlavor.getName(), productFlavorData);
    }

    @NonNull
    public List<BaseVariantData<? extends BaseVariantOutputData>> getVariantDataList() {
        return this.variantDataList;
    }

    public void createAndroidTasks() {
        this.variantFactory.validateModel(this);
        this.variantFactory.preVariantWork(this.project);
        final TaskContainerAdaptor tasks = new TaskContainerAdaptor(this.project.getTasks());
        if (this.variantDataList.isEmpty()) {
            this.populateVariantDataList();
        }
        ThreadRecorder.get().record(ExecutionType.VARIANT_MANAGER_CREATE_TESTS_TASKS, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                VariantManager.this.taskManager.createTopLevelTestTasks(tasks, !VariantManager.this.productFlavors.isEmpty());
                return null;
            }
        }, new Recorder.Property[0]);
        for (final BaseVariantData<? extends BaseVariantOutputData> variantData : this.variantDataList) {
            SpanRecorders.record(this.project, ExecutionType.VARIANT_MANAGER_CREATE_TASKS_FOR_VARIANT, new Recorder.Block<Void>(){

                public Void call() throws Exception {
                    VariantManager.this.createTasksForVariantData(tasks, variantData);
                    return null;
                }
            }, new Recorder.Property("variant", variantData.getName()));
        }
        this.taskManager.createReportTasks(this.variantDataList);
    }

    private void createAssembleTaskForVariantData(TaskFactory tasks, final BaseVariantData<?> variantData) {
        if (variantData.getType().isForTesting()) {
            variantData.assembleVariantTask = this.taskManager.createAssembleTask(tasks, variantData);
        } else {
            BuildTypeData buildTypeData = this.buildTypes.get(((CoreBuildType)variantData.getVariantConfiguration().getBuildType()).getName());
            if (this.productFlavors.isEmpty()) {
                variantData.assembleVariantTask = buildTypeData.getAssembleTask();
            } else {
                variantData.assembleVariantTask = this.taskManager.createAssembleTask(tasks, variantData);
                buildTypeData.getAssembleTask().dependsOn(new Object[]{variantData.assembleVariantTask});
                GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
                for (CoreProductFlavor flavor : variantConfig.getProductFlavors()) {
                    this.productFlavors.get(flavor.getName()).getAssembleTask().dependsOn(new Object[]{variantData.assembleVariantTask});
                }
                if (variantConfig.getProductFlavors().size() > 1) {
                    final String name = StringHelper.capitalize((String)variantConfig.getFlavorName());
                    final String variantAssembleTaskName = "assemble" + name;
                    if (!tasks.containsKey(variantAssembleTaskName)) {
                        tasks.create(variantAssembleTaskName, (Action<? super Task>)new Action<Task>(){

                            public void execute(Task task) {
                                task.setDescription("Assembles all builds for flavor combination: " + name);
                                task.setGroup("Build");
                                task.dependsOn(new Object[]{variantData.assembleVariantTask});
                            }
                        });
                    }
                    tasks.named("assemble", (Action<? super Task>)new Action<Task>(){

                        public void execute(Task task) {
                            task.dependsOn(new Object[]{variantAssembleTaskName});
                        }
                    });
                }
            }
        }
    }

    public void createTasksForVariantData(TaskFactory tasks, final BaseVariantData<? extends BaseVariantOutputData> variantData) {
        tasks.named("assemble", (Action<? super Task>)new Action<Task>(){

            public void execute(Task task) {
                BuildTypeData buildTypeData = (BuildTypeData)VariantManager.this.buildTypes.get(((CoreBuildType)variantData.getVariantConfiguration().getBuildType()).getName());
                task.dependsOn(new Object[]{buildTypeData.getAssembleTask()});
            }
        });
        VariantType variantType = variantData.getType();
        this.createAssembleTaskForVariantData(tasks, variantData);
        if (variantType.isForTesting()) {
            final GradleVariantConfiguration testVariantConfig = variantData.getVariantConfiguration();
            final BaseVariantData testedVariantData = (BaseVariantData)((Object)((TestVariantData)variantData).getTestedVariantData());
            ArrayList testVariantProviders = Lists.newArrayListWithExpectedSize((int)(2 + testVariantConfig.getProductFlavors().size()));
            ConfigurationProvider buildTypeConfigurationProvider = this.buildTypes.get(((CoreBuildType)testVariantConfig.getBuildType()).getName()).getTestConfigurationProvider(variantType);
            if (buildTypeConfigurationProvider != null) {
                testVariantProviders.add(buildTypeConfigurationProvider);
            }
            for (CoreProductFlavor productFlavor : testVariantConfig.getProductFlavors()) {
                ProductFlavorData<CoreProductFlavor> data = this.productFlavors.get(productFlavor.getName());
                testVariantProviders.add(data.getTestConfigurationProvider(variantType));
            }
            testVariantProviders.add(this.defaultConfigData.getTestConfigurationProvider(variantType));
            assert (testVariantConfig.getTestedConfig() != null);
            VariantDependencies parentVariant = null;
            if (testVariantConfig.getTestedConfig().getType() == VariantType.LIBRARY) {
                parentVariant = testedVariantData.getVariantDependency();
            }
            final VariantDependencies variantDep = VariantDependencies.compute(this.project, testVariantConfig.getFullName(), false, variantType, parentVariant, testVariantProviders.toArray(new ConfigurationProvider[testVariantProviders.size()]));
            variantData.setVariantDependency(variantDep);
            SpanRecorders.record(this.project, ExecutionType.RESOLVE_DEPENDENCIES, new Recorder.Block<Void>(){

                public Void call() {
                    VariantManager.this.taskManager.resolveDependencies(variantDep, testVariantConfig.getTestedConfig().getType() == VariantType.LIBRARY ? null : testedVariantData.getVariantDependency(), null);
                    return null;
                }
            }, new Recorder.Property("variant", testVariantConfig.getFullName()));
            testVariantConfig.setDependencies(variantDep);
            switch (variantType) {
                case ANDROID_TEST: {
                    this.taskManager.createAndroidTestVariantTasks(tasks, (TestVariantData)variantData);
                    break;
                }
                case UNIT_TEST: {
                    this.taskManager.createUnitTestVariantTasks(tasks, (TestVariantData)variantData);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown test type " + variantType);
                }
            }
        } else {
            this.taskManager.createTasksForVariantData(tasks, variantData);
        }
    }

    public void populateVariantDataList() {
        if (this.productFlavors.isEmpty()) {
            this.createVariantDataForProductFlavors(Collections.<ProductFlavor>emptyList());
        } else {
            List<String> flavorDimensionList = this.extension.getFlavorDimensionList();
            Iterable flavorDsl = Iterables.transform(this.productFlavors.values(), (Function)new Function<ProductFlavorData<CoreProductFlavor>, CoreProductFlavor>(){

                public CoreProductFlavor apply(ProductFlavorData<CoreProductFlavor> data) {
                    return data.getProductFlavor();
                }
            });
            List flavorComboList = ProductFlavorCombo.createCombinations(flavorDimensionList, flavorDsl);
            for (ProductFlavorCombo flavorCombo : flavorComboList) {
                this.createVariantDataForProductFlavors(flavorCombo.getFlavorList());
            }
        }
    }

    public BaseVariantData<? extends BaseVariantOutputData> createVariantData(@NonNull BuildType buildType, @NonNull List<? extends ProductFlavor> productFlavorList) {
        BuildTypeData buildTypeData = this.buildTypes.get(buildType.getName());
        GradleVariantConfiguration variantConfig = new GradleVariantConfiguration(this.defaultConfigData.getProductFlavor(), this.defaultConfigData.getSourceSet(), buildTypeData.getBuildType(), buildTypeData.getSourceSet(), this.variantFactory.getVariantConfigurationType(), this.signingOverride);
        NamedDomainObjectContainer<AndroidSourceSet> sourceSetsContainer = this.extension.getSourceSets();
        for (ProductFlavor productFlavor : productFlavorList) {
            ProductFlavorData<CoreProductFlavor> productFlavorData = this.productFlavors.get(productFlavor.getName());
            String dimensionName = productFlavor.getDimension();
            if (dimensionName == null) {
                dimensionName = "";
            }
            variantConfig.addProductFlavor(productFlavorData.getProductFlavor(), (SourceProvider)productFlavorData.getSourceSet(), dimensionName);
        }
        VariantManager.createCompoundSourceSets(productFlavorList, variantConfig, sourceSetsContainer);
        ArrayList variantProviders = Lists.newArrayListWithExpectedSize((int)(productFlavorList.size() + 4));
        if (!productFlavorList.isEmpty()) {
            variantProviders.add(new ConfigurationProviderImpl(this.project, (DefaultAndroidSourceSet)variantConfig.getVariantSourceProvider()));
        }
        variantProviders.add(buildTypeData.getMainProvider());
        if (productFlavorList.size() > 1) {
            variantProviders.add(new ConfigurationProviderImpl(this.project, (DefaultAndroidSourceSet)variantConfig.getMultiFlavorSourceProvider()));
        }
        for (ProductFlavor productFlavor : productFlavorList) {
            variantProviders.add(this.productFlavors.get(productFlavor.getName()).getMainProvider());
        }
        variantProviders.add(this.defaultConfigData.getMainProvider());
        BaseVariantData baseVariantData = this.variantFactory.createVariantData(variantConfig, this.taskManager);
        final VariantDependencies variantDependencies = VariantDependencies.compute(this.project, variantConfig.getFullName(), this.isVariantPublished(), baseVariantData.getType(), null, variantProviders.toArray(new ConfigurationProvider[variantProviders.size()]));
        baseVariantData.setVariantDependency(variantDependencies);
        if (variantConfig.isMultiDexEnabled() && variantConfig.isLegacyMultiDexMode()) {
            this.project.getDependencies().add(variantDependencies.getCompileConfiguration().getName(), (Object)COM_ANDROID_SUPPORT_MULTIDEX);
            this.project.getDependencies().add(variantDependencies.getPackageConfiguration().getName(), (Object)COM_ANDROID_SUPPORT_MULTIDEX);
        }
        final String testedProjectPath = this.extension instanceof TestAndroidConfig ? ((TestAndroidConfig)this.extension).getTargetProjectPath() : null;
        SpanRecorders.record(this.project, ExecutionType.RESOLVE_DEPENDENCIES, new Recorder.Block<Void>(){

            public Void call() {
                VariantManager.this.taskManager.resolveDependencies(variantDependencies, null, testedProjectPath);
                return null;
            }
        }, new Recorder.Property("variant", variantConfig.getFullName()));
        variantConfig.setDependencies(variantDependencies);
        return baseVariantData;
    }

    private static void createCompoundSourceSets(@NonNull List<? extends ProductFlavor> productFlavorList, GradleVariantConfiguration variantConfig, NamedDomainObjectContainer<AndroidSourceSet> sourceSetsContainer) {
        if (!productFlavorList.isEmpty() && !variantConfig.getType().isSingleBuildType()) {
            DefaultAndroidSourceSet variantSourceSet = (DefaultAndroidSourceSet)sourceSetsContainer.maybeCreate(VariantManager.computeSourceSetName(variantConfig.getFullName(), variantConfig.getType()));
            variantConfig.setVariantSourceProvider(variantSourceSet);
        }
        if (productFlavorList.size() > 1) {
            DefaultAndroidSourceSet multiFlavorSourceSet = (DefaultAndroidSourceSet)sourceSetsContainer.maybeCreate(VariantManager.computeSourceSetName(variantConfig.getFlavorName(), variantConfig.getType()));
            variantConfig.setMultiFlavorSourceProvider(multiFlavorSourceSet);
        }
    }

    @NonNull
    private static String computeSourceSetName(@NonNull String name, @NonNull VariantType variantType) {
        if (name.endsWith(variantType.getSuffix())) {
            name = name.substring(0, name.length() - variantType.getSuffix().length());
        }
        if (!variantType.getPrefix().isEmpty()) {
            name = variantType.getPrefix() + StringHelper.capitalize((String)name);
        }
        return name;
    }

    public TestVariantData createTestVariantData(BaseVariantData testedVariantData, VariantType type) {
        CoreProductFlavor defaultConfig = this.defaultConfigData.getProductFlavor();
        CoreBuildType buildType = (CoreBuildType)testedVariantData.getVariantConfiguration().getBuildType();
        BuildTypeData buildTypeData = this.buildTypes.get(buildType.getName());
        GradleVariantConfiguration testedConfig = testedVariantData.getVariantConfiguration();
        List productFlavorList = testedConfig.getProductFlavors();
        GradleVariantConfiguration testVariantConfig = new GradleVariantConfiguration(testedVariantData.getVariantConfiguration(), defaultConfig, this.defaultConfigData.getTestSourceSet(type), buildType, buildTypeData.getTestSourceSet(type), type, this.signingOverride);
        for (CoreProductFlavor productFlavor : productFlavorList) {
            ProductFlavorData<CoreProductFlavor> data = this.productFlavors.get(productFlavor.getName());
            String dimensionName = productFlavor.getDimension();
            if (dimensionName == null) {
                dimensionName = "";
            }
            testVariantConfig.addProductFlavor(data.getProductFlavor(), (SourceProvider)data.getTestSourceSet(type), dimensionName);
        }
        VariantManager.createCompoundSourceSets(productFlavorList, testVariantConfig, this.extension.getSourceSets());
        TestVariantData testVariantData = new TestVariantData(this.extension, this.taskManager, testVariantConfig, (TestedVariantData)((Object)testedVariantData));
        ((TestedVariantData)((Object)testedVariantData)).setTestVariantData(testVariantData, type);
        return testVariantData;
    }

    private void createVariantDataForProductFlavors(@NonNull List<ProductFlavor> productFlavorList) {
        TestedAndroidConfig testedExtension;
        BuildTypeData testBuildTypeData = null;
        if (this.extension instanceof TestedAndroidConfig && (testBuildTypeData = this.buildTypes.get((testedExtension = (TestedAndroidConfig)this.extension).getTestBuildType())) == null) {
            throw new RuntimeException(String.format("Test Build Type '%1$s' does not exist.", testedExtension.getTestBuildType()));
        }
        BaseVariantData<? extends BaseVariantOutputData> variantForAndroidTest = null;
        CoreProductFlavor defaultConfig = this.defaultConfigData.getProductFlavor();
        Closure<Void> variantFilterClosure = this.extension.getVariantFilter();
        for (BuildTypeData buildTypeData : this.buildTypes.values()) {
            boolean ignore = false;
            if (variantFilterClosure != null) {
                this.variantFilter.reset(defaultConfig, buildTypeData.getBuildType(), productFlavorList);
                variantFilterClosure.call((Object)this.variantFilter);
                ignore = this.variantFilter.isIgnore();
            }
            if (ignore) continue;
            BaseVariantData<? extends BaseVariantOutputData> variantData = this.createVariantData(buildTypeData.getBuildType(), productFlavorList);
            this.variantDataList.add(variantData);
            if (!this.variantFactory.hasTestScope()) continue;
            TestVariantData unitTestVariantData = this.createTestVariantData(variantData, VariantType.UNIT_TEST);
            this.variantDataList.add(unitTestVariantData);
            if (buildTypeData != testBuildTypeData) continue;
            GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
            if (variantConfig.isMinifyEnabled() && variantConfig.getUseJack()) {
                throw new RuntimeException("Cannot test obfuscated variants when compiling with jack.");
            }
            variantForAndroidTest = variantData;
        }
        if (variantForAndroidTest != null) {
            TestVariantData androidTestVariantData = this.createTestVariantData(variantForAndroidTest, VariantType.ANDROID_TEST);
            this.variantDataList.add(androidTestVariantData);
        }
    }

    private boolean isVariantPublished() {
        return this.extension.getPublishNonDefault();
    }

    private static void checkName(@NonNull String name, @NonNull String displayName) {
        VariantManager.checkPrefix(name, displayName, VariantType.ANDROID_TEST.getPrefix());
        VariantManager.checkPrefix(name, displayName, VariantType.UNIT_TEST.getPrefix());
        if ("lint".equals(name)) {
            throw new RuntimeException(String.format("%1$s names cannot be %2$s", displayName, "lint"));
        }
    }

    private static void checkPrefix(String name, String displayName, String prefix) {
        if (name.startsWith(prefix)) {
            throw new RuntimeException(String.format("%1$s names cannot start with '%2$s'", displayName, prefix));
        }
    }

    private com.android.builder.model.SigningConfig createSigningOverride() {
        if (this.project.hasProperty("android.injected.signing.store.file") && this.project.hasProperty("android.injected.signing.store.password") && this.project.hasProperty("android.injected.signing.key.alias") && this.project.hasProperty("android.injected.signing.key.password")) {
            SigningConfig signingConfigDsl = new SigningConfig("externalOverride");
            Map props = this.project.getProperties();
            signingConfigDsl.setStoreFile(new File((String)props.get("android.injected.signing.store.file")));
            signingConfigDsl.setStorePassword((String)props.get("android.injected.signing.store.password"));
            signingConfigDsl.setKeyAlias((String)props.get("android.injected.signing.key.alias"));
            signingConfigDsl.setKeyPassword((String)props.get("android.injected.signing.key.password"));
            if (this.project.hasProperty("android.injected.signing.store.type")) {
                signingConfigDsl.setStoreType((String)props.get("android.injected.signing.store.type"));
            }
            return signingConfigDsl;
        }
        return null;
    }
}

