/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.internal.api.ImmutableFlavorList;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.tasks.AidlCompile;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.MergeAssets;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.NdkCompile;
import com.android.build.gradle.tasks.RenderscriptCompile;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SourceProvider;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Task;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;

abstract class BaseVariantImpl
implements BaseVariant {
    @NonNull
    protected AndroidBuilder androidBuilder;
    @NonNull
    protected ReadOnlyObjectProvider readOnlyObjectProvider;
    protected List<BaseVariantOutput> outputs = Lists.newArrayListWithExpectedSize((int)1);

    BaseVariantImpl(@NonNull AndroidBuilder androidBuilder, @NonNull ReadOnlyObjectProvider readOnlyObjectProvider) {
        this.androidBuilder = androidBuilder;
        this.readOnlyObjectProvider = readOnlyObjectProvider;
    }

    @NonNull
    protected abstract BaseVariantData<?> getVariantData();

    public void addOutputs(@NonNull List<BaseVariantOutput> outputs) {
        this.outputs.addAll(outputs);
    }

    @Override
    @NonNull
    public String getName() {
        return this.getVariantData().getVariantConfiguration().getFullName();
    }

    @Override
    @NonNull
    public String getDescription() {
        return this.getVariantData().getDescription();
    }

    @Override
    @NonNull
    public String getDirName() {
        return this.getVariantData().getVariantConfiguration().getDirName();
    }

    @Override
    @NonNull
    public String getBaseName() {
        return this.getVariantData().getVariantConfiguration().getBaseName();
    }

    @Override
    @NonNull
    public String getFlavorName() {
        return this.getVariantData().getVariantConfiguration().getFlavorName();
    }

    @Override
    @NonNull
    public List<BaseVariantOutput> getOutputs() {
        return this.outputs;
    }

    @Override
    @NonNull
    public BuildType getBuildType() {
        return this.readOnlyObjectProvider.getBuildType(this.getVariantData().getVariantConfiguration().getBuildType());
    }

    @Override
    @NonNull
    public List<ProductFlavor> getProductFlavors() {
        return new ImmutableFlavorList(this.getVariantData().getVariantConfiguration().getProductFlavors(), this.readOnlyObjectProvider);
    }

    @Override
    @NonNull
    public ProductFlavor getMergedFlavor() {
        return this.getVariantData().getVariantConfiguration().getMergedFlavor();
    }

    @Override
    @NonNull
    public List<SourceProvider> getSourceSets() {
        return this.getVariantData().getVariantConfiguration().getSortedSourceProviders();
    }

    @Override
    @NonNull
    public String getApplicationId() {
        return this.getVariantData().getApplicationId();
    }

    @Override
    @NonNull
    public Task getPreBuild() {
        return this.getVariantData().preBuildTask;
    }

    @Override
    @NonNull
    public Task getCheckManifest() {
        return this.getVariantData().checkManifestTask;
    }

    @Override
    @NonNull
    public AidlCompile getAidlCompile() {
        return this.getVariantData().aidlCompileTask;
    }

    @Override
    @NonNull
    public RenderscriptCompile getRenderscriptCompile() {
        return this.getVariantData().renderscriptCompileTask;
    }

    @Override
    public MergeResources getMergeResources() {
        return this.getVariantData().mergeResourcesTask;
    }

    @Override
    public MergeAssets getMergeAssets() {
        return this.getVariantData().mergeAssetsTask;
    }

    @Override
    public GenerateBuildConfig getGenerateBuildConfig() {
        return this.getVariantData().generateBuildConfigTask;
    }

    @Override
    @Nullable
    public JavaCompile getJavaCompile() {
        return this.getVariantData().javacTask;
    }

    @Override
    @NonNull
    public AbstractCompile getJavaCompiler() {
        return this.getVariantData().javaCompilerTask;
    }

    @Override
    @NonNull
    public NdkCompile getNdkCompile() {
        return this.getVariantData().ndkCompileTask;
    }

    @Override
    @Nullable
    public Task getObfuscation() {
        return this.getVariantData().obfuscationTask;
    }

    @Override
    @Nullable
    public File getMappingFile() {
        return this.getVariantData().getMappingFile();
    }

    @Override
    @NonNull
    public Copy getProcessJavaResources() {
        return this.getVariantData().processJavaResourcesTask;
    }

    @Override
    @Nullable
    public Task getAssemble() {
        return this.getVariantData().assembleVariantTask;
    }

    @Override
    public void addJavaSourceFoldersToModel(File ... generatedSourceFolders) {
        this.getVariantData().addJavaSourceFoldersToModel(generatedSourceFolders);
    }

    @Override
    public void addJavaSourceFoldersToModel(@NonNull Collection<File> generatedSourceFolders) {
        this.getVariantData().addJavaSourceFoldersToModel(generatedSourceFolders);
    }

    @Override
    public void registerJavaGeneratingTask(@NonNull Task task, File ... sourceFolders) {
        this.getVariantData().registerJavaGeneratingTask(task, sourceFolders);
    }

    @Override
    public void registerJavaGeneratingTask(@NonNull Task task, @NonNull Collection<File> sourceFolders) {
        this.getVariantData().registerJavaGeneratingTask(task, sourceFolders);
    }

    @Override
    public void registerResGeneratingTask(@NonNull Task task, File ... generatedResFolders) {
        this.getVariantData().registerResGeneratingTask(task, generatedResFolders);
    }

    @Override
    public void registerResGeneratingTask(@NonNull Task task, @NonNull Collection<File> generatedResFolders) {
        this.getVariantData().registerResGeneratingTask(task, generatedResFolders);
    }

    @Override
    public void buildConfigField(@NonNull String type, @NonNull String name, @NonNull String value) {
        this.getVariantData().getVariantConfiguration().addBuildConfigField(type, name, value);
    }

    @Override
    public void resValue(@NonNull String type, @NonNull String name, @NonNull String value) {
        this.getVariantData().getVariantConfiguration().addResValue(type, name, value);
    }

    @Override
    public void setOutputsAreSigned(boolean isSigned) {
        this.getVariantData().outputsAreSigned = isSigned;
    }

    @Override
    public boolean getOutputsAreSigned() {
        return this.getVariantData().outputsAreSigned;
    }
}

