/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.OutputFile;
import com.android.build.gradle.api.ApkOutputFile;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.google.common.collect.ImmutableList;
import java.io.File;
import org.gradle.api.Task;

public abstract class BaseVariantOutputImpl
implements BaseVariantOutput {
    @NonNull
    protected abstract BaseVariantOutputData getVariantOutputData();

    @Override
    public void setOutputFile(@NonNull File file) {
        this.getVariantOutputData().setOutputFile(file);
    }

    @Override
    @NonNull
    public File getOutputFile() {
        return this.getVariantOutputData().getOutputFile();
    }

    @NonNull
    public OutputFile getMainOutputFile() {
        return this.getVariantOutputData().getMainOutputFile();
    }

    @NonNull
    public ImmutableList<OutputFile> getOutputs() {
        ImmutableList.Builder outputFileBuilder = ImmutableList.builder();
        for (ApkOutputFile apkOutputFile : this.getVariantOutputData().getOutputs()) {
            outputFileBuilder.add((Object)apkOutputFile);
        }
        return outputFileBuilder.build();
    }

    @Override
    @NonNull
    public ProcessAndroidResources getProcessResources() {
        return this.getVariantOutputData().processResourcesTask;
    }

    @Override
    @NonNull
    public ManifestProcessorTask getProcessManifest() {
        return this.getVariantOutputData().manifestProcessorTask;
    }

    @Override
    @Nullable
    public Task getAssemble() {
        return this.getVariantOutputData().assembleTask;
    }

    @Override
    @NonNull
    public String getName() {
        return this.getVariantOutputData().getFullName();
    }

    @Override
    @NonNull
    public String getBaseName() {
        return this.getVariantOutputData().getBaseName();
    }

    @Override
    @NonNull
    public String getDirName() {
        return this.getVariantOutputData().getDirName();
    }

    @NonNull
    public File getSplitFolder() {
        return this.getOutputFile().getParentFile();
    }
}

