/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.internal.api.ReadOnlyBuildType;
import com.android.build.gradle.internal.api.ReadOnlyProductFlavor;
import com.android.build.gradle.internal.api.ReadOnlySigningConfig;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SigningConfig;
import com.google.common.collect.Maps;
import java.util.Map;

public class ReadOnlyObjectProvider {
    private ReadOnlyProductFlavor readOnlyDefaultConfig;
    @NonNull
    private final Map<BuildType, BuildType> readOnlyBuildTypes = Maps.newIdentityHashMap();
    @NonNull
    private final Map<ProductFlavor, ProductFlavor> readOnlyFlavors = Maps.newIdentityHashMap();
    @NonNull
    private final Map<SigningConfig, SigningConfig> readOnlySigningConfig = Maps.newIdentityHashMap();

    @NonNull
    ProductFlavor getDefaultConfig(@NonNull ProductFlavor defaultConfig) {
        if (this.readOnlyDefaultConfig != null) {
            if (this.readOnlyDefaultConfig.productFlavor != defaultConfig) {
                throw new IllegalStateException("Different DefaultConfigs passed to ApiObjectProvider");
            }
        } else {
            this.readOnlyDefaultConfig = new ReadOnlyProductFlavor(defaultConfig, this);
        }
        return this.readOnlyDefaultConfig;
    }

    @NonNull
    public BuildType getBuildType(@NonNull BuildType buildType) {
        BuildType readOnlyBuildType = this.readOnlyBuildTypes.get(buildType);
        if (readOnlyBuildType == null) {
            readOnlyBuildType = new ReadOnlyBuildType(buildType, this);
            this.readOnlyBuildTypes.put(buildType, readOnlyBuildType);
        }
        return readOnlyBuildType;
    }

    @NonNull
    public ProductFlavor getProductFlavor(@NonNull ProductFlavor productFlavor) {
        ProductFlavor readOnlyProductFlavor = this.readOnlyFlavors.get(productFlavor);
        if (readOnlyProductFlavor == null) {
            readOnlyProductFlavor = new ReadOnlyProductFlavor(productFlavor, this);
            this.readOnlyFlavors.put(productFlavor, readOnlyProductFlavor);
        }
        return readOnlyProductFlavor;
    }

    @Nullable
    public SigningConfig getSigningConfig(@Nullable SigningConfig signingConfig) {
        if (signingConfig == null) {
            return null;
        }
        SigningConfig readOnlySigningConfig = this.readOnlySigningConfig.get(signingConfig);
        if (readOnlySigningConfig == null) {
            readOnlySigningConfig = new ReadOnlySigningConfig(signingConfig);
            this.readOnlySigningConfig.put(signingConfig, readOnlySigningConfig);
        }
        return readOnlySigningConfig;
    }
}

