/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.internal.dependency.JarInfo;
import com.android.build.gradle.internal.dependency.LibraryDependencyImpl;
import com.android.builder.dependency.LibraryDependency;
import com.android.builder.model.MavenCoordinates;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;

public class LibInfo
extends LibraryDependencyImpl {
    @NonNull
    private final Collection<JarInfo> jarDependencies;
    private boolean mutableIsOptional = false;

    public LibInfo(@NonNull File bundle, @NonNull File explodedBundle, @NonNull List<LibraryDependency> dependencies, @NonNull Collection<JarInfo> jarDependencies, @Nullable String name, @Nullable String variantName, @Nullable String projectPath, @Nullable MavenCoordinates requestedCoordinates, @Nullable MavenCoordinates resolvedCoordinates) {
        super(bundle, explodedBundle, dependencies, name, variantName, projectPath, requestedCoordinates, resolvedCoordinates, false);
        this.jarDependencies = jarDependencies;
    }

    public void setIsOptional(boolean isOptional) {
        this.mutableIsOptional = isOptional;
        for (LibInfo libInfo : this.getLibInfoDependencies()) {
            libInfo.setIsOptional(isOptional);
        }
    }

    @Override
    public boolean isOptional() {
        return this.mutableIsOptional;
    }

    @NonNull
    public List<LibInfo> getLibInfoDependencies() {
        ImmutableList.Builder libInfoBuilder = ImmutableList.builder();
        for (LibraryDependency libraryDependency : this.getDependencies()) {
            if (libraryDependency instanceof LibInfo) {
                libInfoBuilder.add((Object)((LibInfo)libraryDependency));
                continue;
            }
            throw new RuntimeException("Mixed LibInfo and LibraryDependencies instances !");
        }
        return libInfoBuilder.build();
    }

    @NonNull
    public Collection<JarInfo> getJarDependencies() {
        return this.jarDependencies;
    }
}

