/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.annotations.NonNull;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.builder.signing.DefaultSigningConfig;
import com.android.prefs.AndroidLocation;
import com.google.common.base.Objects;
import java.io.File;
import java.io.Serializable;
import org.gradle.api.Named;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.tooling.BuildException;

public class SigningConfig
extends DefaultSigningConfig
implements Serializable,
Named,
CoreSigningConfig {
    private static final long serialVersionUID = 1L;

    public SigningConfig(@NonNull String name) {
        super(name);
        if ("debug".equals(name)) {
            try {
                this.initDebug();
            }
            catch (AndroidLocation.AndroidLocationException e) {
                throw new BuildException("Failed to get default debug keystore location", (Throwable)e);
            }
        }
    }

    public SigningConfig initWith(com.android.builder.model.SigningConfig that) {
        this.setStoreFile(that.getStoreFile());
        this.setStorePassword(that.getStorePassword());
        this.setKeyAlias(that.getKeyAlias());
        this.setKeyPassword(that.getKeyPassword());
        return this;
    }

    @Override
    @InputFile
    @Optional
    public File getStoreFile() {
        return super.getStoreFile();
    }

    @Override
    @Input
    public String getStorePassword() {
        return super.getStorePassword();
    }

    @Override
    @Input
    public String getKeyAlias() {
        return super.getKeyAlias();
    }

    @Input
    public String getKeyPassword() {
        return super.getKeyPassword();
    }

    @Override
    @Input
    public String getStoreType() {
        return super.getStoreType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SigningConfig that = (SigningConfig)o;
        return this.mName.equals(that.mName);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.mName.hashCode();
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.mName).add("storeFile", (Object)(this.getStoreFile() != null ? this.getStoreFile().getAbsolutePath() : "null")).add("storePassword", (Object)this.getStorePassword()).add("keyAlias", (Object)this.getKeyAlias()).add("keyPassword", (Object)this.getKeyPassword()).add("storeType", (Object)this.getStoreFile()).toString();
    }
}

