/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.ide.common.res2.FileStatus;
import com.android.ide.common.res2.SourceSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;

public abstract class IncrementalTask
extends BaseTask {
    private File incrementalFolder;

    public void setIncrementalFolder(File incrementalFolder) {
        this.incrementalFolder = incrementalFolder;
    }

    @OutputDirectory
    @Optional
    public File getIncrementalFolder() {
        return this.incrementalFolder;
    }

    protected boolean isIncremental() {
        return false;
    }

    protected abstract void doFullTaskAction();

    protected void doIncrementalTaskAction(Map<File, FileStatus> changedInputs) {
    }

    @TaskAction
    void taskAction(IncrementalTaskInputs inputs) {
        if (!this.isIncremental()) {
            this.doFullTaskAction();
            return;
        }
        if (!inputs.isIncremental()) {
            this.getProject().getLogger().info("Unable do incremental execution: full task run");
            this.doFullTaskAction();
            return;
        }
        final HashMap changedInputs = Maps.newHashMap();
        inputs.outOfDate((Action)new Action<InputFileDetails>(){

            public void execute(InputFileDetails change) {
                changedInputs.put(change.getFile(), change.isAdded() ? FileStatus.NEW : FileStatus.CHANGED);
            }
        });
        inputs.removed((Action)new Action<InputFileDetails>(){

            public void execute(InputFileDetails change) {
                changedInputs.put(change.getFile(), FileStatus.REMOVED);
            }
        });
        this.doIncrementalTaskAction(changedInputs);
    }

    public static List<File> flattenSourceSets(List<? extends SourceSet> resourceSets) {
        ArrayList list = Lists.newArrayList();
        for (SourceSet sourceSet : resourceSets) {
            list.addAll(sourceSet.getSourceFiles());
        }
        return list;
    }
}

