/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.annotations.NonNull;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.maven.MavenDeployer;
import org.gradle.api.plugins.MavenPlugin;
import org.gradle.api.tasks.Upload;

public class VariantHelper {
    public static void setupDefaultConfig(final @NonNull Project project, @NonNull Configuration configuration) {
        Configuration defaultConfig = project.getConfigurations().getAt("default");
        defaultConfig.setExtendsFrom(Collections.singleton(configuration));
        final Set<Configuration> flattenedConfigs = VariantHelper.flattenConfigurations(configuration);
        project.getPlugins().withType(MavenPlugin.class, (Action)new Action<MavenPlugin>(){

            public void execute(MavenPlugin mavenPlugin) {
                project.getTasks().withType(Upload.class, (Action)new Action<Upload>(){

                    public void execute(Upload upload) {
                        upload.getRepositories().withType(MavenDeployer.class, (Action)new Action<MavenDeployer>(){

                            public void execute(MavenDeployer mavenDeployer) {
                                for (Configuration config : flattenedConfigs) {
                                    mavenDeployer.getPom().getScopeMappings().addMapping(300, project.getConfigurations().getByName(config.getName()), "compile");
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    private static Set<Configuration> flattenConfigurations(@NonNull Configuration configuration) {
        HashSet configs = Sets.newHashSet();
        configs.add(configuration);
        for (Configuration extend : configuration.getExtendsFrom()) {
            configs.addAll(VariantHelper.flattenConfigurations(extend));
        }
        return configs;
    }
}

