/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.annotations.NonNull;
import com.android.build.gradle.internal.annotations.ApkFile;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantOutputScope;
import com.android.build.gradle.internal.tasks.FileSupplier;
import com.android.build.gradle.internal.variant.ApkVariantOutputData;
import com.android.build.gradle.tasks.PackageApplication;
import com.android.sdklib.BuildToolInfo;
import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecSpec;

@ParallelizableTask
public class ZipAlign
extends DefaultTask
implements FileSupplier {
    private File outputFile;
    @ApkFile
    private File inputFile;
    @ApkFile
    private File zipAlignExe;

    @OutputFile
    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    @InputFile
    public File getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    @InputFile
    public File getZipAlignExe() {
        return this.zipAlignExe;
    }

    public void setZipAlignExe(File zipAlignExe) {
        this.zipAlignExe = zipAlignExe;
    }

    @TaskAction
    public void zipAlign() {
        this.getProject().exec((Action)new Action<ExecSpec>(){

            public void execute(ExecSpec execSpec) {
                execSpec.executable((Object)ZipAlign.this.getZipAlignExe());
                execSpec.args(new Object[]{"-f", "4"});
                execSpec.args(new Object[]{ZipAlign.this.getInputFile()});
                execSpec.args(new Object[]{ZipAlign.this.getOutputFile()});
            }
        });
    }

    public File get() {
        return this.getOutputFile();
    }

    @Override
    @NonNull
    public Task getTask() {
        return this;
    }

    public static class ConfigAction
    implements TaskConfigAction<ZipAlign> {
        private final VariantOutputScope scope;

        @Override
        public String getName() {
            return this.scope.getTaskName("zipalign");
        }

        @Override
        public Class<ZipAlign> getType() {
            return ZipAlign.class;
        }

        public ConfigAction(VariantOutputScope scope) {
            this.scope = scope;
        }

        public void execute(ZipAlign zipAlign) {
            ((ApkVariantOutputData)this.scope.getVariantOutputData()).zipAlignTask = zipAlign;
            ConventionMappingHelper.map((Task)zipAlign, "inputFile", new Callable<File>(){

                @Override
                public File call() throws Exception {
                    PackageApplication packageApplicationTask = ((ApkVariantOutputData)((ConfigAction)ConfigAction.this).scope.getVariantOutputData()).packageApplicationTask;
                    return packageApplicationTask == null ? ConfigAction.this.scope.getPackageApk() : packageApplicationTask.getOutputFile();
                }
            });
            ConventionMappingHelper.map((Task)zipAlign, "outputFile", new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return ConfigAction.this.scope.getGlobalScope().getProject().file((Object)(ConfigAction.this.scope.getGlobalScope().getApkLocation() + "/" + ConfigAction.this.scope.getGlobalScope().getProjectBaseName() + "-" + ConfigAction.this.scope.getVariantOutputData().getBaseName() + ".apk"));
                }
            });
            ConventionMappingHelper.map((Task)zipAlign, "zipAlignExe", new Callable<File>(){

                @Override
                public File call() throws Exception {
                    String path = ConfigAction.this.scope.getGlobalScope().getAndroidBuilder().getTargetInfo().getBuildTools().getPath(BuildToolInfo.PathId.ZIP_ALIGN);
                    if (path != null) {
                        return new File(path);
                    }
                    return null;
                }
            });
        }
    }
}

