/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.gradle.internal.PostCompilationData;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import proguard.ParseException;
import proguard.gradle.ProGuardTask;

public class ProGuardTaskConfigAction
implements TaskConfigAction<ProGuardTask> {
    private VariantScope scope;
    private Callable<List<File>> inputFiles;

    public ProGuardTaskConfigAction(VariantScope scope, PostCompilationData pcData) {
        this.scope = scope;
        this.inputFiles = pcData.getInputFilesCallable();
    }

    @Override
    public String getName() {
        return this.scope.getTaskName("shrink", "MultiDexComponents");
    }

    @Override
    public Class<ProGuardTask> getType() {
        return ProGuardTask.class;
    }

    public void execute(ProGuardTask proguardComponentsTask) {
        proguardComponentsTask.dontobfuscate();
        proguardComponentsTask.dontoptimize();
        proguardComponentsTask.dontpreverify();
        proguardComponentsTask.dontwarn();
        proguardComponentsTask.forceprocessing();
        try {
            proguardComponentsTask.configuration((Object)this.scope.getManifestKeepListFile());
            proguardComponentsTask.libraryjars((Object)new Callable<File>(){

                @Override
                public File call() throws Exception {
                    Preconditions.checkNotNull((Object)ProGuardTaskConfigAction.this.scope.getGlobalScope().getAndroidBuilder().getTargetInfo());
                    File shrinkedAndroid = new File(ProGuardTaskConfigAction.this.scope.getGlobalScope().getAndroidBuilder().getTargetInfo().getBuildTools().getLocation(), "lib" + File.separatorChar + "shrinkedAndroid.jar");
                    if (!shrinkedAndroid.isFile()) {
                        shrinkedAndroid = new File(ProGuardTaskConfigAction.this.scope.getGlobalScope().getAndroidBuilder().getTargetInfo().getBuildTools().getLocation(), "multidex" + File.separatorChar + "shrinkedAndroid.jar");
                    }
                    return shrinkedAndroid;
                }
            });
            proguardComponentsTask.injars((Object)new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return (File)((List)ProGuardTaskConfigAction.this.inputFiles.call()).iterator().next();
                }
            });
            proguardComponentsTask.outjars((Object)this.scope.getProguardComponentsJarFile());
            proguardComponentsTask.printconfiguration((Object)(this.scope.getGlobalScope().getBuildDir() + "/" + "intermediates" + "/multi-dex/" + this.scope.getVariantConfiguration().getDirName() + "/components.flags"));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

