/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.LintGradleClient;
import com.android.build.gradle.internal.LintGradleProject;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintRequest;
import com.android.utils.Pair;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Project;

class LintGradleRequest
extends LintRequest {
    private final LintGradleClient mLintClient;
    private final Project mGradleProject;
    private final String mVariantName;
    private final AndroidProject mModelProject;

    public LintGradleRequest(LintGradleClient client, AndroidProject modelProject, Project gradleProject, String variantName, List<File> files) {
        super((LintClient)client, files);
        this.mLintClient = client;
        this.mModelProject = modelProject;
        this.mGradleProject = gradleProject;
        this.mVariantName = variantName;
    }

    public Collection<com.android.tools.lint.detector.api.Project> getProjects() {
        if (this.mProjects == null) {
            Variant variant = LintGradleRequest.findVariant(this.mModelProject, this.mVariantName);
            if (variant == null) {
                this.mProjects = Collections.emptyList();
                return this.mProjects;
            }
            Pair<LintGradleProject, List<File>> result = LintGradleProject.create(this.mLintClient, this.mModelProject, variant, this.mGradleProject);
            this.mProjects = Collections.singletonList(result.getFirst());
            this.mLintClient.setCustomRules((List)result.getSecond());
        }
        return this.mProjects;
    }

    private static Variant findVariant(AndroidProject project, String variantName) {
        if (variantName != null) {
            for (Variant variant : project.getVariants()) {
                if (!variantName.equals(variant.getName())) continue;
                return variant;
            }
        }
        if (!project.getVariants().isEmpty()) {
            return (Variant)project.getVariants().iterator().next();
        }
        return null;
    }
}

