/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.gradle.internal.TaskFactory;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Task;

public class AndroidTask<T extends Task> {
    private String name;
    private final Class<T> taskType;
    private final List<AndroidTask<? extends Task>> upstreamTasks;
    private final List<AndroidTask<? extends Task>> downstreamTasks;

    public AndroidTask(String name, Class<T> taskType) {
        this.name = name;
        this.taskType = taskType;
        this.upstreamTasks = new ArrayList<AndroidTask<? extends Task>>();
        this.downstreamTasks = new ArrayList<AndroidTask<? extends Task>>();
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getTaskType() {
        return this.taskType;
    }

    public List<AndroidTask<? extends Task>> getUpstreamTasks() {
        return this.upstreamTasks;
    }

    public List<AndroidTask<? extends Task>> getDownstreamTasks() {
        return this.downstreamTasks;
    }

    public void dependsOn(TaskFactory taskFactory, final AndroidTask<?> other) {
        taskFactory.named(this.name, (Action<? super Task>)new Action<Task>(){

            public void execute(Task task) {
                task.dependsOn(new Object[]{other.name});
            }
        });
        this.upstreamTasks.add(other);
        super.addDependent(this);
    }

    public void dependsOn(TaskFactory taskFactory, final Object ... dependencies) {
        taskFactory.named(this.name, (Action<? super Task>)new Action<Task>(){

            public void execute(Task task) {
                for (Object dependency : dependencies) {
                    if (dependency instanceof AndroidTask) {
                        task.dependsOn(new Object[]{((AndroidTask)dependency).getName()});
                        continue;
                    }
                    task.dependsOn(new Object[]{dependency});
                }
            }
        });
    }

    public void optionalDependsOn(TaskFactory taskFactory, Object ... dependencies) {
        for (Object dependency : dependencies) {
            if (dependency == null) continue;
            if (dependency instanceof AndroidTask) {
                this.dependsOn(taskFactory, ((AndroidTask)dependency).getName());
                continue;
            }
            this.dependsOn(taskFactory, dependency);
        }
    }

    public void optionalDependsOn(TaskFactory taskFactory, List<?> dependencies) {
        for (Object dependency : dependencies) {
            if (dependency == null) continue;
            this.dependsOn(taskFactory, dependency);
        }
    }

    private void addDependent(AndroidTask<? extends Task> tAndroidTask) {
        this.downstreamTasks.add(tAndroidTask);
    }

    public void configure(TaskFactory taskFactory, Action<? super Task> configAction) {
        taskFactory.named(this.name, configAction);
    }

    public T get(TaskFactory taskFactory) {
        return (T)taskFactory.named(this.name);
    }
}

