/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.Context;
import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.packaging.PackagingUtils;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class ExtractJarsTransform
extends Transform {
    private final Set<QualifiedContent.ContentType> contentTypes;
    private final Set<QualifiedContent.Scope> scopes;

    public ExtractJarsTransform(Set<QualifiedContent.ContentType> contentTypes, Set<QualifiedContent.Scope> scopes) {
        this.contentTypes = contentTypes;
        this.scopes = scopes;
    }

    public String getName() {
        return "extractJars";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return this.contentTypes;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return this.scopes;
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(Context context, Collection<TransformInput> inputs, Collection<TransformInput> referencedInputs, TransformOutputProvider outputProvider, boolean isIncremental) throws IOException, TransformException, InterruptedException {
        Preconditions.checkNotNull((Object)outputProvider, (Object)("Missing output object for transform " + this.getName()));
        final boolean extractCode = this.contentTypes.contains(QualifiedContent.DefaultContentType.CLASSES);
        Logger logger = Logging.getLogger(ExtractJarsTransform.class);
        if (!isIncremental) {
            outputProvider.deleteAll();
        }
        try {
            WaitableExecutor executor = new WaitableExecutor();
            for (TransformInput input : inputs) {
                if (!input.getDirectoryInputs().isEmpty()) {
                    for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
                        logger.warn("Extract Jars input contains folder. Ignoring: " + directoryInput.getFile());
                    }
                }
                for (JarInput jarInput : input.getJarInputs()) {
                    final File jarFile = jarInput.getFile();
                    final File outJarFolder = outputProvider.getContentLocation(jarFile.getName() + "-" + jarFile.getPath().hashCode(), jarInput.getContentTypes(), jarInput.getScopes(), Format.DIRECTORY);
                    FileUtils.mkdirs((File)outJarFolder);
                    if (!isIncremental) {
                        executor.execute((Callable)new Callable<Void>(){

                            @Override
                            public Void call() throws Exception {
                                ExtractJarsTransform.extractJar(outJarFolder, jarFile, extractCode);
                                return null;
                            }
                        });
                        continue;
                    }
                    switch (jarInput.getStatus()) {
                        case CHANGED: {
                            executor.execute((Callable)new Callable<Void>(){

                                @Override
                                public Void call() throws Exception {
                                    FileUtils.emptyFolder((File)outJarFolder);
                                    ExtractJarsTransform.extractJar(outJarFolder, jarFile, extractCode);
                                    return null;
                                }
                            });
                            break;
                        }
                        case ADDED: {
                            executor.execute((Callable)new Callable<Void>(){

                                @Override
                                public Void call() throws Exception {
                                    ExtractJarsTransform.extractJar(outJarFolder, jarFile, extractCode);
                                    return null;
                                }
                            });
                            break;
                        }
                        case REMOVED: {
                            executor.execute((Callable)new Callable<Void>(){

                                @Override
                                public Void call() throws Exception {
                                    FileUtils.delete((File)outJarFolder);
                                    return null;
                                }
                            });
                        }
                    }
                }
            }
            executor.waitForTasksWithQuickFail(true);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransformException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractJar(File outJarFolder, File jarFile, boolean extractCode) throws IOException {
        FileUtils.mkdirs((File)outJarFolder);
        Closer closer = Closer.create();
        try {
            ZipEntry entry;
            FileInputStream fis = (FileInputStream)closer.register((Closeable)new FileInputStream(jarFile));
            ZipInputStream zis = (ZipInputStream)closer.register((Closeable)new ZipInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                Action action;
                String name = entry.getName();
                if (entry.isDirectory() || (action = ExtractJarsTransform.getAction(name, extractCode)) != Action.COPY) continue;
                File outputFile = new File(outJarFolder, name.replace('/', File.separatorChar));
                FileUtils.mkdirs((File)outputFile.getParentFile());
                Closer closer2 = Closer.create();
                try {
                    OutputStream outputStream = (OutputStream)closer2.register((Closeable)new BufferedOutputStream(new FileOutputStream(outputFile)));
                    ByteStreams.copy((InputStream)zis, (OutputStream)outputStream);
                    outputStream.flush();
                }
                finally {
                    closer2.close();
                }
            }
        }
        finally {
            closer.close();
        }
    }

    public static Action getAction(String archivePath, boolean extractCode) {
        if ("META-INF/MANIFEST.MF".equals(archivePath)) {
            return Action.IGNORE;
        }
        String[] segments = archivePath.split("/");
        if (segments.length == 0) {
            return Action.IGNORE;
        }
        for (int i = 0; i < segments.length - 1; ++i) {
            if (PackagingUtils.checkFolderForPackaging((String)segments[i])) continue;
            return Action.IGNORE;
        }
        String fileName = segments[segments.length - 1];
        return PackagingUtils.checkFileForPackaging((String)fileName, (boolean)extractCode) ? Action.COPY : Action.IGNORE;
    }

    private static File getFolder(File outFolder, File jarFile) {
        return new File(outFolder, jarFile.getName() + "-" + jarFile.getPath().hashCode());
    }

    static enum Action {
        COPY,
        IGNORE;

    }
}

